/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.manager;

import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.injection.producer.BasicInjectionTarget;
import org.jboss.weld.injection.producer.BeanInjectionTarget;
import org.jboss.weld.injection.producer.DecoratorInjectionTarget;
import org.jboss.weld.injection.producer.InjectionTargetInitializationContext;
import org.jboss.weld.injection.producer.InjectionTargetService;
import org.jboss.weld.injection.producer.LifecycleCallbackInvoker;
import org.jboss.weld.injection.producer.NonProducibleInjectionTarget;
import org.jboss.weld.injection.producer.NoopLifecycleCallbackInvoker;
import org.jboss.weld.injection.producer.ejb.SessionBeanInjectionTarget;
import org.jboss.weld.injection.spi.InjectionServices;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.api.WeldInjectionTargetFactory;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.reflection.Reflections;

public class InjectionTargetFactoryImpl<T>
implements WeldInjectionTargetFactory<T> {
    private final BeanManagerImpl manager;
    private final EnhancedAnnotatedType<T> type;
    private final InjectionTargetService injectionTargetService;
    private final InjectionServices injectionServices;

    protected InjectionTargetFactoryImpl(AnnotatedType<T> type, BeanManagerImpl manager) {
        this.manager = manager;
        this.type = manager.getServices().get(ClassTransformer.class).getEnhancedAnnotatedType(type, manager.getId());
        this.injectionTargetService = manager.getServices().get(InjectionTargetService.class);
        this.injectionServices = manager.getServices().get(InjectionServices.class);
    }

    @Override
    public InjectionTarget<T> createInjectionTarget(Bean<T> bean) {
        return this.createInjectionTarget(bean, false);
    }

    @Override
    public InjectionTarget<T> createInterceptorInjectionTarget() {
        return this.createInjectionTarget(null, true);
    }

    private InjectionTarget<T> createInjectionTarget(Bean<T> bean, boolean interceptor) {
        try {
            BasicInjectionTarget<T> injectionTarget = this.createInjectionTarget(this.type, bean, interceptor);
            this.injectionTargetService.validateProducer(injectionTarget);
            return injectionTarget;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public BasicInjectionTarget<T> createInjectionTarget(EnhancedAnnotatedType<T> type, Bean<T> bean, boolean interceptor) {
        BasicInjectionTarget<T> injectionTarget = this.chooseInjectionTarget(type, bean, interceptor);
        this.injectionTargetService.addInjectionTargetToBeInitialized(new InjectionTargetInitializationContext<T>(type, injectionTarget));
        this.postProcessInjectionTarget(type, injectionTarget);
        return injectionTarget;
    }

    private BasicInjectionTarget<T> chooseInjectionTarget(EnhancedAnnotatedType<T> type, Bean<T> bean, boolean interceptor) {
        if (bean instanceof Decorator || type.isAnnotationPresent(javax.decorator.Decorator.class)) {
            return new DecoratorInjectionTarget<T>(type, bean, this.manager);
        }
        if (type.isAbstract()) {
            if (type.getJavaClass().isInterface()) {
                throw BeanLogger.LOG.injectionTargetCannotBeCreatedForInterface(type);
            }
            BeanLogger.LOG.injectionTargetCreatedForAbstractClass(type.getJavaClass());
            return new NonProducibleInjectionTarget<T>(type, bean, this.manager);
        }
        if (Reflections.isNonStaticInnerClass(type.getJavaClass())) {
            BeanLogger.LOG.injectionTargetCreatedForNonStaticInnerClass(type.getJavaClass());
            return new NonProducibleInjectionTarget<T>(type, bean, this.manager);
        }
        if (Beans.getBeanConstructor(type) == null) {
            if (bean != null) {
                throw BeanLogger.LOG.injectionTargetCreatedForClassWithoutAppropriateConstructorException(type.getJavaClass());
            }
            BeanLogger.LOG.injectionTargetCreatedForClassWithoutAppropriateConstructor(type.getJavaClass());
            return new NonProducibleInjectionTarget<T>(type, bean, this.manager);
        }
        if (bean instanceof SessionBean) {
            return new SessionBeanInjectionTarget<T>(type, (SessionBean)bean, this.manager);
        }
        if (interceptor) {
            return new InterceptorInjectionTarget<T>(type, this.manager);
        }
        return new BeanInjectionTarget<T>(type, bean, this.manager);
    }

    protected InjectionTarget<T> createMessageDrivenInjectionTarget() {
        try {
            BasicInjectionTarget<T> injectionTarget = new BasicInjectionTarget<T>(this.type, null, this.manager);
            this.postProcessInjectionTarget(this.type, injectionTarget);
            this.injectionTargetService.validateProducer(injectionTarget);
            return injectionTarget;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    private <X> void postProcessInjectionTarget(AnnotatedType<X> type, InjectionTarget<X> injectionTarget) {
        if (this.injectionServices != null) {
            this.injectionServices.registerInjectionTarget(injectionTarget, type);
        }
    }

    private static class InterceptorInjectionTarget<T>
    extends BasicInjectionTarget<T> {
        public InterceptorInjectionTarget(EnhancedAnnotatedType<T> type, BeanManagerImpl beanManager) {
            super(type, null, beanManager);
        }

        @Override
        protected LifecycleCallbackInvoker<T> initInvoker(EnhancedAnnotatedType<T> type) {
            return NoopLifecycleCallbackInvoker.getInstance();
        }
    }
}

