/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet;

import java.util.Arrays;
import javax.el.ELContextListener;
import javax.enterprise.inject.spi.BeanManager;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;
import org.jboss.logging.Logger;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.CDI11Bootstrap;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.environment.Container;
import org.jboss.weld.environment.ContainerContext;
import org.jboss.weld.environment.gwtdev.GwtDevHostedModeContainer;
import org.jboss.weld.environment.jetty.JettyContainer;
import org.jboss.weld.environment.servlet.deployment.ServletDeployment;
import org.jboss.weld.environment.servlet.deployment.URLScanner;
import org.jboss.weld.environment.servlet.services.ServletResourceInjectionServices;
import org.jboss.weld.environment.servlet.util.Reflections;
import org.jboss.weld.environment.servlet.util.ServiceLoader;
import org.jboss.weld.environment.tomcat.TomcatContainer;
import org.jboss.weld.injection.spi.ResourceInjectionServices;
import org.jboss.weld.manager.api.WeldManager;
import org.jboss.weld.servlet.api.ServletListener;

public class WeldServletLifecycle {
    public static final String BEAN_MANAGER_ATTRIBUTE_NAME = WeldServletLifecycle.class.getPackage().getName() + "." + BeanManager.class.getName();
    private static final String CONTEXT_ID_KEY = "WELD_CONTEXT_ID_KEY";
    static final String INSTANCE_ATTRIBUTE_NAME = WeldServletLifecycle.class.getPackage().getName() + ".lifecycleInstance";
    private static final Logger log = Logger.getLogger(WeldServletLifecycle.class);
    private static final String BOOTSTRAP_IMPL_CLASS_NAME = "org.jboss.weld.bootstrap.WeldBootstrap";
    private static final String WELD_LISTENER_CLASS_NAME = "org.jboss.weld.servlet.WeldInitialListener";
    private static final String EXPRESSION_FACTORY_NAME = "org.jboss.weld.el.ExpressionFactory";
    private final transient CDI11Bootstrap bootstrap;
    private final transient ServletListener weldListener;
    private Container container;
    private boolean isBootstrapNeeded = true;

    WeldServletLifecycle() {
        try {
            this.bootstrap = (CDI11Bootstrap)Reflections.newInstance(BOOTSTRAP_IMPL_CLASS_NAME);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Error loading Weld bootstrap, check that Weld is on the classpath", e);
        }
        try {
            this.weldListener = (ServletListener)Reflections.newInstance(WELD_LISTENER_CLASS_NAME);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Error loading Weld listener, check that Weld is on the classpath", e);
        }
    }

    void initialize(ServletContext context, URLScanner scanner) {
        StringBuilder dump;
        ContainerContext containerContext;
        Container container;
        WeldManager manager = (WeldManager)context.getAttribute(BEAN_MANAGER_ATTRIBUTE_NAME);
        if (manager != null) {
            this.isBootstrapNeeded = false;
        }
        if (this.isBootstrapNeeded) {
            ServletDeployment deployment = this.createServletDeployment(context, this.bootstrap, scanner);
            try {
                deployment.getWebAppBeanDeploymentArchive().getServices().add(ResourceInjectionServices.class, new ServletResourceInjectionServices(){});
            }
            catch (NoClassDefFoundError e) {
                log.warn("@Resource injection not available in simple beans");
            }
            String id = context.getInitParameter(CONTEXT_ID_KEY);
            if (id != null) {
                this.bootstrap.startContainer(id, Environments.SERVLET, deployment);
            } else {
                this.bootstrap.startContainer(Environments.SERVLET, deployment);
            }
            this.bootstrap.startInitialization();
            manager = this.bootstrap.getManager(deployment.getWebAppBeanDeploymentArchive());
            context.setAttribute(BEAN_MANAGER_ATTRIBUTE_NAME, (Object)manager);
        }
        if ((container = this.findContainer(containerContext = new ContainerContext(context, manager), dump = new StringBuilder())) == null) {
            log.info("No supported servlet container detected, CDI injection will NOT be available in Servlets, Filters or Listeners");
            log.debugv("Exception dump from Container lookup: {0}", (Object)dump);
        } else {
            container.initialize(containerContext);
            this.container = container;
        }
        if (JspFactory.getDefaultFactory() != null) {
            JspApplicationContext jspApplicationContext = JspFactory.getDefaultFactory().getJspApplicationContext(context);
            jspApplicationContext.addELResolver(manager.getELResolver());
            try {
                jspApplicationContext.addELContextListener((ELContextListener)Reflections.newInstance("org.jboss.weld.el.WeldELContextListener"));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("Error loading Weld ELContext Listener, check that Weld is on the classpath", e);
            }
            context.setAttribute(EXPRESSION_FACTORY_NAME, (Object)manager.wrapExpressionFactory(jspApplicationContext.getExpressionFactory()));
        }
        if (this.isBootstrapNeeded) {
            this.bootstrap.deployBeans().validateBeans().endInitialization();
        }
    }

    void destroy(ServletContext context) {
        if (this.isBootstrapNeeded) {
            this.bootstrap.shutdown();
        }
        if (this.container != null) {
            this.container.destroy(new ContainerContext(context, null));
        }
    }

    ServletListener getWeldListener() {
        return this.weldListener;
    }

    protected ServletDeployment createServletDeployment(ServletContext context, Bootstrap bootstrap, URLScanner scanner) {
        return new ServletDeployment(context, bootstrap, scanner);
    }

    protected Container findContainer(ContainerContext cc, StringBuilder dump) {
        Iterable<Container> extContainers = ServiceLoader.load(Container.class, this.getClass().getClassLoader());
        Container container = this.checkContainers(cc, dump, extContainers);
        if (container == null) {
            container = this.checkContainers(cc, dump, Arrays.asList(TomcatContainer.INSTANCE, JettyContainer.INSTANCE, GwtDevHostedModeContainer.INSTANCE));
        }
        return container;
    }

    protected Container checkContainers(ContainerContext cc, StringBuilder dump, Iterable<Container> containers) {
        for (Container c : containers) {
            try {
                if (!c.touch(cc)) continue;
                return c;
            }
            catch (Throwable t) {
                dump.append(c).append("->").append(t.getMessage()).append("\n");
            }
        }
        return null;
    }
}

