/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.deployment.discovery;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipFile;
import org.jboss.logging.Logger;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.spi.BeanDiscoveryMode;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.environment.deployment.AbstractWeldDeployment;
import org.jboss.weld.environment.deployment.WeldResourceLoader;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveScanner;
import org.jboss.weld.environment.logging.CommonLogger;
import org.jboss.weld.resources.spi.ResourceLoader;

public class DefaultBeanArchiveScanner
implements BeanArchiveScanner {
    private static final Logger log = Logger.getLogger(DefaultBeanArchiveScanner.class);
    protected final ResourceLoader resourceLoader;
    protected final Bootstrap bootstrap;

    public DefaultBeanArchiveScanner(ResourceLoader resourceLoader, Bootstrap bootstrap) {
        this.resourceLoader = resourceLoader;
        this.bootstrap = bootstrap;
    }

    @Override
    public Map<BeansXml, String> scan() {
        String[] resources;
        HashMap<BeansXml, String> beansXmlMap = new HashMap<BeansXml, String>();
        for (String resourceName : resources = AbstractWeldDeployment.RESOURCES) {
            for (URL beansXmlUrl : this.resourceLoader.getResources(resourceName)) {
                BeansXml beansXml = this.bootstrap.parse(beansXmlUrl);
                if (!this.accept(beansXml)) continue;
                beansXmlMap.put(beansXml, this.getBeanArchiveReference(beansXmlUrl));
            }
        }
        return beansXmlMap;
    }

    protected boolean accept(BeansXml beansXml) {
        return !BeanDiscoveryMode.NONE.equals((Object)beansXml.getBeanDiscoveryMode());
    }

    protected String getBeanArchiveReference(URL url) {
        String ref = null;
        URI uri = null;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            CommonLogger.LOG.couldNotReadResource(url, e);
        }
        if ("file".equals(url.getProtocol())) {
            ref = new File(uri.getSchemeSpecificPart()).getParentFile().getParent();
        } else {
            if ("jar".equals(url.getProtocol())) {
                ref = uri.getSchemeSpecificPart();
                if (ref.lastIndexOf("!/") > 0) {
                    ref = ref.substring(0, ref.lastIndexOf("!/"));
                }
                return this.getBeanArchiveReferenceForJar(ref, url);
            }
            log.warnv("Unable to adapt URL: {0}, using its external form instead", (Object)url);
            ref = url.toExternalForm();
        }
        log.debugv("Resolved bean archive reference: {0} for URL: {1}", (Object)ref, (Object)url);
        return ref;
    }

    protected String getBeanArchiveReferenceForJar(String path, URL fallback) {
        if (path.startsWith("file:")) {
            return path.substring("file:".length());
        }
        if (path.startsWith("http") || path.startsWith("https")) {
            ClassLoader jnlpClassLoader = WeldResourceLoader.getClassLoader();
            try {
                Method m = jnlpClassLoader.getClass().getMethod("getJarFile", URL.class);
                ZipFile jarFile = (ZipFile)m.invoke((Object)jnlpClassLoader, new URL(path));
                return jarFile.getName();
            }
            catch (NoSuchMethodException nsme) {
                CommonLogger.LOG.unexpectedClassLoader(nsme);
            }
            catch (IllegalArgumentException iarge) {
                CommonLogger.LOG.unexpectedClassLoader(iarge);
            }
            catch (InvocationTargetException ite) {
                CommonLogger.LOG.jnlpClassLoaderInternalException(ite);
            }
            catch (Exception iacce) {
                CommonLogger.LOG.jnlpClassLoaderInvocationException(iacce);
            }
        }
        log.warnv("Unable to adapt JAR file URL: {0}, using its external form instead", (Object)path);
        return fallback.toExternalForm();
    }
}

