/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.weld.Container;
import org.jboss.weld.context.RequestContext;
import org.jboss.weld.context.unbound.UnboundLiteral;
import org.jboss.weld.event.CurrentEventMetadata;
import org.jboss.weld.event.EventPacket;
import org.jboss.weld.logging.EventLogger;

public class DeferredEventNotification<T>
implements Runnable {
    protected final ObserverMethod<? super T> observer;
    protected final EventPacket<T> eventPacket;
    private final CurrentEventMetadata currentEventMetadata;
    private final String contextId;

    public DeferredEventNotification(String contextId, EventPacket<T> eventPacket, ObserverMethod<? super T> observer, CurrentEventMetadata currentEventMetadata) {
        this.contextId = contextId;
        this.observer = observer;
        this.eventPacket = eventPacket;
        this.currentEventMetadata = currentEventMetadata;
    }

    @Override
    public void run() {
        try {
            EventLogger.LOG.asyncFire(this.eventPacket, this.observer);
            new RunInRequest(this.contextId){

                @Override
                protected void execute() {
                    DeferredEventNotification.this.currentEventMetadata.push(DeferredEventNotification.this.eventPacket);
                    try {
                        DeferredEventNotification.this.observer.notify(DeferredEventNotification.this.eventPacket.getPayload());
                    }
                    finally {
                        DeferredEventNotification.this.currentEventMetadata.pop();
                    }
                }
            }.run();
        }
        catch (Exception e) {
            EventLogger.LOG.asyncObserverFailure(this.eventPacket);
            EventLogger.LOG.catchingDebug(e);
        }
    }

    public String toString() {
        return "Deferred event [" + this.eventPacket.getPayload() + "] for [" + this.observer + "]";
    }

    private static abstract class RunInRequest {
        private final String contextId;

        public RunInRequest(String contextId) {
            this.contextId = contextId;
        }

        protected abstract void execute();

        public void run() {
            if (this.isRequestContextActive()) {
                this.execute();
            } else {
                RequestContext requestContext = (RequestContext)Container.instance(this.contextId).deploymentManager().instance().select(RequestContext.class, UnboundLiteral.INSTANCE).get();
                try {
                    requestContext.activate();
                    this.execute();
                }
                finally {
                    requestContext.invalidate();
                    requestContext.deactivate();
                }
            }
        }

        private boolean isRequestContextActive() {
            for (RequestContext requestContext : Container.instance(this.contextId).deploymentManager().instance().select(RequestContext.class, new Annotation[0])) {
                if (!requestContext.isActive()) continue;
                return true;
            }
            return false;
        }
    }
}

