/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.builtin;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.context.spi.AlterableContext;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.util.TypeLiteral;
import org.jboss.weld.bean.builtin.AbstractFacade;
import org.jboss.weld.bean.builtin.DynamicLookupInjectionPoint;
import org.jboss.weld.bean.builtin.FacadeInjectionPoint;
import org.jboss.weld.bean.proxy.ProxyMethodHandler;
import org.jboss.weld.bean.proxy.ProxyObject;
import org.jboss.weld.context.WeldCreationalContext;
import org.jboss.weld.exceptions.InvalidObjectException;
import org.jboss.weld.injection.CurrentInjectionPoint;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.logging.BeanManagerLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.resolution.ResolvableBuilder;
import org.jboss.weld.resolution.TypeSafeBeanResolver;
import org.jboss.weld.util.collections.WeldCollections;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;

@SuppressWarnings(value={"SE_NO_SUITABLE_CONSTRUCTOR", "SE_BAD_FIELD"}, justification="Uses SerializationProxy")
public class InstanceImpl<T>
extends AbstractFacade<T, Instance<T>>
implements Instance<T>,
Serializable {
    private static final long serialVersionUID = -376721889693284887L;
    private final transient Set<Bean<?>> allBeans;
    private final transient Bean<?> bean;
    private final transient CurrentInjectionPoint currentInjectionPoint;
    private final transient InjectionPoint ip;

    public static <I> Instance<I> of(InjectionPoint injectionPoint, CreationalContext<I> creationalContext, BeanManagerImpl beanManager) {
        return new InstanceImpl<I>(injectionPoint, creationalContext, beanManager);
    }

    private InstanceImpl(InjectionPoint injectionPoint, CreationalContext<? super T> creationalContext, BeanManagerImpl beanManager) {
        super(injectionPoint, creationalContext, beanManager);
        Resolvable resolvable = new ResolvableBuilder(this.getType(), this.getBeanManager()).addQualifiers(this.getQualifiers()).setDeclaringBean(this.getInjectionPoint().getBean()).create();
        TypeSafeBeanResolver beanResolver = this.getBeanManager().getBeanResolver();
        this.allBeans = beanResolver.resolve((Set)beanResolver.resolve(resolvable, Reflections.isCacheable(this.getQualifiers())));
        this.bean = this.allBeans.size() == 1 ? this.allBeans.iterator().next() : null;
        this.currentInjectionPoint = beanManager.getServices().get(CurrentInjectionPoint.class);
        this.ip = new DynamicLookupInjectionPoint(this.getInjectionPoint(), this.getType(), this.getQualifiers());
    }

    @Override
    public T get() {
        if (this.bean != null) {
            return this.getBeanInstance(this.bean);
        }
        if (this.isUnsatisfied()) {
            throw BeanManagerLogger.LOG.unresolvableElement("Type: " + this.getType() + "; Qualifiers: " + this.getQualifiers());
        }
        throw BeanManagerLogger.LOG.ambiguousBeansForDependency(WeldCollections.toMultiRowString(this.allBeans));
    }

    public String toString() {
        return Formats.formatAnnotations(this.getQualifiers()) + " Instance<" + Formats.formatType(this.getType()) + ">";
    }

    @Override
    public Iterator<T> iterator() {
        return new InstanceImplIterator(this.allBeans);
    }

    @Override
    public boolean isAmbiguous() {
        return this.allBeans.size() > 1;
    }

    @Override
    public boolean isUnsatisfied() {
        return this.allBeans.isEmpty();
    }

    @Override
    public Instance<T> select(Annotation ... qualifiers) {
        return this.selectInstance(this.getType(), qualifiers);
    }

    @Override
    public <U extends T> Instance<U> select(Class<U> subtype, Annotation ... qualifiers) {
        return this.selectInstance(subtype, qualifiers);
    }

    @Override
    public <U extends T> Instance<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
        return this.selectInstance(subtype.getType(), qualifiers);
    }

    private <U extends T> Instance<U> selectInstance(Type subtype, Annotation[] newQualifiers) {
        FacadeInjectionPoint modifiedInjectionPoint = new FacadeInjectionPoint(this.getBeanManager(), this.getInjectionPoint(), subtype, this.getQualifiers(), newQualifiers);
        return new InstanceImpl(modifiedInjectionPoint, this.getCreationalContext(), this.getBeanManager());
    }

    @Override
    public void destroy(T instance) {
        ProxyObject proxy;
        Preconditions.checkNotNull(instance);
        if (instance instanceof ProxyObject && (proxy = (ProxyObject)instance).getHandler() instanceof ProxyMethodHandler) {
            ProxyMethodHandler handler = (ProxyMethodHandler)proxy.getHandler();
            Bean<?> bean = handler.getBean();
            Context context = this.getBeanManager().getContext(bean.getScope());
            if (context instanceof AlterableContext) {
                AlterableContext alterableContext = (AlterableContext)context;
                alterableContext.destroy(bean);
                return;
            }
            throw BeanLogger.LOG.destroyUnsupported(context);
        }
        CreationalContext ctx = this.getCreationalContext();
        if (ctx instanceof WeldCreationalContext) {
            WeldCreationalContext weldCtx = (WeldCreationalContext)Reflections.cast(ctx);
            weldCtx.destroyDependentInstance(instance);
        }
    }

    private T getBeanInstance(Bean<?> bean) {
        try {
            this.currentInjectionPoint.push(this.ip);
            Object t = Reflections.cast(this.getBeanManager().getReference(bean, this.getType(), this.getCreationalContext(), false));
            return t;
        }
        finally {
            this.currentInjectionPoint.pop();
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw BeanLogger.LOG.proxyRequired();
    }

    final class InstanceImplIterator
    implements Iterator<T> {
        private final Iterator<Bean<?>> delegate;

        private InstanceImplIterator(Set<Bean<?>> beans) {
            this.delegate = beans.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public T next() {
            return InstanceImpl.this.getBeanInstance(this.delegate.next());
        }

        @Override
        public void remove() {
            throw BeanLogger.LOG.instanceIteratorRemoveUnsupported();
        }
    }

    private static class SerializationProxy<T>
    extends AbstractFacade.AbstractFacadeSerializationProxy<T, Instance<T>> {
        private static final long serialVersionUID = 9181171328831559650L;

        public SerializationProxy(InstanceImpl<T> instance) {
            super(instance);
        }

        private Object readResolve() throws ObjectStreamException {
            return InstanceImpl.of(this.getInjectionPoint(), this.getCreationalContext(), this.getBeanManager());
        }
    }
}

