/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import org.jboss.classfilewriter.AccessFlag;
import org.jboss.classfilewriter.ClassFile;
import org.jboss.classfilewriter.ClassMethod;
import org.jboss.classfilewriter.DuplicateMemberException;
import org.jboss.classfilewriter.code.BranchEnd;
import org.jboss.classfilewriter.code.CodeAttribute;
import org.jboss.classfilewriter.util.Boxing;
import org.jboss.classfilewriter.util.DescriptorUtils;
import org.jboss.weld.Container;
import org.jboss.weld.bean.proxy.BeanInstance;
import org.jboss.weld.bean.proxy.BytecodeMethodResolver;
import org.jboss.weld.bean.proxy.ClassHierarchyComparator;
import org.jboss.weld.bean.proxy.CommonProxiedMethodFilters;
import org.jboss.weld.bean.proxy.DefaultBytecodeMethodResolver;
import org.jboss.weld.bean.proxy.GroovyMethodFilter;
import org.jboss.weld.bean.proxy.MethodHandler;
import org.jboss.weld.bean.proxy.ProtectionDomainCache;
import org.jboss.weld.bean.proxy.ProxiedMethodFilter;
import org.jboss.weld.bean.proxy.ProxyInstantiator;
import org.jboss.weld.bean.proxy.ProxyMethodHandler;
import org.jboss.weld.bean.proxy.ProxyObject;
import org.jboss.weld.config.WeldConfiguration;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.interceptor.proxy.LifecycleMixin;
import org.jboss.weld.interceptor.util.proxy.TargetInstanceProxy;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.security.GetDeclaredConstructorsAction;
import org.jboss.weld.security.GetDeclaredMethodsAction;
import org.jboss.weld.security.GetProtectionDomainAction;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.serialization.spi.ProxyServices;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.bytecode.BytecodeUtils;
import org.jboss.weld.util.bytecode.ClassFileUtils;
import org.jboss.weld.util.bytecode.ConstructorUtils;
import org.jboss.weld.util.bytecode.DeferredBytecode;
import org.jboss.weld.util.bytecode.MethodInformation;
import org.jboss.weld.util.bytecode.RuntimeMethodInformation;
import org.jboss.weld.util.collections.ArraySet;
import org.jboss.weld.util.collections.Arrays2;
import org.jboss.weld.util.reflection.Reflections;

public class ProxyFactory<T>
implements PrivilegedAction<T> {
    public static final String PROXY_SUFFIX = "$Proxy$";
    public static final String DEFAULT_PROXY_PACKAGE = "org.jboss.weld.proxies";
    private final Class<?> beanType;
    private final Set<Class<?>> additionalInterfaces = new LinkedHashSet();
    private final ClassLoader classLoader;
    private final String baseProxyName;
    private final Bean<?> bean;
    private final Class<?> proxiedBeanType;
    private final String contextId;
    private final WeldConfiguration configuration;
    public static final String CONSTRUCTED_FLAG_NAME = "constructed";
    private final ProxyInstantiator proxyInstantiator;
    protected static final BytecodeMethodResolver DEFAULT_METHOD_RESOLVER = new DefaultBytecodeMethodResolver();
    protected static final String LJAVA_LANG_REFLECT_METHOD = "Ljava/lang/reflect/Method;";
    protected static final String LJAVA_LANG_BYTE = "Ljava/lang/Byte;";
    protected static final String LJAVA_LANG_CLASS = "Ljava/lang/Class;";
    protected static final String LJAVA_LANG_OBJECT = "Ljava/lang/Object;";
    protected static final String LBEAN_IDENTIFIER = "Lorg/jboss/weld/serialization/spi/BeanIdentifier;";
    protected static final String LJAVA_LANG_STRING = "Ljava/lang/String;";
    protected static final String LJAVA_LANG_THREAD_LOCAL = "Ljava/lang/ThreadLocal;";
    protected static final String INIT_METHOD_NAME = "<init>";
    protected static final String METHOD_HANDLER_FIELD_NAME = "methodHandler";
    private static final String JAVA = "java";
    private static final Set<ProxiedMethodFilter> METHOD_FILTERS;
    private static final boolean CONFIGURABLE_ACCESS_FLAGS;

    public ProxyFactory(String contextId, Class<?> proxiedBeanType, Set<? extends Type> typeClosure, Bean<?> bean) {
        this(contextId, proxiedBeanType, typeClosure, bean, false);
    }

    public ProxyFactory(String contextId, Class<?> proxiedBeanType, Set<? extends Type> typeClosure, Bean<?> bean, boolean forceSuperClass) {
        this(contextId, proxiedBeanType, typeClosure, ProxyFactory.getProxyName(contextId, proxiedBeanType, typeClosure, bean), bean, forceSuperClass);
    }

    public ProxyFactory(String contextId, Class<?> proxiedBeanType, Set<? extends Type> typeClosure, String proxyName, Bean<?> bean) {
        this(contextId, proxiedBeanType, typeClosure, proxyName, bean, false);
    }

    public ProxyFactory(String contextId, Class<?> proxiedBeanType, Set<? extends Type> typeClosure, String proxyName, Bean<?> bean, boolean forceSuperClass) {
        this.bean = bean;
        this.contextId = contextId;
        this.proxiedBeanType = proxiedBeanType;
        this.configuration = Container.instance(contextId).deploymentManager().getServices().get(WeldConfiguration.class);
        this.addInterfacesFromTypeClosure(typeClosure, proxiedBeanType);
        Proxies.TypeInfo typeInfo = Proxies.TypeInfo.of(typeClosure);
        Class<Object> superClass = typeInfo.getSuperClass();
        Class clazz = superClass = superClass == null ? Object.class : superClass;
        if (forceSuperClass || superClass.equals(Object.class) && this.additionalInterfaces.isEmpty()) {
            superClass = proxiedBeanType;
        }
        this.beanType = superClass;
        this.addDefaultAdditionalInterfaces();
        this.baseProxyName = proxyName;
        this.classLoader = bean != null ? ProxyFactory.resolveClassLoaderForBeanProxy(contextId, bean.getBeanClass(), typeInfo) : ProxyFactory.resolveClassLoaderForBeanProxy(contextId, proxiedBeanType, typeInfo);
        ArrayList list = new ArrayList(this.additionalInterfaces);
        Collections.sort(list, ClassHierarchyComparator.INSTANCE);
        this.additionalInterfaces.clear();
        this.additionalInterfaces.addAll(list);
        this.proxyInstantiator = Container.instance(contextId).services().get(ProxyInstantiator.class);
    }

    static String getProxyName(String contextId, Class<?> proxiedBeanType, Set<? extends Type> typeClosure, Bean<?> bean) {
        String className;
        String proxyPackage;
        Proxies.TypeInfo typeInfo = Proxies.TypeInfo.of(typeClosure);
        if (proxiedBeanType.equals(Object.class)) {
            Class<?> superInterface = typeInfo.getSuperInterface();
            if (superInterface == null) {
                throw new IllegalArgumentException("Proxied bean type cannot be java.lang.Object without an interface");
            }
            proxyPackage = DEFAULT_PROXY_PACKAGE;
        } else {
            proxyPackage = proxiedBeanType.getPackage() == null ? DEFAULT_PROXY_PACKAGE : proxiedBeanType.getPackage().getName();
        }
        if (typeInfo.getSuperClass() == Object.class) {
            StringBuilder name = new StringBuilder();
            className = ProxyFactory.createCompoundProxyName(contextId, bean, typeInfo, name) + PROXY_SUFFIX;
        } else {
            boolean typeModified = false;
            for (Class<?> iface : typeInfo.getInterfaces()) {
                if (iface.isAssignableFrom(typeInfo.getSuperClass())) continue;
                typeModified = true;
                break;
            }
            if (typeModified) {
                StringBuilder name = new StringBuilder(typeInfo.getSuperClass().getSimpleName() + "$");
                className = ProxyFactory.createCompoundProxyName(contextId, bean, typeInfo, name) + PROXY_SUFFIX;
            } else {
                className = typeInfo.getSuperClass().getSimpleName() + PROXY_SUFFIX;
            }
        }
        return proxyPackage + '.' + ProxyFactory.getEnclosingPrefix(proxiedBeanType) + className;
    }

    public void addInterfacesFromTypeClosure(Set<? extends Type> typeClosure, Class<?> proxiedBeanType) {
        for (Type type : typeClosure) {
            Class c = Reflections.getRawType(type);
            if (!c.isInterface()) continue;
            this.addInterface(c);
        }
    }

    private static String createCompoundProxyName(String contextId, Bean<?> bean, Proxies.TypeInfo typeInfo, StringBuilder name) {
        ArrayList<String> interfaces = new ArrayList<String>();
        for (Class<?> type : typeInfo.getInterfaces()) {
            interfaces.add(type.getSimpleName());
        }
        Collections.sort(interfaces);
        for (String iface : interfaces) {
            name.append(iface);
            name.append('$');
        }
        if (bean != null) {
            BeanIdentifier id = Container.instance(contextId).services().get(ContextualStore.class).putIfAbsent(bean);
            int idHash = id.hashCode();
            name.append(Math.abs(idHash == Integer.MIN_VALUE ? 0 : idHash));
        }
        String className = name.toString();
        return className;
    }

    private static String getEnclosingPrefix(Class<?> clazz) {
        Class<?> encl = clazz.getEnclosingClass();
        return encl == null ? "" : ProxyFactory.getEnclosingPrefix(encl) + encl.getSimpleName() + '$';
    }

    protected boolean isCreatingProxy() {
        return true;
    }

    public void addInterface(Class<?> newInterface) {
        if (!newInterface.isInterface()) {
            throw new IllegalArgumentException(newInterface + " is not an interface");
        }
        this.additionalInterfaces.add(newInterface);
    }

    public T create(BeanInstance beanInstance) {
        T proxy = System.getSecurityManager() == null ? this.run() : AccessController.doPrivileged(this);
        ((ProxyObject)proxy).setHandler(new ProxyMethodHandler(this.contextId, beanInstance, this.bean));
        return proxy;
    }

    @Override
    public T run() {
        try {
            return this.proxyInstantiator.newInstance(this.getProxyClass());
        }
        catch (InstantiationException e) {
            throw new DefinitionException(BeanLogger.LOG.proxyInstantiationFailed(this), e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new DefinitionException(BeanLogger.LOG.proxyInstantiationBeanAccessFailed(this), e.getCause());
        }
    }

    public Class<T> getProxyClass() {
        String suffix = "_$$_Weld" + this.getProxyNameSuffix();
        String proxyClassName = this.getBaseProxyName();
        if (!proxyClassName.endsWith(suffix)) {
            proxyClassName = proxyClassName + suffix;
        }
        if (proxyClassName.startsWith(JAVA)) {
            proxyClassName = proxyClassName.replaceFirst(JAVA, "org.jboss.weld");
        }
        Class proxyClass = null;
        BeanLogger.LOG.generatingProxyClass(proxyClassName);
        try {
            proxyClass = (Class)Reflections.cast(this.classLoader.loadClass(proxyClassName));
        }
        catch (ClassNotFoundException e) {
            try {
                proxyClass = this.createProxyClass(proxyClassName);
            }
            catch (Throwable e1) {
                try {
                    proxyClass = (Class)Reflections.cast(this.classLoader.loadClass(proxyClassName));
                }
                catch (ClassNotFoundException e2) {
                    throw BeanLogger.LOG.unableToLoadProxyClass(this.bean, this.proxiedBeanType, this.classLoader, e1);
                }
            }
        }
        return proxyClass;
    }

    protected Class<T> getCachedProxyClass(String proxyClassName) {
        try {
            return (Class)Reflections.cast(this.classLoader.loadClass(proxyClassName));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    protected String getBaseProxyName() {
        return this.baseProxyName;
    }

    public static boolean isProxy(Object proxySuspect) {
        return proxySuspect instanceof ProxyObject;
    }

    public static <T> void setBeanInstance(String contextId, T proxy, BeanInstance beanInstance, Bean<?> bean) {
        if (proxy instanceof ProxyObject) {
            ProxyObject proxyView = (ProxyObject)proxy;
            proxyView.setHandler(new ProxyMethodHandler(contextId, beanInstance, bean));
        }
    }

    protected String getProxyNameSuffix() {
        return PROXY_SUFFIX;
    }

    private void addDefaultAdditionalInterfaces() {
        this.additionalInterfaces.add(Serializable.class);
    }

    protected void addAdditionalInterfaces(Set<Class<?>> interfaces) {
    }

    private Class<T> createProxyClass(String proxyClassName) throws Exception {
        ArraySet specialInterfaces = new ArraySet(LifecycleMixin.class, TargetInstanceProxy.class, ProxyObject.class);
        this.addAdditionalInterfaces(specialInterfaces);
        this.additionalInterfaces.removeAll(specialInterfaces);
        ClassFile proxyClassType = null;
        int accessFlags = AccessFlag.of(1, 32, 4096);
        if (this.getBeanType().isInterface()) {
            proxyClassType = ProxyFactory.newClassFile(proxyClassName, accessFlags, Object.class.getName(), new String[0]);
            proxyClassType.addInterface(this.getBeanType().getName());
        } else {
            proxyClassType = ProxyFactory.newClassFile(proxyClassName, accessFlags, this.getBeanType().getName(), new String[0]);
        }
        for (Class<?> clazz : this.additionalInterfaces) {
            proxyClassType.addInterface(clazz.getName());
        }
        ArrayList<DeferredBytecode> initialValueBytecode = new ArrayList<DeferredBytecode>();
        ClassMethod staticConstructor = proxyClassType.addMethod(AccessFlag.of(1, 8), "<clinit>", "V", new String[0]);
        this.addFields(proxyClassType, initialValueBytecode);
        this.addConstructors(proxyClassType, initialValueBytecode);
        this.addMethods(proxyClassType, staticConstructor);
        staticConstructor.getCodeAttribute().returnInstruction();
        for (Class<?> specialInterface : specialInterfaces) {
            proxyClassType.addInterface(specialInterface.getName());
        }
        this.dumpToFile(proxyClassName, proxyClassType.toBytecode());
        ProtectionDomain domain = AccessController.doPrivileged(new GetProtectionDomainAction(this.proxiedBeanType));
        if (this.proxiedBeanType.getPackage() == null || this.proxiedBeanType.equals(Object.class)) {
            domain = ProxyFactory.class.getProtectionDomain();
        } else if (System.getSecurityManager() != null) {
            ProtectionDomainCache cache = Container.instance(this.contextId).services().get(ProtectionDomainCache.class);
            domain = cache.getProtectionDomainForProxy(domain);
        }
        Class proxyClass = (Class)Reflections.cast(ClassFileUtils.toClass(proxyClassType, this.classLoader, domain));
        BeanLogger.LOG.createdProxyClass(proxyClass, Arrays.toString(proxyClass.getInterfaces()));
        return proxyClass;
    }

    private static ClassFile newClassFile(String name, int accessFlags, String superclass, String ... interfaces) {
        if (CONFIGURABLE_ACCESS_FLAGS) {
            return new ClassFile(name, accessFlags, superclass, interfaces);
        }
        return new ClassFile(name, superclass, interfaces);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpToFile(String fileName, byte[] data) {
        File proxyDumpFilePath = this.configuration.getProxyDumpFilePath();
        if (proxyDumpFilePath == null) {
            return;
        }
        FileOutputStream dumpFileStream = null;
        File classFile = new File(proxyDumpFilePath, fileName + ".class");
        try {
            if (classFile.isFile() && !classFile.delete()) {
                throw new IOException("Can not to remove file: " + classFile.getName());
            }
            dumpFileStream = new FileOutputStream(classFile);
            dumpFileStream.write(data);
        }
        catch (IOException e) {
            BeanLogger.LOG.beanCannotBeDumped(fileName, e);
        }
        finally {
            try {
                if (dumpFileStream != null) {
                    dumpFileStream.close();
                }
            }
            catch (IOException e) {
                BeanLogger.LOG.beanCannotBeDumped(fileName, e);
            }
        }
    }

    protected void addConstructors(ClassFile proxyClassType, List<DeferredBytecode> initialValueBytecode) {
        try {
            if (this.getBeanType().isInterface()) {
                ConstructorUtils.addDefaultConstructor(proxyClassType, initialValueBytecode, !this.proxyInstantiator.isUsingConstructor());
            } else {
                boolean constructorFound = false;
                for (Constructor<?> constructor : AccessController.doPrivileged(new GetDeclaredConstructorsAction(this.getBeanType()))) {
                    if ((constructor.getModifiers() & 2) != 0) continue;
                    constructorFound = true;
                    String[] exceptions = new String[constructor.getExceptionTypes().length];
                    for (int i = 0; i < exceptions.length; ++i) {
                        exceptions[i] = constructor.getExceptionTypes()[i].getName();
                    }
                    ConstructorUtils.addConstructor("V", DescriptorUtils.parameterDescriptors(constructor.getParameterTypes()), exceptions, proxyClassType, initialValueBytecode, !this.proxyInstantiator.isUsingConstructor());
                }
                if (!constructorFound) {
                    this.addConstructorsForBeanWithPrivateConstructors(proxyClassType);
                }
            }
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    protected void addFields(ClassFile proxyClassType, List<DeferredBytecode> initialValueBytecode) {
        proxyClassType.addField(2, METHOD_HANDLER_FIELD_NAME, this.getMethodHandlerType());
        if (this.proxyInstantiator.isUsingConstructor()) {
            proxyClassType.addField(2, CONSTRUCTED_FLAG_NAME, "Z");
        }
    }

    protected Class<? extends MethodHandler> getMethodHandlerType() {
        return MethodHandler.class;
    }

    protected void addMethods(ClassFile proxyClassType, ClassMethod staticConstructor) {
        this.addMethodsFromClass(proxyClassType, staticConstructor);
        this.addSpecialMethods(proxyClassType, staticConstructor);
        this.addSerializationSupport(proxyClassType);
    }

    protected void addSerializationSupport(ClassFile proxyClassType) {
    }

    protected void addMethodsFromClass(ClassFile proxyClassType, ClassMethod staticConstructor) {
        try {
            this.generateEqualsMethod(proxyClassType);
            this.generateHashCodeMethod(proxyClassType);
            for (Class<?> cls = this.getBeanType(); cls != null; cls = cls.getSuperclass()) {
                this.addMethods(cls, proxyClassType, staticConstructor);
                if (cls != this.getBeanType() || !Modifier.isAbstract(cls.getModifiers())) continue;
                for (Class<?> implementedInterface : Reflections.getInterfaceClosure(cls)) {
                    if (this.additionalInterfaces.contains(implementedInterface)) continue;
                    this.addMethods(implementedInterface, proxyClassType, staticConstructor);
                }
            }
            for (Class<?> c : this.additionalInterfaces) {
                for (Method method : c.getMethods()) {
                    if (!this.isMethodAccepted(method)) continue;
                    try {
                        RuntimeMethodInformation methodInfo = new RuntimeMethodInformation(method);
                        ClassMethod classMethod = proxyClassType.addMethod(method);
                        this.createSpecialMethodBody(classMethod, methodInfo, staticConstructor);
                        BeanLogger.LOG.addingMethodToProxy(method);
                    }
                    catch (DuplicateMemberException duplicateMemberException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    private void addMethods(Class<?> cls, ClassFile proxyClassType, ClassMethod staticConstructor) {
        for (Method method : AccessController.doPrivileged(new GetDeclaredMethodsAction(cls))) {
            if (!this.isMethodAccepted(method)) continue;
            try {
                RuntimeMethodInformation methodInfo = new RuntimeMethodInformation(method);
                ClassMethod classMethod = proxyClassType.addMethod(method);
                this.addConstructedGuardToMethodBody(classMethod);
                this.createForwardingMethodBody(classMethod, methodInfo, staticConstructor);
                BeanLogger.LOG.addingMethodToProxy(method);
            }
            catch (DuplicateMemberException duplicateMemberException) {
                // empty catch block
            }
        }
    }

    private boolean isMethodAccepted(Method method) {
        for (ProxiedMethodFilter filter : METHOD_FILTERS) {
            if (filter.accept(method)) continue;
            return false;
        }
        return true;
    }

    protected void generateHashCodeMethod(ClassFile proxyClassType) {
    }

    protected void generateEqualsMethod(ClassFile proxyClassType) {
    }

    protected void createSpecialMethodBody(ClassMethod proxyClassType, MethodInformation method, ClassMethod staticConstructor) {
        this.createInterceptorBody(proxyClassType, method, staticConstructor);
    }

    protected void addConstructedGuardToMethodBody(ClassMethod classMethod) {
        if (!this.proxyInstantiator.isUsingConstructor()) {
            return;
        }
        CodeAttribute cond = classMethod.getCodeAttribute();
        cond.aload(0);
        cond.getfield(classMethod.getClassFile().getName(), CONSTRUCTED_FLAG_NAME, "Z");
        BranchEnd jumpMarker = cond.ifne();
        cond.aload(0);
        cond.loadMethodParameters();
        cond.invokespecial(classMethod.getClassFile().getSuperclass(), classMethod.getName(), classMethod.getDescriptor());
        cond.returnInstruction();
        cond.branchEnd(jumpMarker);
    }

    protected void createForwardingMethodBody(ClassMethod classMethod, MethodInformation method, ClassMethod staticConstructor) {
        this.createInterceptorBody(classMethod, method, staticConstructor);
    }

    protected void createInterceptorBody(ClassMethod classMethod, MethodInformation method, ClassMethod staticConstructor) {
        this.invokeMethodHandler(classMethod, method, true, DEFAULT_METHOD_RESOLVER, staticConstructor);
    }

    protected void invokeMethodHandler(ClassMethod classMethod, MethodInformation method, boolean addReturnInstruction, BytecodeMethodResolver bytecodeMethodResolver, ClassMethod staticConstructor) {
        CodeAttribute b = classMethod.getCodeAttribute();
        b.aload(0);
        this.getMethodHandlerField(classMethod.getClassFile(), b);
        b.aload(0);
        bytecodeMethodResolver.getDeclaredMethod(classMethod, method.getDeclaringClass(), method.getName(), method.getParameterTypes(), staticConstructor);
        b.aconstNull();
        b.iconst(method.getParameterTypes().length);
        b.anewarray("java.lang.Object");
        int localVariableCount = 1;
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            String typeString = method.getParameterTypes()[i];
            b.dup();
            b.iconst(i);
            BytecodeUtils.addLoadInstruction(b, typeString, localVariableCount);
            Boxing.boxIfNessesary(b, typeString);
            b.aastore();
            if (DescriptorUtils.isWide(typeString)) {
                localVariableCount += 2;
                continue;
            }
            ++localVariableCount;
        }
        b.invokeinterface(MethodHandler.class.getName(), "invoke", LJAVA_LANG_OBJECT, new String[]{LJAVA_LANG_OBJECT, LJAVA_LANG_REFLECT_METHOD, LJAVA_LANG_REFLECT_METHOD, "[Ljava/lang/Object;"});
        if (addReturnInstruction) {
            if (method.getReturnType().equals("V")) {
                b.returnInstruction();
            } else if (DescriptorUtils.isPrimitive(method.getReturnType())) {
                Boxing.unbox(b, method.getReturnType());
                b.returnInstruction();
            } else {
                String castType = method.getReturnType();
                if (!method.getReturnType().startsWith("[")) {
                    castType = method.getReturnType().substring(1).substring(0, method.getReturnType().length() - 2);
                }
                b.checkcast(castType);
                b.returnInstruction();
            }
        }
    }

    protected void addSpecialMethods(ClassFile proxyClassType, ClassMethod staticConstructor) {
        try {
            for (Method method : LifecycleMixin.class.getMethods()) {
                BeanLogger.LOG.addingMethodToProxy(method);
                RuntimeMethodInformation methodInfo = new RuntimeMethodInformation(method);
                ClassMethod classMethod = proxyClassType.addMethod(method);
                this.createInterceptorBody(classMethod, methodInfo, staticConstructor);
            }
            Method getInstanceMethod = TargetInstanceProxy.class.getMethod("getTargetInstance", new Class[0]);
            Method getInstanceClassMethod = TargetInstanceProxy.class.getMethod("getTargetClass", new Class[0]);
            RuntimeMethodInformation getInstanceMethodInfo = new RuntimeMethodInformation(getInstanceMethod);
            this.createInterceptorBody(proxyClassType.addMethod(getInstanceMethod), getInstanceMethodInfo, staticConstructor);
            RuntimeMethodInformation getInstanceClassMethodInfo = new RuntimeMethodInformation(getInstanceClassMethod);
            this.createInterceptorBody(proxyClassType.addMethod(getInstanceClassMethod), getInstanceClassMethodInfo, staticConstructor);
            Method setMethodHandlerMethod = ProxyObject.class.getMethod("setHandler", MethodHandler.class);
            this.generateSetMethodHandlerBody(proxyClassType.addMethod(setMethodHandlerMethod));
            Method getMethodHandlerMethod = ProxyObject.class.getMethod("getHandler", new Class[0]);
            this.generateGetMethodHandlerBody(proxyClassType.addMethod(getMethodHandlerMethod));
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    protected void generateSetMethodHandlerBody(ClassMethod method) {
        CodeAttribute b = method.getCodeAttribute();
        b.aload(0);
        b.aload(1);
        b.checkcast(this.getMethodHandlerType());
        b.putfield(method.getClassFile().getName(), METHOD_HANDLER_FIELD_NAME, DescriptorUtils.makeDescriptor(this.getMethodHandlerType()));
        b.returnInstruction();
    }

    protected void generateGetMethodHandlerBody(ClassMethod method) {
        CodeAttribute b = method.getCodeAttribute();
        b.aload(0);
        this.getMethodHandlerField(method.getClassFile(), b);
        b.returnInstruction();
    }

    private void addConstructorsForBeanWithPrivateConstructors(ClassFile proxyClassType) {
        ClassMethod ctor = proxyClassType.addMethod(1, INIT_METHOD_NAME, "V", LJAVA_LANG_BYTE);
        CodeAttribute b = ctor.getCodeAttribute();
        b.aload(0);
        b.aconstNull();
        b.aconstNull();
        b.invokespecial(proxyClassType.getName(), INIT_METHOD_NAME, "(Ljava/lang/Byte;Ljava/lang/Byte;)V");
        b.returnInstruction();
        ctor = proxyClassType.addMethod(1, INIT_METHOD_NAME, "V", LJAVA_LANG_BYTE, LJAVA_LANG_BYTE);
        b = ctor.getCodeAttribute();
        b.aload(0);
        b.aconstNull();
        b.invokespecial(proxyClassType.getName(), INIT_METHOD_NAME, "(Ljava/lang/Byte;)V");
        b.returnInstruction();
    }

    public Class<?> getBeanType() {
        return this.beanType;
    }

    public Set<Class<?>> getAdditionalInterfaces() {
        return this.additionalInterfaces;
    }

    public Bean<?> getBean() {
        return this.bean;
    }

    public String getContextId() {
        return this.contextId;
    }

    public static ClassLoader resolveClassLoaderForBeanProxy(String contextId, Class<?> proxiedType, Proxies.TypeInfo typeInfo) {
        Class<?> superClass = typeInfo.getSuperClass();
        if (superClass.getName().startsWith(JAVA)) {
            ClassLoader cl = Container.instance(contextId).services().get(ProxyServices.class).getClassLoader(proxiedType);
            if (cl == null) {
                cl = Thread.currentThread().getContextClassLoader();
            }
            return cl;
        }
        return Container.instance(contextId).services().get(ProxyServices.class).getClassLoader(superClass);
    }

    protected void getMethodHandlerField(ClassFile file, CodeAttribute b) {
        b.getfield(file.getName(), METHOD_HANDLER_FIELD_NAME, DescriptorUtils.makeDescriptor(this.getMethodHandlerType()));
    }

    static {
        Constructor temp = null;
        try {
            temp = ClassFile.class.getConstructor(String.class, Integer.TYPE, String.class, Arrays2.EMPTY_STRING_ARRAY.getClass());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        CONFIGURABLE_ACCESS_FLAGS = temp != null;
        HashSet<ProxiedMethodFilter> filters = new HashSet<ProxiedMethodFilter>();
        filters.add(CommonProxiedMethodFilters.NON_STATIC);
        filters.add(CommonProxiedMethodFilters.NON_FINAL);
        filters.add(CommonProxiedMethodFilters.OBJECT_TO_STRING);
        GroovyMethodFilter groovy = new GroovyMethodFilter();
        if (groovy.isEnabled()) {
            filters.add(groovy);
        }
        METHOD_FILTERS = ImmutableSet.copyOf(filters);
    }
}

