/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.util.Set;
import org.jboss.weld.annotated.enhanced.MethodSignature;
import org.jboss.weld.annotated.enhanced.jlr.MethodSignatureImpl;
import org.jboss.weld.bean.proxy.ProxiedMethodFilter;
import org.jboss.weld.resources.WeldClassLoaderResourceLoader;
import org.jboss.weld.util.reflection.Reflections;

public class GroovyMethodFilter
implements ProxiedMethodFilter {
    private static final String GROOVY_OBJECT = "groovy.lang.GroovyObject";
    private static final Set<MethodSignature> METHODS = ImmutableSet.of(new MethodSignatureImpl("invokeMethod", String.class.getName(), Object.class.getName()), new MethodSignatureImpl("getProperty", String.class.getName()), new MethodSignatureImpl("setProperty", String.class.getName(), Object.class.getName()), new MethodSignatureImpl("getMetaClass", new String[0]), new MethodSignatureImpl("setMetaClass", "groovy.lang.MetaClass"));

    @Override
    public boolean isEnabled() {
        return Reflections.isClassLoadable(GROOVY_OBJECT, WeldClassLoaderResourceLoader.INSTANCE);
    }

    @Override
    public boolean accept(Method method) {
        if (GROOVY_OBJECT.equals(method.getDeclaringClass().getName())) {
            return false;
        }
        for (MethodSignature groovyMethod : METHODS) {
            if (!groovyMethod.matches(method)) continue;
            return false;
        }
        return true;
    }
}

