/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet;

import java.util.EventListener;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletException;
import javax.servlet.ServletRequestEvent;
import javax.servlet.http.HttpSessionEvent;
import org.jboss.weld.environment.servlet.Listener;
import org.jboss.weld.environment.servlet.WeldServletLifecycle;
import org.jboss.weld.environment.servlet.logging.WeldServletLogger;
import org.jboss.weld.servlet.api.ServletListener;
import org.jboss.weld.servlet.api.helpers.ForwardingServletListener;

public class EnhancedListener
extends ForwardingServletListener
implements ServletContainerInitializer {
    public static final String ENHANCED_LISTENER_USED_ATTRIBUTE_NAME = EnhancedListener.class.getPackage().getName() + ".enhancedListenerUsed";
    private boolean isOriginalListenerUsed = false;
    private WeldServletLifecycle lifecycle;

    public void onStartup(Set<Class<?>> classes, ServletContext context) throws ServletException {
        WeldServletLogger.LOG.initializeWeldUsingServletContainerInitializer();
        context.setAttribute(ENHANCED_LISTENER_USED_ATTRIBUTE_NAME, (Object)Boolean.TRUE);
        this.lifecycle = new WeldServletLifecycle();
        this.lifecycle.initialize(context);
        context.setAttribute(WeldServletLifecycle.INSTANCE_ATTRIBUTE_NAME, (Object)this.lifecycle);
        context.addListener((EventListener)((Object)this));
        super.contextInitialized(new ServletContextEvent(context));
    }

    @Override
    public void contextInitialized(ServletContextEvent sce) {
        if (Boolean.TRUE.equals(sce.getServletContext().getAttribute(Listener.LISTENER_USED_ATTRIBUTE_NAME))) {
            this.isOriginalListenerUsed = true;
            WeldServletLogger.LOG.listenerUserForServletRequestAndHttpSessionNotifications();
        }
    }

    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        super.contextDestroyed(sce);
        this.lifecycle.destroy(sce.getServletContext());
    }

    @Override
    public void requestDestroyed(ServletRequestEvent sre) {
        if (this.isOriginalListenerUsed) {
            return;
        }
        super.requestDestroyed(sre);
    }

    @Override
    public void requestInitialized(ServletRequestEvent sre) {
        if (this.isOriginalListenerUsed) {
            return;
        }
        super.requestInitialized(sre);
    }

    @Override
    public void sessionCreated(HttpSessionEvent se) {
        if (this.isOriginalListenerUsed) {
            return;
        }
        super.sessionCreated(se);
    }

    @Override
    public void sessionDestroyed(HttpSessionEvent se) {
        if (this.isOriginalListenerUsed) {
            return;
        }
        super.sessionDestroyed(se);
    }

    @Override
    protected ServletListener delegate() {
        return this.lifecycle.getWeldListener();
    }
}

