/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.deployment;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.jboss.logging.Logger;

public class URLScanner {
    private static final Logger log = Logger.getLogger(URLScanner.class);
    private static final String CLASS_FILENAME_EXTENSION = ".class";
    private static final String COULD_NOT_READ = "could not read: ";
    private static final String SEPARATOR = "!/";
    private final ClassLoader classLoader;

    public URLScanner(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected void handle(String name, URL url, Set<String> classes, Set<URL> urls) {
        if (name.endsWith(CLASS_FILENAME_EXTENSION)) {
            classes.add(URLScanner.filenameToClassname(name));
        } else if (name.equals("META-INF/beans.xml")) {
            urls.add(url);
        }
    }

    public void scanDirectories(File[] directories, Set<String> classes, Set<URL> urls) {
        for (File directory : directories) {
            this.handleDirectory(directory, null, classes, urls);
        }
    }

    public void scanURLs(URL[] resources, Set<String> classes, Set<URL> urls) {
        for (URL res : resources) {
            this.handleURL(res, classes, urls);
        }
    }

    public void scanResources(String[] resources, Set<String> classes, Set<URL> urls) {
        HashSet<String> paths = new HashSet<String>();
        for (String resourceName : resources) {
            try {
                Enumeration<URL> urlEnum = this.classLoader.getResources(resourceName);
                while (urlEnum.hasMoreElements()) {
                    URL url = urlEnum.nextElement();
                    String urlPath = url.toURI().getSchemeSpecificPart();
                    String fileUrlType = "file:";
                    if (urlPath.startsWith("file:")) {
                        urlPath = urlPath.substring("file:".length());
                    }
                    if (urlPath.indexOf(SEPARATOR) > 0) {
                        urlPath = urlPath.substring(0, urlPath.indexOf(SEPARATOR));
                    } else {
                        File dirOrArchive = new File(urlPath);
                        if (resourceName != null && resourceName.lastIndexOf(47) > 0) {
                            dirOrArchive = dirOrArchive.getParentFile();
                        }
                        urlPath = dirOrArchive.getParent();
                    }
                    paths.add(urlPath);
                }
            }
            catch (IOException ioe) {
                log.warn((Object)(COULD_NOT_READ + resourceName), (Throwable)ioe);
            }
            catch (URISyntaxException e) {
                log.warn((Object)(COULD_NOT_READ + resourceName), (Throwable)e);
            }
        }
        this.handle(paths, classes, urls);
    }

    protected void handle(Set<String> paths, Set<String> classes, Set<URL> urls) {
        for (String urlPath : paths) {
            try {
                log.tracev("scanning: {0}", (Object)urlPath);
                File file = new File(urlPath);
                if (file.isDirectory()) {
                    this.handleDirectory(file, null, classes, urls);
                    continue;
                }
                this.handleArchiveByFile(file, classes, urls);
            }
            catch (IOException ioe) {
                log.warn((Object)"could not read entries", (Throwable)ioe);
            }
        }
    }

    protected void handleArchiveByFile(File file, Set<String> classes, Set<URL> urls) throws IOException {
        try {
            log.tracev("archive: {0}", (Object)file);
            ZipFile zip = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                String entryUrlString = "jar:" + new File(file.getPath() + SEPARATOR + name).toURI().toURL().toExternalForm();
                if (name.endsWith("/") && !entryUrlString.endsWith("/")) {
                    entryUrlString = entryUrlString + "/";
                }
                URL entryUrl = new URL(entryUrlString);
                this.handle(name, entryUrl, classes, urls);
            }
            zip.close();
        }
        catch (ZipException e) {
            throw new RuntimeException("Error handling file " + file, e);
        }
    }

    private void handleDirectory(File file, String path, Set<String> classes, Set<URL> urls) {
        this.handleDirectory(file, path, new File[0], classes, urls);
    }

    private void handleDirectory(File file, String path, File[] excludedDirectories, Set<String> classes, Set<URL> urls) {
        for (File excludedDirectory : excludedDirectories) {
            if (!file.equals(excludedDirectory)) continue;
            log.tracev("skipping excluded directory: {0}", (Object)file);
            return;
        }
        log.tracev("handling directory: {0}", (Object)file);
        for (File child : file.listFiles()) {
            String newPath;
            String string = newPath = path == null ? child.getName() : path + '/' + child.getName();
            if (child.isDirectory()) {
                this.handleDirectory(child, newPath, excludedDirectories, classes, urls);
                continue;
            }
            try {
                this.handle(newPath, child.toURI().toURL(), classes, urls);
            }
            catch (MalformedURLException e) {
                log.errorv("Error loading file {0}", (Object)newPath);
            }
        }
    }

    protected void handleURL(URL url, Set<String> classes, Set<URL> urls) {
        log.warn((Object)"Not implemented.");
    }

    public static String filenameToClassname(String filename) {
        return filename.substring(0, filename.lastIndexOf(CLASS_FILENAME_EXTENSION)).replace('/', '.').replace('\\', '.');
    }
}

