/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.jboss.weld.environment.servlet.EnhancedListener;
import org.jboss.weld.environment.servlet.WeldServletLifecycle;
import org.jboss.weld.environment.servlet.logging.WeldServletLogger;
import org.jboss.weld.servlet.api.ServletListener;
import org.jboss.weld.servlet.api.helpers.ForwardingServletListener;

public class Listener
extends ForwardingServletListener {
    public static final String LISTENER_USED_ATTRIBUTE_NAME = EnhancedListener.class.getPackage().getName() + ".listenerUsed";
    private boolean isEnhancedListenerUsed;
    private WeldServletLifecycle lifecycle;

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        this.lifecycle = (WeldServletLifecycle)context.getAttribute(WeldServletLifecycle.INSTANCE_ATTRIBUTE_NAME);
        if (this.lifecycle != null) {
            this.isEnhancedListenerUsed = true;
        }
        context.setAttribute(LISTENER_USED_ATTRIBUTE_NAME, (Object)Boolean.TRUE);
        if (this.isEnhancedListenerUsed) {
            WeldServletLogger.LOG.enhancedListenerUsedForNotifications();
            return;
        }
        WeldServletLogger.LOG.initializeWeldUsingServletContextListener();
        this.lifecycle = new WeldServletLifecycle();
        this.lifecycle.initialize(context);
        super.contextInitialized(sce);
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (this.isEnhancedListenerUsed || this.lifecycle == null) {
            return;
        }
        super.contextDestroyed(sce);
        this.lifecycle.destroy(sce.getServletContext());
    }

    protected ServletListener delegate() {
        return this.lifecycle.getWeldListener();
    }
}

