/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.jboss.weld.environment.servlet.logging.WeldServletLogger;

public class BeanManagerResourceBindingListener
implements ServletContextListener {
    private static final String RESOURCES_CONTEXT = "java:comp/env";
    private static final String BEAN_MANAGER_JNDI_NAME = "BeanManager";
    private static final String QUALIFIED_BEAN_MANAGER_JNDI_NAME = "java:comp/env/BeanManager";
    private static final String BEAN_MANAGER_OBJECT_FACTORY = "org.jboss.weld.resources.ManagerObjectFactory";
    private boolean bound = false;

    public void contextInitialized(ServletContextEvent sce) {
        block12: {
            try {
                InitialContext ctx = new InitialContext();
                boolean present = false;
                try {
                    NamingEnumeration<NameClassPair> entries = ctx.list(RESOURCES_CONTEXT);
                    while (entries.hasMoreElements()) {
                        try {
                            NameClassPair e = entries.next();
                            if (!e.getName().equals(BEAN_MANAGER_JNDI_NAME) || !e.getClassName().equals(BeanManager.class)) continue;
                            present = true;
                            break;
                        }
                        catch (Exception e) {
                            WeldServletLogger.LOG.problemWhenInterating(RESOURCES_CONTEXT, e);
                        }
                    }
                }
                catch (NamingException e) {
                    WeldServletLogger.LOG.couldNotReadContext(RESOURCES_CONTEXT);
                    try {
                        Context compCtx = (Context)ctx.lookup("java:comp");
                        compCtx.createSubcontext("env");
                    }
                    catch (Exception ex) {
                        WeldServletLogger.LOG.couldntCreateContext(RESOURCES_CONTEXT);
                    }
                }
                if (present) break block12;
                try {
                    ctx.rebind(QUALIFIED_BEAN_MANAGER_JNDI_NAME, (Object)new Reference(BeanManager.class.getName(), BEAN_MANAGER_OBJECT_FACTORY, null));
                    this.bound = true;
                    WeldServletLogger.LOG.beanManagerReferenceBoundTo(QUALIFIED_BEAN_MANAGER_JNDI_NAME);
                }
                catch (NamingException e) {
                    throw WeldServletLogger.LOG.couldNotBindBeanManagerReferenceToJNDI(e.getExplanation());
                }
            }
            catch (NamingException e) {
                throw WeldServletLogger.LOG.couldNotCreateInitialContext(e.getExplanation());
            }
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (this.bound) {
            try {
                InitialContext ctx = new InitialContext();
                ctx.unbind(QUALIFIED_BEAN_MANAGER_JNDI_NAME);
                WeldServletLogger.LOG.successfullyUnboundBeanManagerReference();
            }
            catch (NamingException e) {
                WeldServletLogger.LOG.failedToUnbindBeanManagerReference();
            }
        }
    }
}

