/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.security.ConstructorNewInstanceAction;
import org.jboss.weld.security.MethodLookupAction;
import org.jboss.weld.security.NewInstanceAction;

final class SecurityActions {
    private SecurityActions() {
    }

    static <T> T newInstance(Class<T> javaClass) throws InstantiationException, IllegalAccessException {
        if (System.getSecurityManager() != null) {
            try {
                return AccessController.doPrivileged(NewInstanceAction.of(javaClass));
            }
            catch (PrivilegedActionException e) {
                throw new WeldException(e.getCause());
            }
        }
        return javaClass.newInstance();
    }

    static Method lookupMethod(Class<?> javaClass, String methodName, Class<?>[] parameterTypes) throws NoSuchMethodException {
        if (System.getSecurityManager() != null) {
            try {
                return (Method)AccessController.doPrivileged(new MethodLookupAction(javaClass, methodName, (Class[])parameterTypes));
            }
            catch (PrivilegedActionException e) {
                if (e.getCause() instanceof NoSuchMethodException) {
                    throw (NoSuchMethodException)e.getCause();
                }
                throw new WeldException(e.getCause());
            }
        }
        return MethodLookupAction.lookupMethod(javaClass, (String)methodName, (Class[])parameterTypes);
    }

    static <T> T newConstructorInstance(Class<T> javaClass, Class<?>[] constructorParamTypes, Object ... constructorParamInstances) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (System.getSecurityManager() != null) {
            try {
                return AccessController.doPrivileged(ConstructorNewInstanceAction.of(javaClass, (Class[])constructorParamTypes, (Object[])constructorParamInstances));
            }
            catch (PrivilegedActionException e) {
                throw new WeldException(e.getCause());
            }
        }
        return javaClass.getConstructor(constructorParamTypes).newInstance(constructorParamInstances);
    }
}

