/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.deployment;

import jakarta.servlet.ServletContext;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveBuilder;
import org.jboss.weld.environment.deployment.discovery.jandex.Jandex;
import org.jboss.weld.environment.logging.CommonLogger;
import org.jboss.weld.environment.servlet.deployment.ServletContextBeanArchiveHandler;

public class JandexServletContextBeanArchiveHandler
extends ServletContextBeanArchiveHandler {
    private final Indexer indexer = new Indexer();

    public JandexServletContextBeanArchiveHandler(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public BeanArchiveBuilder handle(String path) {
        BeanArchiveBuilder builder = super.handle(path);
        if (builder == null) {
            return null;
        }
        builder.setAttribute(Jandex.INDEX_ATTRIBUTE_NAME, (Object)this.buildIndex());
        return builder;
    }

    private void addToIndex(InputStream inputStream) {
        try {
            this.indexer.index(inputStream);
        }
        catch (IOException ex) {
            CommonLogger.LOG.couldNotOpenStreamForURL((Object)inputStream, (Throwable)ex);
        }
    }

    @Override
    protected void add(String rootPath, String subpath, BeanArchiveBuilder builder) {
        super.add(rootPath, subpath, builder);
        this.addToIndex(this.servletContext.getResourceAsStream(subpath));
    }

    private Index buildIndex() {
        return this.indexer.complete();
    }
}

