/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.logging;

import java.io.Serializable;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.weld.environment.logging.WeldEnvironmentLogger;
import org.jboss.weld.environment.servlet.logging.JettyLogger;

public class JettyLogger_$logger
extends DelegatingBasicLogger
implements JettyLogger,
WeldEnvironmentLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = JettyLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public JettyLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void jettyDetectedListenersInjectionIsSupported() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.jettyDetectedListenersInjectionIsSupported$str(), new Object[0]);
    }

    protected String jettyDetectedListenersInjectionIsSupported$str() {
        return "WELD-ENV-001200: Jetty 7.2+ detected, CDI injection will be available in Servlets and Filters. Injection into Listeners should work on Jetty 9.1.1 and newer.";
    }

    @Override
    public final void jettyDetectedListenersInjectionIsNotSupported() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.jettyDetectedListenersInjectionIsNotSupported$str(), new Object[0]);
    }

    protected String jettyDetectedListenersInjectionIsNotSupported$str() {
        return "WELD-ENV-001201: Jetty 7.2+ detected, CDI injection will be available in Servlets and Filters. Injection into Listeners is not supported.";
    }

    @Override
    public final void unableToCreateJettyWeldInjector(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.unableToCreateJettyWeldInjector$str(), new Object[0]);
    }

    protected String unableToCreateJettyWeldInjector$str() {
        return "WELD-ENV-001202: Unable to create JettyWeldInjector. CDI injection will not be available in Servlets, Filters or Listeners.";
    }

    @Override
    public final void gwtHostedModeDetected() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.gwtHostedModeDetected$str(), new Object[0]);
    }

    protected String gwtHostedModeDetected$str() {
        return "WELD-ENV-001203: GWTHostedMode detected, JSR-299 injection will be available in Servlets and Filters. Injection into Listeners is not supported.";
    }

    @Override
    public final void cantFindInjector(Object param1) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.cantFindInjector$str(), param1);
    }

    protected String cantFindInjector$str() {
        return "WELD-ENV-001204: Can't find Injector in the servlet context so injection is not available for {0}.";
    }

    @Override
    public final void missingJettyEnv() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.missingJettyEnv$str(), new Object[0]);
    }

    protected String missingJettyEnv$str() {
        return "WELD-ENV-001205: Missing jetty-env.xml, no BeanManager present in JNDI.";
    }

    @Override
    public final void cantFindWebApplicationContext() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.cantFindWebApplicationContext$str(), new Object[0]);
    }

    protected String cantFindWebApplicationContext$str() {
        return "WELD-ENV-001206: Cannot find matching WebApplicationContext, no default CDI support: use jetty-web.xml";
    }

    @Override
    public final void cantFindInjectior(Object param1) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.cantFindInjectior$str(), param1);
    }

    protected String cantFindInjectior$str() {
        return "WELD-ENV-001207: Can't find Injector in the servlet context so injection is not available for {0}.";
    }

    @Override
    public final void missingJettyEnvXml() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.missingJettyEnvXml$str(), new Object[0]);
    }

    protected String missingJettyEnvXml$str() {
        return "WELD-ENV-001208: Missing jetty-env.xml, no BeanManager present in JNDI.";
    }

    @Override
    public final void cantFindMatchingWebApplicationContext() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.cantFindMatchingWebApplicationContext$str(), new Object[0]);
    }

    protected String cantFindMatchingWebApplicationContext$str() {
        return "WELD-ENV-001209: Cannot find matching WebApplicationContext, no default CDI support: use jetty-web.xml";
    }

    protected String noSuchJettyInjectorFound$str() {
        return "WELD-ENV-001210: No such Jetty injector found in servlet context attributes.";
    }

    @Override
    public final IllegalStateException noSuchJettyInjectorFound() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noSuchJettyInjectorFound$str(), new Object[0]));
        JettyLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    @Override
    public final void jettyDecorationIsSupported() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.jettyDecorationIsSupported$str(), new Object[0]);
    }

    protected String jettyDecorationIsSupported$str() {
        return "WELD-ENV-001211: Deprecated Jetty DecoratingListener support detected, CDI injection will be available in Listeners, Servlets and Filters.";
    }

    @Override
    public final void jettyCdiDecorationIsSupported() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.jettyCdiDecorationIsSupported$str(), new Object[0]);
    }

    protected String jettyCdiDecorationIsSupported$str() {
        return "WELD-ENV-001212: Jetty CdiDecoratingListener support detected, CDI injection will be available in Listeners, Servlets and Filters.";
    }

    @Override
    public final void jettyCdiSpiIsSupported() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.jettyCdiSpiIsSupported$str(), new Object[0]);
    }

    protected String jettyCdiSpiIsSupported$str() {
        return "WELD-ENV-001213: Jetty CDI SPI support detected, CDI injection will be available in Listeners, Servlets and Filters.";
    }

    protected String unknownIntegrationMode$str() {
        return "WELD-ENV-001214: Unknown Jetty integration mode: {0}";
    }

    @Override
    public final IllegalStateException unknownIntegrationMode(String mode) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.unknownIntegrationMode$str(), mode));
        JettyLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private String _formatMessage(String format, Object ... args) {
        MessageFormat formatter = new MessageFormat(format, this.getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public final void catchingDebug(Throwable arg0) {
        this.log.logf(FQCN, Logger.Level.DEBUG, arg0, this.catchingDebug$str(), new Object[0]);
    }

    protected String catchingDebug$str() {
        return "Catching";
    }

    public final void catchingTrace(Throwable arg0) {
        this.log.logf(FQCN, Logger.Level.TRACE, arg0, this.catchingTrace$str(), new Object[0]);
    }

    protected String catchingTrace$str() {
        return "Catching";
    }
}

