/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.logging;

import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.weld.environment.logging.WeldEnvironmentLogger;
import org.jboss.weld.environment.servlet.logging.Category;

@MessageLogger(projectCode="WELD-ENV-")
public interface WeldServletLogger
extends WeldEnvironmentLogger {
    public static final WeldServletLogger LOG = (WeldServletLogger)Logger.getMessageLogger(WeldServletLogger.class, (String)Category.WELDSERVLET.getName());

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1000, value="@Resource injection not available in simple beans")
    public void resourceInjectionNotAvailable();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1001, value="No supported servlet container detected, CDI injection will NOT be available in Servlets, Filters or Listeners")
    public void noSupportedServletContainerDetected();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1002, value="Container detection skipped - custom container class loaded: {0}.", format=Message.Format.MESSAGE_FORMAT)
    public void containerDetectionSkipped(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1003, value="Unable to instantiate custom container class: {0}.", format=Message.Format.MESSAGE_FORMAT)
    public void unableToInstantiateCustomContainerClass(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1004, value="Found both WEB-INF/beans.xml and WEB-INF/classes/META-INF/beans.xml. It is not portable to use both locations at the same time. Weld is going to use: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void foundBothConfiguration(Object var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1006, value="org.jboss.weld.environment.servlet.EnhancedListener used to initialize Weld")
    public void enhancedListenerUsedForNotifications();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1007, value="Initialize Weld using ServletContextListener")
    public void initializeWeldUsingServletContextListener();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1008, value="Initialize Weld using ServletContainerInitializer")
    public void initializeWeldUsingServletContainerInitializer();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1009, value="org.jboss.weld.environment.servlet.Listener used for ServletRequest and HttpSession notifications")
    public void listenerUserForServletRequestAndHttpSessionNotifications();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1010, value="Problem when iterating through {0}", format=Message.Format.MESSAGE_FORMAT)
    public void problemWhenInterating(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1011, value="Could not read context {0}: Trying to create it!", format=Message.Format.MESSAGE_FORMAT)
    public void couldNotReadContext(Object var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1012, value="BeanManager reference bound to {0}.", format=Message.Format.MESSAGE_FORMAT)
    public void beanManagerReferenceBoundTo(Object var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1013, value="Successfully unbound BeanManager reference.")
    public void successfullyUnboundBeanManagerReference();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1014, value="Failed to unbind BeanManager reference!")
    public void failedToUnbindBeanManagerReference();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1015, value="Could not create context: {0}.", format=Message.Format.MESSAGE_FORMAT)
    public void couldntCreateContext(Object var1);

    @Message(id=1016, value="Error loading resources from servlet context.")
    public IllegalStateException errorLoadingResources(@Cause Throwable var1);

    @Message(id=1017, value="Exception fetching BeanManager instance!")
    public IllegalStateException exceptionFetchingBeanManager(@Cause Throwable var1);

    @Message(id=1018, value="Not in a servlet or portlet environment!")
    public IllegalStateException notInAServletOrPortlet();

    @Message(id=1019, value="Error creating JNDI context")
    public IllegalStateException errorCreatingJNDIContext(@Cause Throwable var1);

    @Message(id=1022, value="No ServiceLoader class available!")
    public IllegalStateException noServiceLoaderClassAvailable();

    @Message(id=1023, value="No load method available on ServiceLoader - {0}.", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException noLoadMethodAvailableOnServiceLoader(Object var1, @Cause Throwable var2);

    @Message(id=1024, value="Could not bind BeanManager reference to JNDI: {0}\nIf the naming context is read-only, you may need to use a configuration to bind the BeanManager instead, such as Tomcat's context.xml or Jetty's jetty-web.xml.", format=Message.Format.MESSAGE_FORMAT)
    public RuntimeException couldNotBindBeanManagerReferenceToJNDI(Object var1);

    @Message(id=1025, value="Could not create InitialContext to bind BeanManager reference in JNDI: {0}.", format=Message.Format.MESSAGE_FORMAT)
    public RuntimeException couldNotCreateInitialContext(Object var1);

    @Message(id=1028, value="Error loading Weld ELContext Listener, check that Weld is on the classpath.")
    public IllegalStateException errorLoadingWeldELContextListener(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1029, value="org.jboss.weld.environment.servlet.Listener is in an inconsistent state - Weld Servlet cannot be shut down properly")
    public void noServletLifecycleToDestroy();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1030, value="Error handling library: {0}.", format=Message.Format.MESSAGE_FORMAT)
    public void cannotHandleLibrary(Object var1, @Cause Throwable var2);
}

