/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.jetty;

import jakarta.servlet.ServletContext;
import org.jboss.weld.environment.jetty.AbstractJettyContainer;
import org.jboss.weld.environment.jetty.WeldDecorator;
import org.jboss.weld.environment.servlet.Container;
import org.jboss.weld.environment.servlet.ContainerContext;
import org.jboss.weld.environment.servlet.logging.JettyLogger;
import org.jboss.weld.resources.spi.ResourceLoader;

public class JettyContainer
extends AbstractJettyContainer {
    public static final Container INSTANCE = new JettyContainer();
    public static final String JETTY_CDI_ATTRIBUTE = "org.eclipse.jetty.cdi";
    public static final String CDI_SPI_DECORATOR_MODE = "CdiSpiDecorator";
    public static final String CDI_DECORATING_LISTENER_MODE = "CdiDecoratingListener";
    public static final String CDI_DECORATING_LISTENER_ATTRIBUTE = "org.eclipse.jetty.cdi.decorator";

    @Override
    protected String classToCheck() {
        throw new UnsupportedOperationException("touch method reimplemented in JettyContainer");
    }

    @Override
    public boolean touch(ResourceLoader resourceLoader, ContainerContext context) throws Exception {
        ServletContext servletContext = context.getServletContext();
        return servletContext.getAttribute(JETTY_CDI_ATTRIBUTE) instanceof String;
    }

    @Override
    public void initialize(ContainerContext context) {
        try {
            String mode;
            ServletContext servletContext = context.getServletContext();
            switch (mode = (String)servletContext.getAttribute(JETTY_CDI_ATTRIBUTE)) {
                case "CdiSpiDecorator": {
                    JettyLogger.LOG.jettyCdiSpiIsSupported();
                    break;
                }
                case "CdiDecoratingListener": {
                    super.initialize(context);
                    servletContext.setAttribute(CDI_DECORATING_LISTENER_ATTRIBUTE, (Object)new WeldDecorator(servletContext));
                    JettyLogger.LOG.jettyCdiDecorationIsSupported();
                    break;
                }
                default: {
                    throw JettyLogger.LOG.unknownIntegrationMode(mode);
                }
            }
        }
        catch (Exception e) {
            JettyLogger.LOG.unableToCreateJettyWeldInjector(e);
        }
    }
}

