/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.jsf;

import javax.el.ELContextListener;
import javax.el.ExpressionFactory;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.jboss.weld.environment.servlet.jsf.ForwardingApplication;
import org.jboss.weld.environment.servlet.util.Reflections;

public class WeldApplication
extends ForwardingApplication {
    private static final ELContextListener[] EMPTY_LISTENERS = new ELContextListener[0];
    private final Application application;
    private ExpressionFactory expressionFactory;
    private BeanManager beanManager;

    public WeldApplication(Application application) {
        this.application = application;
    }

    private void init() {
        if (this.expressionFactory == null && this.application.getExpressionFactory() != null && this.beanManager() != null) {
            this.application.addELContextListener((ELContextListener)Reflections.newInstance("org.jboss.weld.el.WeldELContextListener"));
            this.application.addELResolver(this.beanManager().getELResolver());
            this.expressionFactory = this.beanManager().wrapExpressionFactory(this.application.getExpressionFactory());
        }
    }

    protected Application delegate() {
        this.init();
        return this.application;
    }

    public ExpressionFactory getExpressionFactory() {
        this.init();
        if (this.expressionFactory == null) {
            return this.application.getExpressionFactory();
        }
        return this.expressionFactory;
    }

    private BeanManager beanManager() {
        if (this.beanManager == null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (!(facesContext.getExternalContext().getContext() instanceof ServletContext)) {
                throw new IllegalStateException("Not in a servlet environment!");
            }
            ServletContext ctx = (ServletContext)facesContext.getExternalContext().getContext();
            if (ctx.getAttribute(BeanManager.class.getName()) == null) {
                return null;
            }
            this.beanManager = (BeanManager)ctx.getAttribute(BeanManager.class.getName());
        }
        return this.beanManager;
    }
}

