/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.PassivationCapable;
import org.jboss.weld.bootstrap.api.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextualStore
implements Service {
    private static final String GENERATED_ID_PREFIX = ContextualStore.class.getName();
    private final BiMap<Contextual<?>, String> contextuals;
    private final ConcurrentMap<String, Contextual<?>> passivationCapableContextuals;
    private final AtomicInteger idGenerator = new AtomicInteger(0);

    public ContextualStore() {
        HashBiMap map = HashBiMap.create();
        this.contextuals = Maps.synchronizedBiMap((BiMap)map);
        this.passivationCapableContextuals = new ConcurrentHashMap();
    }

    public <C extends Contextual<I>, I> C getContextual(String id) {
        if (id.startsWith(GENERATED_ID_PREFIX)) {
            return (C)((Contextual)this.contextuals.inverse().get((Object)id));
        }
        return (C)((Contextual)this.passivationCapableContextuals.get(id));
    }

    public String putIfAbsent(Contextual<?> contextual) {
        if (contextual instanceof PassivationCapable) {
            PassivationCapable passivationCapable = (PassivationCapable)contextual;
            this.passivationCapableContextuals.putIfAbsent(passivationCapable.getId(), contextual);
            return passivationCapable.getId();
        }
        if (this.contextuals.containsKey(contextual)) {
            return (String)this.contextuals.get(contextual);
        }
        String id = GENERATED_ID_PREFIX + this.idGenerator.incrementAndGet();
        this.contextuals.put(contextual, (Object)id);
        return id;
    }

    public void cleanup() {
        this.contextuals.clear();
    }
}

