/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.inject.Scope;
import org.jboss.interceptor.model.InterceptionModelBuilder;
import org.jboss.weld.BeanManagerImpl;
import org.jboss.weld.DefinitionException;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.DecoratorImpl;
import org.jboss.weld.bean.proxy.DecoratorProxyMethodHandler;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.context.SerializableContextual;
import org.jboss.weld.context.SerializableContextualInstance;
import org.jboss.weld.injection.FieldInjectionPoint;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.log.LogProvider;
import org.jboss.weld.log.Logging;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClassBean<T>
extends AbstractBean<T, Class<T>> {
    private static final LogProvider log = Logging.getLogProvider(AbstractClassBean.class);
    protected WeldClass<T> annotatedItem;
    private List<Set<FieldInjectionPoint<?, ?>>> injectableFields;
    private List<Set<MethodInjectionPoint<?, ?>>> initializerMethods;
    private Set<String> dependencies;
    private List<Decorator<?>> decorators;
    private Class<T> proxyClassForDecorators;
    private final ThreadLocal<Integer> decoratorStackPosition;
    private WeldMethod<?, ?> postConstruct;
    private WeldMethod<?, ?> preDestroy;
    private InjectionTarget<T> injectionTarget;

    protected AbstractClassBean(WeldClass<T> type, String idSuffix, BeanManagerImpl manager) {
        super(idSuffix, manager);
        this.annotatedItem = type;
        this.decoratorStackPosition = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return 0;
            }
        };
        this.initStereotypes();
        this.initPolicy();
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        this.initInitializerMethods();
        this.initInjectableFields();
        super.initialize(environment);
        this.checkBeanImplementation();
        this.initDecorators();
        this.checkType();
        this.initProxyClassForDecoratedBean();
        if (this.isInterceptionCandidate()) {
            this.initInterceptors();
        }
    }

    protected void checkType() {
    }

    protected void initDecorators() {
        this.decorators = this.getManager().resolveDecorators(this.getTypes(), this.getQualifiers());
    }

    public boolean hasDecorators() {
        return this.decorators != null && this.decorators.size() > 0;
    }

    protected void initProxyClassForDecoratedBean() {
        if (this.hasDecorators()) {
            Class proxyClass;
            LinkedHashSet<Type> types = new LinkedHashSet<Type>(this.getTypes());
            ProxyFactory proxyFactory = Proxies.getProxyFactory(types);
            this.proxyClassForDecorators = proxyClass = proxyFactory.createClass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T applyDecorators(T instance, CreationalContext<T> creationalContext, InjectionPoint originalInjectionPoint) {
        ArrayList<SerializableContextualInstance<DecoratorImpl<Object>, Object>> decoratorInstances = new ArrayList<SerializableContextualInstance<DecoratorImpl<Object>, Object>>();
        WeldInjectionPoint<?, ?> ip = originalInjectionPoint;
        boolean outside = this.decoratorStackPosition.get() == 0;
        try {
            int i = this.decoratorStackPosition.get();
            while (i < this.decorators.size()) {
                Decorator<?> decorator = this.decorators.get(i);
                if (decorator instanceof DecoratorImpl) {
                    this.decoratorStackPosition.set(++i);
                    DecoratorImpl decoratorBean = (DecoratorImpl)decorator;
                    Object decoratorInstance = this.getManager().getReference(ip, (Bean<?>)decorator, (CreationalContext<?>)creationalContext);
                    decoratorInstances.add(new SerializableContextualInstance<DecoratorImpl, Object>(decoratorBean, decoratorInstance, null));
                    ip = decoratorBean.getDelegateInjectionPoint();
                    continue;
                }
                throw new IllegalStateException("Cannot operate on non container provided decorator " + decorator);
            }
        }
        finally {
            if (outside) {
                this.decoratorStackPosition.remove();
            }
        }
        try {
            T proxy = this.proxyClassForDecorators.newInstance();
            ((ProxyObject)proxy).setHandler((MethodHandler)new DecoratorProxyMethodHandler(decoratorInstances, instance));
            return proxy;
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Could not instantiate decorator proxy for " + this.toString(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not access bean correctly when creating decorator proxy for " + this.toString(), e);
        }
    }

    public List<Decorator<?>> getDecorators() {
        return Collections.unmodifiableList(this.decorators);
    }

    protected void initType() {
        log.trace((Object)"Bean type specified in Java");
        this.type = this.getAnnotatedItem().getJavaClass();
        this.dependencies = new HashSet<String>();
        for (Class clazz = this.type.getSuperclass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            this.dependencies.add(clazz.getName());
        }
    }

    protected void initInjectableFields() {
        this.injectableFields = Beans.getFieldInjectionPoints(this, this.annotatedItem);
        this.addInjectionPoints(Beans.getFieldInjectionPoints(this, this.injectableFields));
    }

    protected void initInitializerMethods() {
        this.initializerMethods = Beans.getInitializerMethods(this, this.getAnnotatedItem());
        this.addInjectionPoints(Beans.getParameterInjectionPoints(this, this.initializerMethods));
    }

    @Override
    protected void initScopeType() {
        for (WeldClass<?> clazz = this.getAnnotatedItem(); clazz != null; clazz = clazz.getWeldSuperclass()) {
            HashSet<Annotation> scopeTypes = new HashSet<Annotation>();
            scopeTypes.addAll(clazz.getDeclaredMetaAnnotations(Scope.class));
            scopeTypes.addAll(clazz.getDeclaredMetaAnnotations(NormalScope.class));
            if (scopeTypes.size() == 1) {
                if (!this.getAnnotatedItem().isAnnotationPresent(((Annotation)scopeTypes.iterator().next()).annotationType())) break;
                this.scopeType = ((Annotation)scopeTypes.iterator().next()).annotationType();
                log.trace((Object)("Scope " + this.scopeType + " specified by annotation"));
                break;
            }
            if (scopeTypes.size() <= 1) continue;
            throw new DefinitionException("At most one scope may be specified on " + this.getAnnotatedItem());
        }
        if (this.scopeType == null) {
            this.initScopeTypeFromStereotype();
        }
        if (this.scopeType == null) {
            this.scopeType = Dependent.class;
            log.trace((Object)"Using default @Dependent scope");
        }
    }

    protected void checkBeanImplementation() {
    }

    @Override
    protected void preSpecialize(BeanDeployerEnvironment environment) {
        super.preSpecialize(environment);
        if (this.getAnnotatedItem().getWeldSuperclass() == null || this.getAnnotatedItem().getWeldSuperclass().getJavaClass().equals(Object.class)) {
            throw new DefinitionException("Specializing bean must extend another bean " + this.toString());
        }
    }

    public WeldClass<T> getAnnotatedItem() {
        return this.annotatedItem;
    }

    @Override
    protected String getDefaultName() {
        String name = Strings.decapitalize(this.getAnnotatedItem().getSimpleName());
        log.trace((Object)("Default name of " + this.type + " is " + name));
        return name;
    }

    public List<? extends Set<? extends MethodInjectionPoint<?, ?>>> getInitializerMethods() {
        return this.initializerMethods;
    }

    public List<? extends Set<FieldInjectionPoint<?, ?>>> getInjectableFields() {
        return this.injectableFields;
    }

    public Set<String> getSuperclasses() {
        return this.dependencies;
    }

    protected void initPostConstruct() {
        this.postConstruct = Beans.getPostConstruct(this.getAnnotatedItem());
    }

    protected void initPreDestroy() {
        this.preDestroy = Beans.getPreDestroy(this.getAnnotatedItem());
    }

    public WeldMethod<?, ?> getPostConstruct() {
        return this.postConstruct;
    }

    public WeldMethod<?, ?> getPreDestroy() {
        return this.preDestroy;
    }

    protected abstract boolean isInterceptionCandidate();

    protected static Set<Annotation> flattenInterceptorBindings(BeanManagerImpl manager, Set<Annotation> annotations) {
        HashSet<Annotation> foundInterceptionBindingTypes = new HashSet<Annotation>();
        for (Annotation annotation : annotations) {
            if (!manager.isInterceptorBindingType(annotation.annotationType())) continue;
            foundInterceptionBindingTypes.add(annotation);
            foundInterceptionBindingTypes.addAll(((MetaAnnotationStore)manager.getServices().get(MetaAnnotationStore.class)).getInterceptorBindingModel(annotation.annotationType()).getInheritedInterceptionBindingTypes());
        }
        return foundInterceptionBindingTypes;
    }

    protected void initInterceptors() {
        if (this.manager.getBoundInterceptorsRegistry().getInterceptionModel(this.getType()) == null) {
            InterceptionModelBuilder builder = InterceptionModelBuilder.newBuilderFor(this.getType(), SerializableContextual.class);
            Set<Annotation> classBindingAnnotations = AbstractClassBean.flattenInterceptorBindings(this.manager, this.getAnnotatedItem().getAnnotations());
            for (Class<Annotation> annotation : this.getStereotypes()) {
                classBindingAnnotations.addAll(AbstractClassBean.flattenInterceptorBindings(this.manager, this.manager.getStereotypeDefinition(annotation)));
            }
            Annotation[] classBindingAnnotationsArray = classBindingAnnotations.toArray(new Annotation[0]);
            builder.interceptPostConstruct().with((Object[])AbstractClassBean.toSerializableContextualArray(this.manager.resolveInterceptors(InterceptionType.POST_CONSTRUCT, classBindingAnnotationsArray)));
            builder.interceptPreDestroy().with((Object[])AbstractClassBean.toSerializableContextualArray(this.manager.resolveInterceptors(InterceptionType.PRE_DESTROY, classBindingAnnotationsArray)));
            builder.interceptPrePassivate().with((Object[])AbstractClassBean.toSerializableContextualArray(this.manager.resolveInterceptors(InterceptionType.PRE_PASSIVATE, classBindingAnnotationsArray)));
            builder.interceptPostActivate().with((Object[])AbstractClassBean.toSerializableContextualArray(this.manager.resolveInterceptors(InterceptionType.POST_ACTIVATE, classBindingAnnotationsArray)));
            List<WeldMethod<?, ?>> businessMethods = Beans.getInterceptableBusinessMethods(this.getAnnotatedItem());
            for (WeldMethod<?, ?> method : businessMethods) {
                ArrayList<Annotation> methodBindingAnnotations = new ArrayList<Annotation>(classBindingAnnotations);
                methodBindingAnnotations.addAll(AbstractClassBean.flattenInterceptorBindings(this.manager, method.getAnnotations()));
                List<Interceptor<?>> methodBoundInterceptors = this.manager.resolveInterceptors(InterceptionType.AROUND_INVOKE, methodBindingAnnotations.toArray(new Annotation[0]));
                builder.interceptAroundInvoke(method.getJavaMember()).with((Object[])AbstractClassBean.toSerializableContextualArray(methodBoundInterceptors));
            }
            this.manager.getBoundInterceptorsRegistry().registerInterceptionModel(this.getType(), builder.build());
        }
    }

    public void setInjectionTarget(InjectionTarget<T> injectionTarget) {
        this.injectionTarget = injectionTarget;
    }

    public InjectionTarget<T> getInjectionTarget() {
        return this.injectionTarget;
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return this.getInjectionTarget().getInjectionPoints();
    }

    protected void defaultPreDestroy(T instance) {
        WeldMethod<?, ?> preDestroy = this.getPreDestroy();
        if (preDestroy != null) {
            try {
                preDestroy.invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to invoke " + preDestroy + " on " + instance, e);
            }
        }
    }

    protected void defaultPostConstruct(T instance) {
        WeldMethod<?, ?> postConstruct = this.getPostConstruct();
        if (postConstruct != null) {
            try {
                postConstruct.invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to invoke " + postConstruct + " on " + instance, e);
            }
        }
    }

    private static SerializableContextual[] toSerializableContextualArray(List<Interceptor<?>> interceptors) {
        ArrayList serializableContextuals = new ArrayList();
        for (Interceptor<?> interceptor : interceptors) {
            serializableContextuals.add(new SerializableContextual(interceptor));
        }
        return serializableContextuals.toArray(new SerializableContextual[0]);
    }
}

