/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import javassist.util.proxy.MethodHandler;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.BeanManagerImpl;
import org.jboss.weld.bean.proxy.Marker;
import org.jboss.weld.context.WeldCreationalContext;
import org.jboss.weld.log.LogProvider;
import org.jboss.weld.log.Logging;
import org.jboss.weld.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientProxyMethodHandler
implements MethodHandler,
Serializable {
    private static final long serialVersionUID = -5391564935097267888L;
    private static transient LogProvider log = Logging.getLogProvider(ClientProxyMethodHandler.class);
    private transient Bean<?> bean;
    private final int beanIndex;
    private final BeanManagerImpl manager;
    private static final ThreadLocal<WeldCreationalContext<?>> currentCreationalContext = new ThreadLocal();

    public ClientProxyMethodHandler(Bean<?> bean, BeanManagerImpl manager, int beanIndex) {
        this.bean = bean;
        this.beanIndex = beanIndex;
        this.manager = manager;
        log.trace((Object)("Created method handler for bean " + bean + " indexed as " + beanIndex));
    }

    public Object invoke(Object self, Method proxiedMethod, Method proceed, Object[] args) throws Throwable {
        if (this.bean == null) {
            this.bean = this.manager.getBeans().get(this.beanIndex);
        }
        Object proxiedInstance = this.getProxiedInstance(this.bean);
        if ("touch".equals(proxiedMethod.getName()) && Marker.isMarker(0, proxiedMethod, args)) {
            return null;
        }
        if (proxiedMethod.getName().equals("equals") && proxiedMethod.getParameterTypes().length == 1 && proxiedMethod.getParameterTypes()[0] == Object.class && args[0] == self) {
            return true;
        }
        try {
            Object returnValue = Reflections.lookupMethod(proxiedMethod, proxiedInstance).invoke(proxiedInstance, args);
            log.trace((Object)("Executed method " + proxiedMethod + " on " + proxiedInstance + " with parameters " + Arrays.toString(args) + " and got return value " + returnValue));
            return returnValue;
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getProxiedInstance(Bean<T> bean) {
        boolean outer;
        WeldCreationalContext<T> creationalContext;
        if (currentCreationalContext.get() == null) {
            creationalContext = this.manager.createCreationalContext((Contextual)bean);
            currentCreationalContext.set(creationalContext);
            outer = true;
        } else {
            creationalContext = currentCreationalContext.get().getCreationalContext(bean);
            outer = false;
        }
        try {
            Context context = this.manager.getContext(bean.getScope());
            Object object = context.get(bean, creationalContext);
            return (T)object;
        }
        finally {
            if (outer) {
                currentCreationalContext.remove();
            }
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        String beanInfo = this.bean == null ? "null bean" : this.bean.toString();
        buffer.append("Proxy method handler for " + beanInfo + " with index " + this.beanIndex);
        return buffer.toString();
    }
}

