/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import javassist.util.proxy.MethodHandler;
import javax.enterprise.context.spi.CreationalContext;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bean.proxy.Marker;
import org.jboss.weld.ejb.api.SessionObjectReference;
import org.jboss.weld.introspector.MethodSignature;
import org.jboss.weld.introspector.jlr.MethodSignatureImpl;
import org.jboss.weld.log.Log;
import org.jboss.weld.log.Logging;
import org.jboss.weld.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnterpriseBeanProxyMethodHandler<T>
implements MethodHandler,
Serializable {
    private static final long serialVersionUID = 2107723373882153667L;
    static final transient Log log = Logging.getLog(EnterpriseBeanProxyMethodHandler.class);
    private final SessionObjectReference reference;
    private final Class<?> objectInterface;
    private final Collection<MethodSignature> removeMethodSignatures;
    private final boolean clientCanCallRemoveMethods;
    private final boolean stateful;

    public EnterpriseBeanProxyMethodHandler(SessionBean<T> bean, CreationalContext<T> creationalContext) {
        this.objectInterface = bean.getEjbDescriptor().getObjectInterface();
        this.removeMethodSignatures = bean.getEjbDescriptor().getRemoveMethodSignatures();
        this.clientCanCallRemoveMethods = bean.isClientCanCallRemoveMethods();
        this.reference = bean.createReference();
        this.stateful = bean.getEjbDescriptor().isStateful();
        log.trace((Object)("Created enterprise bean proxy method handler for " + bean), new Object[0]);
    }

    public Object invoke(Object self, Method method, Method proceed, Object[] args) throws Throwable {
        MethodSignatureImpl methodSignature;
        if (this.reference.isRemoved()) {
            return null;
        }
        if ("destroy".equals(method.getName()) && Marker.isMarker(0, method, args)) {
            if (this.stateful) {
                this.reference.remove();
            }
            return null;
        }
        if (!this.clientCanCallRemoveMethods && this.removeMethodSignatures.contains(methodSignature = new MethodSignatureImpl(method))) {
            throw new UnsupportedOperationException("Cannot call EJB remove method directly on non-dependent scoped bean " + method);
        }
        Class<?> businessInterface = this.getBusinessInterface(method);
        Object proxiedInstance = this.reference.getBusinessObject(businessInterface);
        Method proxiedMethod = Reflections.lookupMethod(method, proxiedInstance);
        Object returnValue = Reflections.invokeAndWrap(proxiedMethod, proxiedInstance, args);
        log.trace((Object)("Executed " + method + " on " + proxiedInstance + " with parameters " + Arrays.toString(args) + " and got return value " + returnValue), new Object[0]);
        return returnValue;
    }

    private Class<?> getBusinessInterface(Method method) {
        Class<?> businessInterface = method.getDeclaringClass();
        if (businessInterface.equals(Object.class)) {
            return this.objectInterface;
        }
        return businessInterface;
    }
}

