/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.BeanManagerImpl;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.DecoratorImpl;
import org.jboss.weld.bean.DisposalMethod;
import org.jboss.weld.bean.InterceptorImpl;
import org.jboss.weld.bean.NewBean;
import org.jboss.weld.bean.ProducerField;
import org.jboss.weld.bean.ProducerMethod;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bean.builtin.AbstractBuiltInBean;
import org.jboss.weld.bean.builtin.ExtensionBean;
import org.jboss.weld.ejb.EjbDescriptors;
import org.jboss.weld.event.ObserverMethodImpl;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.resolution.ResolvableFactory;
import org.jboss.weld.resolution.TypeSafeDisposerResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDeployerEnvironment {
    private final Map<WeldClass<?>, AbstractClassBean<?>> classBeanMap = new HashMap();
    private final Map<WeldMethod<?, ?>, ProducerMethod<?, ?>> producerMethodBeanMap = new HashMap();
    private final Set<RIBean<?>> beans;
    private final Set<ObserverMethodImpl<?, ?>> observers;
    private final List<DisposalMethod<?, ?>> allDisposalBeans = new ArrayList();
    private final Set<DisposalMethod<?, ?>> resolvedDisposalBeans = new HashSet();
    private final Set<DecoratorImpl<?>> decorators;
    private final Set<InterceptorImpl<?>> interceptors;
    private final EjbDescriptors ejbDescriptors;
    private final TypeSafeDisposerResolver disposalMethodResolver;

    public BeanDeployerEnvironment(EjbDescriptors ejbDescriptors, BeanManagerImpl manager) {
        this.beans = new HashSet();
        this.decorators = new HashSet();
        this.interceptors = new HashSet();
        this.observers = new HashSet();
        this.ejbDescriptors = ejbDescriptors;
        this.disposalMethodResolver = new TypeSafeDisposerResolver(manager, this.allDisposalBeans);
    }

    public <X, T> ProducerMethod<X, T> getProducerMethod(WeldMethod<X, T> method) {
        if (!this.producerMethodBeanMap.containsKey(method)) {
            return null;
        }
        ProducerMethod<?, ?> bean = this.producerMethodBeanMap.get(method);
        bean.initialize(this);
        return bean;
    }

    public AbstractClassBean<?> getClassBean(WeldClass<?> clazz) {
        if (!this.classBeanMap.containsKey(clazz)) {
            return null;
        }
        AbstractClassBean<?> bean = this.classBeanMap.get(clazz);
        bean.initialize(this);
        return bean;
    }

    public void addBean(ProducerMethod<?, ?> bean) {
        this.producerMethodBeanMap.put((WeldMethod<?, ?>)bean.getAnnotatedItem(), bean);
        this.beans.add(bean);
    }

    public void addBean(ProducerField<?, ?> bean) {
        this.beans.add(bean);
    }

    public void addBean(ExtensionBean bean) {
        this.beans.add(bean);
    }

    public void addBean(AbstractBuiltInBean<?> bean) {
        this.beans.add(bean);
    }

    public void addBean(AbstractClassBean<?> bean) {
        if (!(bean instanceof NewBean)) {
            this.classBeanMap.put((WeldClass<?>)bean.getAnnotatedItem(), bean);
        }
        this.beans.add(bean);
    }

    public void addBean(DecoratorImpl<?> bean) {
        this.decorators.add(bean);
    }

    public void addBean(InterceptorImpl<?> bean) {
        this.interceptors.add(bean);
    }

    public void addBean(DisposalMethod<?, ?> bean) {
        this.allDisposalBeans.add(bean);
    }

    public void addObserver(ObserverMethodImpl<?, ?> observer) {
        this.observers.add(observer);
    }

    public Set<? extends RIBean<?>> getBeans() {
        return Collections.unmodifiableSet(this.beans);
    }

    public Set<DecoratorImpl<?>> getDecorators() {
        return Collections.unmodifiableSet(this.decorators);
    }

    public Set<InterceptorImpl<?>> getInterceptors() {
        return Collections.unmodifiableSet(this.interceptors);
    }

    public Set<ObserverMethodImpl<?, ?>> getObservers() {
        return Collections.unmodifiableSet(this.observers);
    }

    public Set<DisposalMethod<?, ?>> getUnresolvedDisposalBeans() {
        HashSet beans = new HashSet(this.allDisposalBeans);
        beans.removeAll(this.resolvedDisposalBeans);
        return Collections.unmodifiableSet(beans);
    }

    public EjbDescriptors getEjbDescriptors() {
        return this.ejbDescriptors;
    }

    public <X> Set<DisposalMethod<X, ?>> resolveDisposalBeans(Set<Type> types, Set<Annotation> bindings, AbstractClassBean<X> declaringBean) {
        Set beans = this.disposalMethodResolver.resolve(ResolvableFactory.of(types, bindings, declaringBean));
        this.resolvedDisposalBeans.addAll(beans);
        return Collections.unmodifiableSet(beans);
    }
}

