/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.Extension;
import org.jboss.weld.BeanManagerImpl;
import org.jboss.weld.Container;
import org.jboss.weld.ContextualStore;
import org.jboss.weld.Validator;
import org.jboss.weld.bean.builtin.ManagerBean;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.BeanDeployment;
import org.jboss.weld.bootstrap.ExtensionBeanDeployer;
import org.jboss.weld.bootstrap.ExtensionBeanDeployerEnvironment;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.Lifecycle;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.ServiceRegistries;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.events.AfterBeanDiscoveryImpl;
import org.jboss.weld.bootstrap.events.AfterDeploymentValidationImpl;
import org.jboss.weld.bootstrap.events.BeforeBeanDiscoveryImpl;
import org.jboss.weld.bootstrap.events.BeforeShutdownImpl;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.context.ApplicationContext;
import org.jboss.weld.context.ContextLifecycle;
import org.jboss.weld.context.ConversationContext;
import org.jboss.weld.context.DependentContext;
import org.jboss.weld.context.RequestContext;
import org.jboss.weld.context.SessionContext;
import org.jboss.weld.context.SingletonContext;
import org.jboss.weld.context.api.BeanStore;
import org.jboss.weld.ejb.EJBApiAbstraction;
import org.jboss.weld.ejb.EjbDescriptors;
import org.jboss.weld.jsf.JsfApiAbstraction;
import org.jboss.weld.log.Log;
import org.jboss.weld.log.Logging;
import org.jboss.weld.metadata.TypeStore;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.persistence.PersistenceApiAbstraction;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.resources.DefaultResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.servlet.ServletApiAbstraction;
import org.jboss.weld.transaction.spi.TransactionServices;
import org.jboss.weld.util.serviceProvider.ServiceLoader;
import org.jboss.weld.ws.WSApiAbstraction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeldBootstrap
implements Bootstrap {
    private static Log log = Logging.getLog(WeldBootstrap.class);
    private BeanManagerImpl deploymentManager;
    private Map<BeanDeploymentArchive, BeanDeployment> beanDeployments;
    private Environment environment;
    private Deployment deployment;
    private ExtensionBeanDeployerEnvironment extensionDeployerEnvironment;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bootstrap startContainer(Environment environment, Deployment deployment, BeanStore applicationBeanStore) {
        WeldBootstrap weldBootstrap = this;
        synchronized (weldBootstrap) {
            if (deployment == null) {
                throw new IllegalArgumentException("Must start the container with a deployment");
            }
            if (!deployment.getServices().contains(ResourceLoader.class)) {
                deployment.getServices().add(ResourceLoader.class, (Service)new DefaultResourceLoader());
            }
            WeldBootstrap.verifyServices(deployment.getServices(), environment.getRequiredDeploymentServices());
            if (!deployment.getServices().contains(TransactionServices.class)) {
                log.info((Object)"Transactional services not available. Injection of @Current UserTransaction not available. Transactional observers will be invoked synchronously.", new Object[0]);
            }
            if (applicationBeanStore == null) {
                throw new IllegalStateException("No application context BeanStore set");
            }
            this.deployment = deployment;
            ServiceRegistry implementationServices = this.getImplementationServices((ResourceLoader)deployment.getServices().get(ResourceLoader.class));
            deployment.getServices().addAll((Collection)implementationServices.entrySet());
            SimpleServiceRegistry deploymentServices = new SimpleServiceRegistry();
            deploymentServices.add(ClassTransformer.class, implementationServices.get(ClassTransformer.class));
            deploymentServices.add(MetaAnnotationStore.class, implementationServices.get(MetaAnnotationStore.class));
            deploymentServices.add(TypeStore.class, implementationServices.get(TypeStore.class));
            this.environment = environment;
            this.deploymentManager = BeanManagerImpl.newRootManager("deployment", (ServiceRegistry)deploymentServices);
            Container.initialize(this.deploymentManager, ServiceRegistries.unmodifiableServiceRegistry((ServiceRegistry)deployment.getServices()));
            this.createContexts();
            this.initializeContexts();
            ((ContextLifecycle)Container.instance().deploymentServices().get(ContextLifecycle.class)).beginApplication(applicationBeanStore);
            this.extensionDeployerEnvironment = new ExtensionBeanDeployerEnvironment(EjbDescriptors.EMPTY, this.deploymentManager);
            DeploymentVisitor deploymentVisitor = new DeploymentVisitor(this.deploymentManager, environment, deployment, this.extensionDeployerEnvironment);
            this.beanDeployments = deploymentVisitor.visit();
            return this;
        }
    }

    private ServiceRegistry getImplementationServices(ResourceLoader resourceLoader) {
        SimpleServiceRegistry services = new SimpleServiceRegistry();
        services.add(EJBApiAbstraction.class, (Service)new EJBApiAbstraction(resourceLoader));
        services.add(JsfApiAbstraction.class, (Service)new JsfApiAbstraction(resourceLoader));
        services.add(PersistenceApiAbstraction.class, (Service)new PersistenceApiAbstraction(resourceLoader));
        services.add(WSApiAbstraction.class, (Service)new WSApiAbstraction(resourceLoader));
        services.add(ServletApiAbstraction.class, (Service)new ServletApiAbstraction(resourceLoader));
        services.add(Validator.class, (Service)new Validator());
        services.add(TypeStore.class, (Service)new TypeStore());
        services.add(ClassTransformer.class, (Service)new ClassTransformer((TypeStore)services.get(TypeStore.class)));
        services.add(MetaAnnotationStore.class, (Service)new MetaAnnotationStore((ClassTransformer)services.get(ClassTransformer.class)));
        services.add(ContextualStore.class, (Service)new ContextualStore());
        return services;
    }

    public BeanManagerImpl getManager(BeanDeploymentArchive beanDeploymentArchive) {
        if (this.beanDeployments.containsKey(beanDeploymentArchive)) {
            return this.beanDeployments.get(beanDeploymentArchive).getBeanManager();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bootstrap startInitialization() {
        WeldBootstrap weldBootstrap = this;
        synchronized (weldBootstrap) {
            if (this.deploymentManager == null) {
                throw new IllegalStateException("Manager has not been initialized");
            }
            ExtensionBeanDeployer extensionBeanDeployer = new ExtensionBeanDeployer(this.deploymentManager, this.extensionDeployerEnvironment);
            extensionBeanDeployer.addExtensions(ServiceLoader.load(Extension.class));
            extensionBeanDeployer.createBeans().deploy();
            this.deploymentManager.addBean(new ManagerBean(this.deploymentManager));
            BeforeBeanDiscoveryImpl.fire(this.deploymentManager, this.deployment, this.beanDeployments, this.extensionDeployerEnvironment);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bootstrap deployBeans() {
        WeldBootstrap weldBootstrap = this;
        synchronized (weldBootstrap) {
            for (Map.Entry<BeanDeploymentArchive, BeanDeployment> entry : this.beanDeployments.entrySet()) {
                entry.getValue().deployBeans(this.environment);
            }
            AfterBeanDiscoveryImpl.fire(this.deploymentManager, this.deployment, this.beanDeployments, this.extensionDeployerEnvironment);
            log.debug((Object)"Weld initialized. Validating beans.", new Object[0]);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bootstrap validateBeans() {
        WeldBootstrap weldBootstrap = this;
        synchronized (weldBootstrap) {
            for (Map.Entry<BeanDeploymentArchive, BeanDeployment> entry : this.beanDeployments.entrySet()) {
                ((Validator)this.deployment.getServices().get(Validator.class)).validateDeployment(entry.getValue().getBeanManager(), (BeanDeployerEnvironment)entry.getValue().getBeanDeployer().getEnvironment());
            }
            AfterDeploymentValidationImpl.fire(this.deploymentManager);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bootstrap endInitialization() {
        WeldBootstrap weldBootstrap = this;
        synchronized (weldBootstrap) {
            Container.instance().putBeanDeployments(this.beanDeployments);
            Container.instance().setInitialized(true);
        }
        return this;
    }

    public static String getVersion() {
        Package pkg = WeldBootstrap.class.getPackage();
        return pkg != null ? pkg.getImplementationVersion() : null;
    }

    protected void initializeContexts() {
        Lifecycle lifecycle = (Lifecycle)this.deployment.getServices().get(ContextLifecycle.class);
        this.deploymentManager.addContext(lifecycle.getDependentContext());
        this.deploymentManager.addContext(lifecycle.getRequestContext());
        this.deploymentManager.addContext(lifecycle.getConversationContext());
        this.deploymentManager.addContext(lifecycle.getSessionContext());
        this.deploymentManager.addContext(lifecycle.getApplicationContext());
        this.deploymentManager.addContext(lifecycle.getSingletonContext());
    }

    protected void createContexts() {
        ApplicationContext applicationContext = new ApplicationContext();
        SingletonContext singletonContext = new SingletonContext();
        SessionContext sessionContext = new SessionContext();
        ConversationContext conversationContext = new ConversationContext();
        RequestContext requestContext = new RequestContext();
        DependentContext dependentContext = new DependentContext();
        this.deployment.getServices().add(ContextLifecycle.class, (Service)new ContextLifecycle(applicationContext, singletonContext, sessionContext, conversationContext, requestContext, dependentContext));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            BeforeShutdownImpl.fire(this.deploymentManager);
        }
        finally {
            ((ContextLifecycle)Container.instance().deploymentServices().get(ContextLifecycle.class)).endApplication();
        }
    }

    protected static void verifyServices(ServiceRegistry services, Set<Class<? extends Service>> requiredServices) {
        for (Class<? extends Service> serviceType : requiredServices) {
            if (services.contains(serviceType)) continue;
            throw new IllegalStateException("Required service " + serviceType.getName() + " has not been specified");
        }
    }

    static {
        log.info((Object)("Weld " + WeldBootstrap.getVersion()), new Object[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeploymentVisitor {
        private final BeanManagerImpl deploymentManager;
        private final Environment environment;
        private final Deployment deployment;
        private final ExtensionBeanDeployerEnvironment extensionBeanDeployerEnvironment;

        public DeploymentVisitor(BeanManagerImpl deploymentManager, Environment environment, Deployment deployment, ExtensionBeanDeployerEnvironment extensionBeanDeployerEnvironment) {
            this.deploymentManager = deploymentManager;
            this.environment = environment;
            this.deployment = deployment;
            this.extensionBeanDeployerEnvironment = extensionBeanDeployerEnvironment;
        }

        public Map<BeanDeploymentArchive, BeanDeployment> visit() {
            HashSet<BeanDeploymentArchive> seenBeanDeploymentArchives = new HashSet<BeanDeploymentArchive>();
            HashMap<BeanDeploymentArchive, BeanDeployment> managerAwareBeanDeploymentArchives = new HashMap<BeanDeploymentArchive, BeanDeployment>();
            for (BeanDeploymentArchive archvive : this.deployment.getBeanDeploymentArchives()) {
                this.visit(archvive, managerAwareBeanDeploymentArchives, seenBeanDeploymentArchives);
            }
            return managerAwareBeanDeploymentArchives;
        }

        private BeanDeployment visit(BeanDeploymentArchive beanDeploymentArchive, Map<BeanDeploymentArchive, BeanDeployment> managerAwareBeanDeploymentArchives, Set<BeanDeploymentArchive> seenBeanDeploymentArchives) {
            WeldBootstrap.verifyServices(beanDeploymentArchive.getServices(), this.environment.getRequiredBeanDeploymentArchiveServices());
            if (beanDeploymentArchive.getId() == null) {
                throw new IllegalArgumentException("BeanDeploymentArchive must not be null " + beanDeploymentArchive);
            }
            BeanDeployment parent = new BeanDeployment(beanDeploymentArchive, this.deploymentManager, this.deployment, this.extensionBeanDeployerEnvironment, this.deployment.getServices());
            managerAwareBeanDeploymentArchives.put(beanDeploymentArchive, parent);
            seenBeanDeploymentArchives.add(beanDeploymentArchive);
            for (BeanDeploymentArchive archive : beanDeploymentArchive.getBeanDeploymentArchives()) {
                if (seenBeanDeploymentArchives.contains(archive)) continue;
                BeanDeployment child = this.visit(archive, managerAwareBeanDeploymentArchives, seenBeanDeploymentArchives);
                parent.getBeanManager().addAccessibleBeanManager(child.getBeanManager());
            }
            return parent;
        }
    }
}

