/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import java.lang.reflect.Type;
import java.util.Map;
import org.jboss.weld.BeanManagerImpl;
import org.jboss.weld.bootstrap.BeanDeployment;
import org.jboss.weld.bootstrap.ExtensionBeanDeployerEnvironment;
import org.jboss.weld.bootstrap.events.AbstractDefinitionContainerEvent;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.metadata.TypeStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBeanDiscoveryEvent
extends AbstractDefinitionContainerEvent {
    private final Map<BeanDeploymentArchive, BeanDeployment> beanDeployments;
    private final Deployment deployment;
    private final ExtensionBeanDeployerEnvironment extensionBeanDeployerEnvironment;

    public AbstractBeanDiscoveryEvent(BeanManagerImpl deploymentManager, Type rawType, Map<BeanDeploymentArchive, BeanDeployment> beanDeployments, Deployment deployment, ExtensionBeanDeployerEnvironment extensionBeanDeployerEnvironment) {
        super(deploymentManager, rawType, EMPTY_TYPE_ARRAY);
        this.beanDeployments = beanDeployments;
        this.deployment = deployment;
        this.extensionBeanDeployerEnvironment = extensionBeanDeployerEnvironment;
    }

    protected Map<BeanDeploymentArchive, BeanDeployment> getBeanDeployments() {
        return this.beanDeployments;
    }

    protected Deployment getDeployment() {
        return this.deployment;
    }

    protected TypeStore getTypeStore() {
        return (TypeStore)this.getDeployment().getServices().get(TypeStore.class);
    }

    protected BeanDeployment getOrCreateBeanDeployment(Class<?> clazz) {
        BeanDeploymentArchive beanDeploymentArchive = this.getDeployment().loadBeanDeploymentArchive(clazz);
        if (beanDeploymentArchive == null) {
            throw new IllegalStateException("Unable to find Bean Deployment Archive for " + clazz);
        }
        if (this.getBeanDeployments().containsKey(beanDeploymentArchive)) {
            return this.getBeanDeployments().get(beanDeploymentArchive);
        }
        BeanDeployment beanDeployment = new BeanDeployment(beanDeploymentArchive, this.getBeanManager(), this.getDeployment(), this.extensionBeanDeployerEnvironment, this.getDeployment().getServices());
        this.getBeanDeployments().put(beanDeploymentArchive, beanDeployment);
        return beanDeployment;
    }
}

