/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Event;
import javax.enterprise.inject.TypeLiteral;
import org.jboss.weld.BeanManagerImpl;
import org.jboss.weld.bean.builtin.facade.AbstractFacade;
import org.jboss.weld.util.Observers;
import org.jboss.weld.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventImpl<T>
extends AbstractFacade<T, Event<T>>
implements Event<T> {
    private static final long serialVersionUID = 656782657242515455L;

    public static <E> EventImpl<E> of(Type eventType, BeanManagerImpl manager, Set<Annotation> bindings) {
        return new EventImpl(eventType, manager, bindings);
    }

    private EventImpl(Type eventType, BeanManagerImpl manager, Set<Annotation> bindings) {
        super(eventType, manager, bindings);
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Observable Event:\n");
        buffer.append("  Event Type: " + this.getType().toString() + "\n");
        buffer.append(Strings.collectionToString("  Event Bindings: ", this.getBindings()));
        return buffer.toString();
    }

    public void fire(T event) {
        this.getManager().fireEvent(event, this.mergeInBindings(new Annotation[0]));
    }

    public Event<T> select(Annotation ... bindings) {
        return this.selectEvent(this.getType(), bindings);
    }

    public <U extends T> Event<U> select(Class<U> subtype, Annotation ... bindings) {
        return this.selectEvent(subtype, bindings);
    }

    public <U extends T> Event<U> select(TypeLiteral<U> subtype, Annotation ... bindings) {
        return this.selectEvent(subtype.getType(), bindings);
    }

    public <U extends T> Event<U> selectEvent(Type subtype, Annotation[] bindings) {
        Observers.checkEventObjectType(subtype);
        return new EventImpl<T>(subtype, this.getManager(), (Set<Annotation>)new HashSet<Annotation>(Arrays.asList(this.mergeInBindings(bindings))));
    }
}

