/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Notify;
import javax.enterprise.event.ObserverException;
import javax.enterprise.event.Observes;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.inject.Inject;
import org.jboss.weld.BeanManagerImpl;
import org.jboss.weld.Container;
import org.jboss.weld.DefinitionException;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.event.DeferredEventNotification;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.introspector.WeldParameter;
import org.jboss.weld.manager.api.ExecutorServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObserverMethodImpl<X, T>
implements ObserverMethod<X, T> {
    private final Set<Annotation> bindings;
    private final Type eventType;
    protected BeanManagerImpl manager;
    private final Notify notifyType;
    protected final RIBean<X> declaringBean;
    protected final MethodInjectionPoint<T, X> observerMethod;
    protected TransactionPhase transactionPhase;

    protected ObserverMethodImpl(WeldMethod<T, X> observer, RIBean<X> declaringBean, BeanManagerImpl manager) {
        this.manager = manager;
        this.declaringBean = declaringBean;
        this.observerMethod = MethodInjectionPoint.of(declaringBean, observer);
        this.eventType = this.observerMethod.getAnnotatedParameters(Observes.class).get(0).getBaseType();
        this.bindings = new HashSet<Annotation>(Arrays.asList(this.observerMethod.getAnnotatedParameters(Observes.class).get(0).getBindingsAsArray()));
        Observes observesAnnotation = (Observes)this.observerMethod.getAnnotatedParameters(Observes.class).get(0).getAnnotation(Observes.class);
        this.notifyType = observesAnnotation.notifyObserver();
        this.transactionPhase = TransactionPhase.IN_PROGRESS;
    }

    private void checkObserverMethod() {
        List disposeParams;
        WeldParameter eventParam;
        List eventObjects = this.observerMethod.getAnnotatedParameters(Observes.class);
        if (this.notifyType.equals((Object)Notify.IF_EXISTS) && this.declaringBean.getScope().equals(Dependent.class)) {
            throw new DefinitionException(this + " is invalid because it is a conditional observer method, and is declared by a @Dependent scoped bean");
        }
        if (eventObjects.size() > 1) {
            throw new DefinitionException(this + " is invalid because it contains more than event parameter annotated @Observes");
        }
        if (eventObjects.size() > 0 && (eventParam = eventObjects.iterator().next()).isParameterizedType()) {
            for (Type type : eventParam.getActualTypeArguments()) {
                if (!(type instanceof TypeVariable)) continue;
                throw new DefinitionException("Cannot use a type variable " + type + " in an parameterized type " + this.toString());
            }
        }
        if ((disposeParams = this.observerMethod.getAnnotatedParameters(Disposes.class)).size() > 0) {
            throw new DefinitionException(this + " cannot have any parameters annotated with @Disposes");
        }
        if (this.observerMethod.isAnnotationPresent(Produces.class)) {
            throw new DefinitionException(this + " cannot be annotated with @Produces");
        }
        if (this.observerMethod.isAnnotationPresent(Inject.class)) {
            throw new DefinitionException(this + " cannot be annotated with @Initializer");
        }
    }

    public Bean<X> getBean() {
        return this.declaringBean;
    }

    public Annotation[] getBindingsAsArray() {
        return this.bindings.toArray(new Annotation[0]);
    }

    public Notify getNotify() {
        return this.notifyType;
    }

    public Set<Annotation> getObservedQualifiers() {
        return this.bindings;
    }

    public Type getObservedType() {
        return this.eventType;
    }

    public TransactionPhase getTransactionPhase() {
        return this.transactionPhase;
    }

    public MethodInjectionPoint<T, X> getMethod() {
        return this.observerMethod;
    }

    public void initialize() {
        this.checkObserverMethod();
    }

    public void notify(T event) {
        this.sendEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendEvent(T event) {
        Object instance = null;
        CreationalContext creationalContext = null;
        try {
            if (this.notifyType.equals((Object)Notify.ALWAYS)) {
                creationalContext = this.manager.createCreationalContext((Contextual)this.declaringBean);
            }
            if ((instance = this.manager.getReference(this.declaringBean, creationalContext)) == null) {
                return;
            }
            this.observerMethod.invokeOnInstanceWithSpecialValue(instance, Observes.class, event, this.manager, creationalContext, ObserverException.class);
        }
        finally {
            if (creationalContext != null && Dependent.class.equals((Object)this.declaringBean.getScope())) {
                creationalContext.release();
            }
        }
    }

    protected void sendEventAsynchronously(T event) {
        DeferredEventNotification<T> deferredEvent = new DeferredEventNotification<T>(event, this);
        ((ExecutorServices)Container.instance().deploymentServices().get(ExecutorServices.class)).getTaskExecutor().execute(deferredEvent);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Observer Implementation: \n");
        builder.append("  Observer (Declaring) class: " + this.declaringBean.getBeanClass());
        builder.append("  Observer method: " + this.observerMethod);
        return builder.toString();
    }
}

