/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Set;
import javax.decorator.Decorates;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import org.jboss.weld.BeanManagerImpl;
import org.jboss.weld.injection.Exceptions;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.introspector.ForwardingWeldField;
import org.jboss.weld.introspector.WeldField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldInjectionPoint<T, X>
extends ForwardingWeldField<T, X>
implements WeldInjectionPoint<T, Field> {
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private final Bean<?> declaringBean;
    private final WeldField<T, X> field;
    private final boolean delegate;

    public static <T, X> FieldInjectionPoint<T, X> of(Bean<?> declaringBean, WeldField<T, X> field) {
        return new FieldInjectionPoint<T, X>(declaringBean, field);
    }

    protected FieldInjectionPoint(Bean<?> declaringBean, WeldField<T, X> field) {
        this.declaringBean = declaringBean;
        this.field = field;
        this.delegate = this.isAnnotationPresent(Decorates.class) && declaringBean instanceof Decorator;
    }

    @Override
    protected WeldField<T, X> delegate() {
        return this.field;
    }

    public Bean<?> getBean() {
        return this.declaringBean;
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return this.delegate().getQualifiers();
    }

    public void inject(Object declaringInstance, BeanManagerImpl manager, CreationalContext<?> creationalContext) {
        try {
            this.delegate().set(declaringInstance, manager.getInjectableReference(this, creationalContext));
        }
        catch (IllegalArgumentException e) {
            Exceptions.rethrowException(e);
        }
        catch (IllegalAccessException e) {
            Exceptions.rethrowException(e);
        }
    }

    @Override
    public void inject(Object declaringInstance, Object value) {
        try {
            this.delegate().set(declaringInstance, value);
        }
        catch (IllegalArgumentException e) {
            Exceptions.rethrowException(e);
        }
        catch (IllegalAccessException e) {
            Exceptions.rethrowException(e);
        }
    }

    public Annotated getAnnotated() {
        return this.delegate();
    }

    public boolean isDelegate() {
        return this.delegate;
    }

    public Type getType() {
        return this.getBaseType();
    }

    public Member getMember() {
        return this.getJavaMember();
    }
}

