/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.introspector.jlr;

import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.jboss.weld.introspector.AnnotationStore;
import org.jboss.weld.introspector.ForwardingWeldMember;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldMember;
import org.jboss.weld.introspector.jlr.AbstractWeldAnnotated;
import org.jboss.weld.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWeldMember<T, X, S extends Member>
extends AbstractWeldAnnotated<T, S>
implements WeldMember<T, X, S> {
    private final String name;
    private String toString;
    private final boolean _public;
    private final boolean _private;
    private final boolean _packagePrivate;
    private final Package _package;
    private final WeldClass<X> declaringType;

    protected AbstractWeldMember(AnnotationStore annotatedItemHelper, Member member, Class<T> rawType, Type type, WeldClass<X> declaringType) {
        super(annotatedItemHelper, rawType, type);
        this.name = member.getName();
        this._public = Modifier.isPublic(member.getModifiers());
        this._private = Modifier.isPrivate(member.getModifiers());
        this._packagePrivate = Reflections.isPackagePrivate(member.getModifiers());
        this._package = member.getDeclaringClass().getPackage();
        this.declaringType = declaringType;
    }

    @Override
    public boolean isStatic() {
        return Reflections.isStatic((Member)this.getDelegate());
    }

    @Override
    public boolean isFinal() {
        return Reflections.isFinal((Member)this.getDelegate());
    }

    public boolean isTransient() {
        return Reflections.isTransient((Member)this.getDelegate());
    }

    @Override
    public boolean isPublic() {
        return this._public;
    }

    @Override
    public boolean isPrivate() {
        return this._private;
    }

    @Override
    public boolean isPackagePrivate() {
        return this._packagePrivate;
    }

    @Override
    public Package getPackage() {
        return this._package;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        this.toString = "Abstract annotated member " + this.getName();
        return this.toString;
    }

    @Override
    public S getJavaMember() {
        return (S)((Member)this.getDelegate());
    }

    @Override
    public WeldClass<X> getDeclaringType() {
        return this.declaringType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class WrappableForwardingAnnotatedMember<T, X, S extends Member>
    extends ForwardingWeldMember<T, X, S>
    implements AbstractWeldAnnotated.WrappableAnnotatedItem<T, S> {
        WrappableForwardingAnnotatedMember() {
        }
    }
}

