/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.introspector.jlr;

import com.google.common.base.Supplier;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.introspector.AnnotationStore;
import org.jboss.weld.introspector.WeldAnnotation;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.introspector.jlr.WeldClassImpl;
import org.jboss.weld.introspector.jlr.WeldMethodImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.Names;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeldAnnotationImpl<T extends Annotation>
extends WeldClassImpl<T>
implements WeldAnnotation<T> {
    private final SetMultimap<Class<? extends Annotation>, WeldMethod<?, ?>> annotatedMembers;
    private final Class<T> clazz;
    private final Set<WeldMethod<?, ?>> members;
    private final Map<String, WeldMethod<?, ?>> namedMembers;
    private final String toString;

    public static <A extends Annotation> WeldAnnotation<A> of(Class<A> annotationType, ClassTransformer classTransformer) {
        return new WeldAnnotationImpl<A>(annotationType, classTransformer);
    }

    protected WeldAnnotationImpl(Class<T> annotationType, ClassTransformer classTransformer) {
        super(annotationType, annotationType, null, AnnotationStore.of(annotationType, classTransformer.getTypeStore().get(annotationType), classTransformer.getTypeStore().get(annotationType), classTransformer.getTypeStore()), classTransformer);
        this.clazz = annotationType;
        this.toString = "class " + Names.classToString(this.getDelegate());
        this.members = new HashSet();
        this.annotatedMembers = Multimaps.newSetMultimap(new HashMap(), (Supplier)new Supplier<Set<WeldMethod<?, ?>>>(){

            public Set<WeldMethod<?, ?>> get() {
                return new HashSet();
            }
        });
        this.namedMembers = new HashMap();
        for (Method member : this.clazz.getDeclaredMethods()) {
            WeldMethodImpl annotatedMethod = WeldMethodImpl.of(member, this, classTransformer);
            this.members.add(annotatedMethod);
            for (Annotation annotation : annotatedMethod.getAnnotations()) {
                this.annotatedMembers.put(annotation.annotationType(), annotatedMethod);
            }
            this.namedMembers.put(annotatedMethod.getName(), annotatedMethod);
        }
    }

    @Override
    public Set<WeldMethod<?, ?>> getMembers() {
        return Collections.unmodifiableSet(this.members);
    }

    @Override
    public Set<WeldMethod<?, ?>> getAnnotatedMembers(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.annotatedMembers.get(annotationType));
    }

    @Override
    public <A> WeldMethod<A, ?> getMember(String memberName, WeldClass<A> expectedType) {
        return this.namedMembers.get(memberName);
    }

    @Override
    public String toString() {
        return this.toString;
    }

    @Override
    public Class<T> getDelegate() {
        return this.clazz;
    }
}

