/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.introspector.jlr;

import com.google.common.base.Supplier;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import org.jboss.weld.introspector.AnnotationStore;
import org.jboss.weld.introspector.MethodSignature;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.introspector.WeldParameter;
import org.jboss.weld.introspector.jlr.AbstractWeldCallable;
import org.jboss.weld.introspector.jlr.MethodSignatureImpl;
import org.jboss.weld.introspector.jlr.WeldParameterImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeldMethodImpl<T, X>
extends AbstractWeldCallable<T, X, Method>
implements WeldMethod<T, X> {
    private final Method method;
    private final List<WeldParameter<?, X>> parameters;
    private final ListMultimap<Class<? extends Annotation>, WeldParameter<?, X>> annotatedParameters;
    private final String propertyName;
    private final String toString;
    private final MethodSignature signature;

    public static <T, X> WeldMethodImpl<T, X> of(Method method, WeldClass<X> declaringClass, ClassTransformer classTransformer) {
        AnnotationStore annotationStore = AnnotationStore.of(method, classTransformer.getTypeStore());
        return new WeldMethodImpl<T, X>(Reflections.ensureAccessible(method), null, annotationStore, declaringClass, classTransformer);
    }

    public static <T, X> WeldMethodImpl<T, X> of(AnnotatedMethod<T> method, WeldClass<X> declaringClass, ClassTransformer classTransformer) {
        AnnotationStore annotationStore = AnnotationStore.of(method.getAnnotations(), method.getAnnotations(), classTransformer.getTypeStore());
        return new WeldMethodImpl<T, X>(Reflections.ensureAccessible(method.getJavaMember()), method, annotationStore, declaringClass, classTransformer);
    }

    private WeldMethodImpl(Method method, AnnotatedMethod<T> annotatedMethod, AnnotationStore annotationStore, WeldClass<X> declaringClass, ClassTransformer classTransformer) {
        super(annotationStore, method, method.getReturnType(), method.getGenericReturnType(), declaringClass);
        this.method = method;
        this.toString = "method " + method.toString();
        this.parameters = new ArrayList();
        this.annotatedParameters = Multimaps.newListMultimap(new HashMap(), (Supplier)new Supplier<List<WeldParameter<?, X>>>(){

            public List<WeldParameter<?, X>> get() {
                return new ArrayList();
            }
        });
        HashMap<Integer, AnnotatedParameter> annotatedTypeParameters = new HashMap<Integer, AnnotatedParameter>();
        if (annotatedMethod != null) {
            for (AnnotatedParameter annotated : annotatedMethod.getParameters()) {
                annotatedTypeParameters.put(annotated.getPosition(), annotated);
            }
        }
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            WeldParameter parameter;
            Type type;
            Class<?> clazz;
            if (method.getParameterAnnotations()[i].length > 0 || annotatedTypeParameters.containsKey(i)) {
                clazz = method.getParameterTypes()[i];
                type = method.getGenericParameterTypes()[i];
                parameter = null;
                if (annotatedTypeParameters.containsKey(i)) {
                    AnnotatedParameter annotatedParameter = (AnnotatedParameter)annotatedTypeParameters.get(i);
                    parameter = WeldParameterImpl.of(annotatedParameter.getAnnotations(), clazz, type, this, i, classTransformer);
                } else {
                    parameter = WeldParameterImpl.of(method.getParameterAnnotations()[i], clazz, type, this, i, classTransformer);
                }
                this.parameters.add(parameter);
                for (Annotation annotation : parameter.getAnnotations()) {
                    if (!MAPPED_PARAMETER_ANNOTATIONS.contains(annotation.annotationType())) continue;
                    this.annotatedParameters.put(annotation.annotationType(), parameter);
                }
                continue;
            }
            clazz = method.getParameterTypes()[i];
            type = method.getGenericParameterTypes()[i];
            parameter = WeldParameterImpl.of(new Annotation[0], clazz, type, this, i, classTransformer);
            this.parameters.add(parameter);
        }
        String propertyName = Reflections.getPropertyName(this.getDelegate());
        this.propertyName = propertyName == null ? this.getName() : propertyName;
        this.signature = new MethodSignatureImpl(this);
    }

    @Override
    public Method getAnnotatedMethod() {
        return this.method;
    }

    @Override
    public Method getDelegate() {
        return this.method;
    }

    @Override
    public List<WeldParameter<?, X>> getWBParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    @Override
    public Class<?>[] getParameterTypesAsArray() {
        return this.method.getParameterTypes();
    }

    @Override
    public List<WeldParameter<?, X>> getAnnotatedWBParameters(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableList(this.annotatedParameters.get(annotationType));
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof WeldMethod) {
            WeldMethod that = (WeldMethod)other;
            return this.getDeclaringType().equals(that.getDeclaringType()) && this.getName().equals(that.getName()) && ((Object)this.getWBParameters()).equals(that.getWBParameters());
        }
        return false;
    }

    @Override
    public boolean isEquivalent(Method method) {
        return this.getDeclaringType().isEquivalent(method.getDeclaringClass()) && this.getName().equals(method.getName()) && Arrays.equals(this.getParameterTypesAsArray(), method.getParameterTypes());
    }

    @Override
    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    @Override
    public T invokeOnInstance(Object instance, Object ... parameters) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method method = Reflections.lookupMethod(this.getName(), this.getParameterTypesAsArray(), instance);
        Object result = method.invoke(instance, parameters);
        return (T)result;
    }

    @Override
    public T invoke(Object instance, Object ... parameters) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object result = this.method.invoke(instance, parameters);
        return (T)result;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public String toString() {
        return this.toString;
    }

    @Override
    public MethodSignature getSignature() {
        return this.signature;
    }

    public List<AnnotatedParameter<X>> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }
}

