/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.metadata.cache;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import javax.enterprise.inject.Nonbinding;
import javax.inject.Qualifier;
import org.jboss.weld.DefinitionException;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.log.Log;
import org.jboss.weld.log.Logging;
import org.jboss.weld.metadata.cache.AnnotationModel;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.Reflections;
import org.jboss.weld.util.collections.Arrays2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingTypeModel<T extends Annotation>
extends AnnotationModel<T> {
    private static final Set<Class<? extends Annotation>> META_ANNOTATIONS = Arrays2.asSet(Qualifier.class);
    private static final Log log = Logging.getLog(BindingTypeModel.class);
    private Set<WeldMethod<?, ?>> nonBindingTypes;

    public BindingTypeModel(Class<T> type, ClassTransformer transformer) {
        super(type, transformer);
    }

    @Override
    protected void init() {
        super.init();
        this.initNonBindingTypes();
        this.checkArrayAndAnnotationValuedMembers();
    }

    private void checkArrayAndAnnotationValuedMembers() {
        for (WeldMethod<?, ?> annotatedMethod : this.getAnnotatedAnnotation().getMembers()) {
            if (!Reflections.isArrayType(annotatedMethod.getJavaClass()) && !Annotation.class.isAssignableFrom(annotatedMethod.getJavaClass()) || this.nonBindingTypes.contains(annotatedMethod)) continue;
            throw new DefinitionException("Member of array type or annotation type must be annotated @NonBinding " + annotatedMethod);
        }
    }

    @Override
    protected Set<Class<? extends Annotation>> getMetaAnnotationTypes() {
        return META_ANNOTATIONS;
    }

    public boolean hasNonBindingTypes() {
        return this.nonBindingTypes.size() > 0;
    }

    public Set<WeldMethod<?, ?>> getNonBindingTypes() {
        return this.nonBindingTypes;
    }

    protected void initNonBindingTypes() {
        this.nonBindingTypes = this.getAnnotatedAnnotation().getAnnotatedMembers(Nonbinding.class);
    }

    public boolean isEqual(Annotation instance, Annotation other) {
        if (instance.annotationType().equals(this.getRawType()) && other.annotationType().equals(this.getRawType())) {
            for (WeldMethod<?, ?> annotatedMethod : this.getAnnotatedAnnotation().getMembers()) {
                if (this.nonBindingTypes.contains(annotatedMethod)) continue;
                try {
                    Object thatValue;
                    Object thisValue = annotatedMethod.invoke(instance, new Object[0]);
                    if (thisValue.equals(thatValue = annotatedMethod.invoke(other, new Object[0]))) continue;
                    return false;
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return (this.isValid() ? "Valid" : "Invalid") + " binding type model for " + this.getRawType() + " with non-binding types " + this.getNonBindingTypes();
    }
}

