/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.metadata.cache;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import javax.enterprise.inject.Nonbinding;
import javax.interceptor.InterceptorBinding;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.log.Log;
import org.jboss.weld.log.Logging;
import org.jboss.weld.metadata.cache.AnnotationModel;
import org.jboss.weld.metadata.cache.BindingTypeModel;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.collections.Arrays2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorBindingModel<T extends Annotation>
extends AnnotationModel<T> {
    private static final Set<Class<? extends Annotation>> META_ANNOTATIONS = Arrays2.asSet(InterceptorBinding.class);
    private static final Log log = Logging.getLog(BindingTypeModel.class);
    private Set<WeldMethod<?, ?>> nonBindingTypes;
    private Set<Annotation> inheritedInterceptionBindingTypes;
    private Set<Annotation> metaAnnotations;

    public InterceptorBindingModel(Class<T> type, ClassTransformer transformer) {
        super(type, transformer);
        this.initNonBindingTypes();
        this.initInterceptionBindingTypes();
        this.metaAnnotations = this.getAnnotatedAnnotation().getAnnotations();
    }

    @Override
    protected Set<Class<? extends Annotation>> getMetaAnnotationTypes() {
        return META_ANNOTATIONS;
    }

    public Set<Annotation> getMetaAnnotations() {
        return this.metaAnnotations;
    }

    protected void initNonBindingTypes() {
        this.nonBindingTypes = this.getAnnotatedAnnotation().getAnnotatedMembers(Nonbinding.class);
    }

    protected void initInterceptionBindingTypes() {
        this.inheritedInterceptionBindingTypes = this.getAnnotatedAnnotation().getMetaAnnotations(InterceptorBinding.class);
    }

    public Set<Annotation> getInheritedInterceptionBindingTypes() {
        return this.inheritedInterceptionBindingTypes;
    }

    public boolean isEqual(Annotation instance, Annotation other) {
        if (instance.annotationType().equals(this.getRawType()) && other.annotationType().equals(this.getRawType())) {
            for (WeldMethod<?, ?> annotatedMethod : this.getAnnotatedAnnotation().getMembers()) {
                if (this.nonBindingTypes.contains(annotatedMethod)) continue;
                try {
                    Object thatValue;
                    Object thisValue = annotatedMethod.invoke(instance, new Object[0]);
                    if (thisValue.equals(thatValue = annotatedMethod.invoke(other, new Object[0]))) continue;
                    return false;
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            return true;
        }
        return false;
    }
}

