/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.weld.BeanManagerImpl;
import org.jboss.weld.bean.InterceptorImpl;
import org.jboss.weld.resolution.InterceptorResolvable;
import org.jboss.weld.resolution.ResolvableTransformer;
import org.jboss.weld.resolution.TypeSafeResolver;
import org.jboss.weld.util.Beans;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeSafeInterceptorResolver
extends TypeSafeResolver<InterceptorResolvable, InterceptorImpl<?>> {
    private BeanManagerImpl manager;

    public TypeSafeInterceptorResolver(BeanManagerImpl manager, Iterable<InterceptorImpl<?>> interceptors) {
        super(interceptors);
        this.manager = manager;
    }

    @Override
    protected boolean matches(InterceptorResolvable resolvable, InterceptorImpl<?> bean) {
        return bean.intercepts(resolvable.getInterceptionType()) && bean.getInterceptorBindingTypes().size() > 0 && Beans.containsAllInterceptionBindings(bean.getInterceptorBindingTypes(), resolvable.getQualifiers(), this.getManager()) && this.getManager().getEnabledInterceptorClasses().contains(bean.getType());
    }

    @Override
    protected Set<InterceptorImpl<?>> sortResult(Set<InterceptorImpl<?>> matchedInterceptors) {
        TreeSet sortedBeans = new TreeSet(new Comparator<InterceptorImpl<?>>(){

            @Override
            public int compare(InterceptorImpl<?> o1, InterceptorImpl<?> o2) {
                List<Class<?>> enabledInterceptors = TypeSafeInterceptorResolver.this.getManager().getEnabledInterceptorClasses();
                int p1 = enabledInterceptors.indexOf(o1.getType());
                int p2 = enabledInterceptors.indexOf(o2.getType());
                return p1 - p2;
            }
        });
        sortedBeans.addAll(matchedInterceptors);
        return sortedBeans;
    }

    @Override
    protected Set<InterceptorImpl<?>> filterResult(Set<InterceptorImpl<?>> matched) {
        return matched;
    }

    @Override
    protected Iterable<ResolvableTransformer> getTransformers() {
        return Collections.emptySet();
    }

    public BeanManagerImpl getManager() {
        return this.manager;
    }
}

