/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import java.beans.Introspector;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.security.AccessControlException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Qualifier;
import org.jboss.weld.DeploymentException;
import org.jboss.weld.log.Log;
import org.jboss.weld.log.Logging;
import org.jboss.weld.util.Types;
import org.jboss.weld.util.reflection.ParameterizedTypeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reflections {
    private static final Log log = Logging.getLog(Reflections.class);
    public static final Type[] EMPTY_TYPES = new Type[0];
    public static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];

    public static String getPropertyName(Method method) {
        String methodName = method.getName();
        if (methodName.matches("^(get).*") && method.getParameterTypes().length == 0) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        if (methodName.matches("^(is).*") && method.getParameterTypes().length == 0) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        return null;
    }

    public static boolean isFinal(Class<?> clazz) {
        return Modifier.isFinal(clazz.getModifiers());
    }

    public static boolean isFinal(Member member) {
        return Modifier.isFinal(member.getModifiers());
    }

    public static boolean isTypeOrAnyMethodFinal(Class<?> type) {
        if (Reflections.isFinal(type)) {
            return true;
        }
        for (Method method : type.getDeclaredMethods()) {
            if (!Reflections.isFinal(method)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrimitive(Class<?> type) {
        return type.isPrimitive();
    }

    public static boolean isPackagePrivate(int mod) {
        return !Modifier.isPrivate(mod) && !Modifier.isProtected(mod) && !Modifier.isPublic(mod);
    }

    public static boolean isStatic(Class<?> type) {
        return Modifier.isStatic(type.getModifiers());
    }

    public static boolean isStatic(Member member) {
        return Modifier.isStatic(member.getModifiers());
    }

    public static boolean isTransient(Member member) {
        return Modifier.isTransient(member.getModifiers());
    }

    public static boolean isAbstract(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isNonStaticInnerClass(Class<?> clazz) {
        return (clazz.isMemberClass() || clazz.isAnonymousClass()) && !Reflections.isStatic(clazz);
    }

    public static <T> Constructor<T> getDeclaredConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        try {
            return clazz.getDeclaredConstructor(parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Error accessing constructor (with parameters " + Arrays.toString(parameterTypes) + ") of " + clazz, e);
        }
    }

    public static Type[] getActualTypeArguments(Class<?> clazz) {
        Type type = new HierarchyDiscovery(clazz).getResolvedType();
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments();
        }
        return EMPTY_TYPES;
    }

    public static boolean isArrayType(Class<?> rawType) {
        return rawType.isArray();
    }

    public static boolean isParameterizedType(Class<?> type) {
        return type.getTypeParameters().length > 0;
    }

    public static boolean isParamerterizedTypeWithWildcard(Class<?> type) {
        if (Reflections.isParameterizedType(type)) {
            return Reflections.containsWildcards(type.getTypeParameters());
        }
        return false;
    }

    public static boolean containsWildcards(Type[] types) {
        for (Type type : types) {
            if (!(type instanceof WildcardType)) continue;
            return true;
        }
        return false;
    }

    public static Set<Type> createTypeClosure(Class<?> rawType, Type[] actualTypeArguments) {
        ParameterizedTypeImpl type = new ParameterizedTypeImpl(rawType, actualTypeArguments, rawType.getDeclaringClass());
        return new HierarchyDiscovery(type).getFlattenedTypes();
    }

    public static Object invokeAndWrap(Method method, Object instance, Object ... parameters) {
        try {
            method.setAccessible(true);
            return method.invoke(instance, parameters);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Error invoking method " + method.getName() + " on " + method.getDeclaringClass(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error invoking method " + method.getName() + " on " + method.getDeclaringClass(), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error invoking method " + method.getName() + " on " + method.getDeclaringClass(), e);
        }
    }

    public static Object invokeAndWrap(String methodName, Object instance, Object ... parameters) {
        Class[] parameterTypes = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameterTypes[i] = parameters[i].getClass();
        }
        try {
            return Reflections.invokeAndWrap(instance.getClass().getMethod(methodName, parameterTypes), instance, parameters);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Error invoking method " + methodName + " on " + instance.getClass(), e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Error invoking method " + methodName + " on " + instance.getClass(), e);
        }
    }

    public static Object getAndWrap(Field field, Object target) {
        try {
            return field.get(target);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Error getting field " + field.getName() + " on " + field.getDeclaringClass(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error getting field " + field.getName() + " on " + field.getDeclaringClass(), e);
        }
    }

    public static Object getAndWrap(String fieldName, Object target) {
        try {
            return Reflections.getAndWrap(target.getClass().getField(fieldName), target);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Error getting field " + fieldName + " on " + target.getClass(), e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Error getting field " + fieldName + " on " + target.getClass(), e);
        }
    }

    public static Method lookupMethod(Method method, Object instance) {
        try {
            return Reflections.lookupMethod(method.getName(), method.getParameterTypes(), instance);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Method lookupMethod(String methodName, Class<?>[] parameterTypes, Object instance) throws NoSuchMethodException {
        return Reflections.lookupMethod(methodName, parameterTypes, instance.getClass());
    }

    private static Method lookupMethod(String methodName, Class<?>[] parameterTypes, Class<?> c) throws NoSuchMethodException {
        for (Class<?> clazz = c; clazz != null; clazz = clazz.getSuperclass()) {
            for (Class<?> intf : clazz.getInterfaces()) {
                try {
                    return Reflections.lookupMethod(methodName, parameterTypes, intf);
                }
                catch (NoSuchMethodException e) {
                }
            }
            try {
                Method targetMethod = clazz.getDeclaredMethod(methodName, parameterTypes);
                if (!targetMethod.isAccessible()) {
                    targetMethod.setAccessible(true);
                }
                return targetMethod;
            }
            catch (NoSuchMethodException nsme) {
                continue;
            }
        }
        throw new NoSuchMethodException("Method " + methodName + Arrays.asList(parameterTypes).toString().replace("[", "(").replace("]", ")") + " not implemented by instance " + c.getName());
    }

    @Deprecated
    public static boolean isBindings(Annotation binding) {
        boolean isBindingAnnotation = false;
        if (binding.annotationType().isAnnotationPresent(Qualifier.class) && binding.annotationType().isAnnotationPresent(Retention.class) && binding.annotationType().getAnnotation(Retention.class).value().equals((Object)RetentionPolicy.RUNTIME)) {
            isBindingAnnotation = true;
        }
        return isBindingAnnotation;
    }

    public static boolean isAssignableFrom(Class<?> rawType1, Type[] actualTypeArguments1, Class<?> rawType2, Type[] actualTypeArguments2) {
        return Types.boxedClass(rawType1).isAssignableFrom(Types.boxedClass(rawType2)) && Reflections.isAssignableFrom(actualTypeArguments1, actualTypeArguments2);
    }

    public static boolean matches(Class<?> rawType1, Type[] actualTypeArguments1, Class<?> rawType2, Type[] actualTypeArguments2) {
        return Types.boxedClass(rawType1).equals(Types.boxedClass(rawType2)) && Reflections.isAssignableFrom(actualTypeArguments1, actualTypeArguments2);
    }

    public static boolean isAssignableFrom(Type[] actualTypeArguments1, Type[] actualTypeArguments2) {
        for (int i = 0; i < actualTypeArguments1.length; ++i) {
            Type type1 = actualTypeArguments1[i];
            Object type2 = Object.class;
            if (actualTypeArguments2.length > i) {
                type2 = actualTypeArguments2[i];
            }
            if (Reflections.isAssignableFrom(type1, type2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAssignableFrom(Type type1, Set<? extends Type> types2) {
        for (Type type : types2) {
            if (!Reflections.isAssignableFrom(type1, type)) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(Type type1, Set<? extends Type> types2) {
        for (Type type : types2) {
            if (!Reflections.matches(type1, type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAssignableFrom(Type type1, Type[] types2) {
        for (Type type2 : types2) {
            if (!Reflections.isAssignableFrom(type1, type2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAssignableFrom(Type type1, Type type2) {
        TypeVariable typeVariable;
        WildcardType wildcardType;
        ParameterizedType parameterizedType1;
        Class clazz;
        if (type1 instanceof Class && Reflections.isAssignableFrom(clazz = (Class)type1, EMPTY_TYPES, type2)) {
            return true;
        }
        if (type1 instanceof ParameterizedType && (parameterizedType1 = (ParameterizedType)type1).getRawType() instanceof Class && Reflections.isAssignableFrom((Class)parameterizedType1.getRawType(), parameterizedType1.getActualTypeArguments(), type2)) {
            return true;
        }
        if (type1 instanceof WildcardType && Reflections.isTypeBounded(type2, (wildcardType = (WildcardType)type1).getLowerBounds(), wildcardType.getUpperBounds())) {
            return true;
        }
        if (type2 instanceof WildcardType && Reflections.isTypeBounded(type1, (wildcardType = (WildcardType)type2).getUpperBounds(), wildcardType.getLowerBounds())) {
            return true;
        }
        if (type1 instanceof TypeVariable && Reflections.isTypeBounded(type2, EMPTY_TYPES, (typeVariable = (TypeVariable)type1).getBounds())) {
            return true;
        }
        return type2 instanceof TypeVariable && Reflections.isTypeBounded(type1, (typeVariable = (TypeVariable)type2).getBounds(), EMPTY_TYPES);
    }

    public static boolean matches(Type type1, Type type2) {
        TypeVariable typeVariable;
        WildcardType wildcardType;
        ParameterizedType parameterizedType1;
        Class clazz;
        if (type1 instanceof Class && Reflections.matches(clazz = (Class)type1, EMPTY_TYPES, type2)) {
            return true;
        }
        if (type1 instanceof ParameterizedType && (parameterizedType1 = (ParameterizedType)type1).getRawType() instanceof Class && Reflections.matches((Class)parameterizedType1.getRawType(), parameterizedType1.getActualTypeArguments(), type2)) {
            return true;
        }
        if (type1 instanceof WildcardType && Reflections.isTypeBounded(type2, (wildcardType = (WildcardType)type1).getLowerBounds(), wildcardType.getUpperBounds())) {
            return true;
        }
        if (type2 instanceof WildcardType && Reflections.isTypeBounded(type1, (wildcardType = (WildcardType)type2).getUpperBounds(), wildcardType.getLowerBounds())) {
            return true;
        }
        if (type1 instanceof TypeVariable && Reflections.isTypeBounded(type2, EMPTY_TYPES, (typeVariable = (TypeVariable)type1).getBounds())) {
            return true;
        }
        return type2 instanceof TypeVariable && Reflections.isTypeBounded(type1, (typeVariable = (TypeVariable)type2).getBounds(), EMPTY_TYPES);
    }

    public static boolean isTypeBounded(Type type, Type[] lowerBounds, Type[] upperBounds) {
        if (lowerBounds.length > 0 && !Reflections.isAssignableFrom(type, lowerBounds)) {
            return false;
        }
        return upperBounds.length <= 0 || Reflections.isAssignableFrom(upperBounds, type);
    }

    public static boolean isAssignableFrom(Class<?> rawType1, Type[] actualTypeArguments1, Type type2) {
        Class clazz;
        ParameterizedType parameterizedType;
        return type2 instanceof ParameterizedType ? (parameterizedType = (ParameterizedType)type2).getRawType() instanceof Class && Reflections.isAssignableFrom(rawType1, actualTypeArguments1, (Class)parameterizedType.getRawType(), parameterizedType.getActualTypeArguments()) : type2 instanceof Class && Reflections.isAssignableFrom(rawType1, actualTypeArguments1, clazz = (Class)type2, EMPTY_TYPES);
    }

    public static boolean matches(Class<?> rawType1, Type[] actualTypeArguments1, Type type2) {
        Class clazz;
        ParameterizedType parameterizedType;
        return type2 instanceof ParameterizedType ? (parameterizedType = (ParameterizedType)type2).getRawType() instanceof Class && Reflections.matches(rawType1, actualTypeArguments1, (Class)parameterizedType.getRawType(), parameterizedType.getActualTypeArguments()) : type2 instanceof Class && Reflections.matches(rawType1, actualTypeArguments1, clazz = (Class)type2, EMPTY_TYPES);
    }

    public static boolean isAssignableFrom(Set<Type> types1, Set<Type> types2) {
        for (Type type : types1) {
            if (!Reflections.isAssignableFrom(type, types2)) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(Set<Type> types1, Set<Type> types2) {
        for (Type type : types1) {
            if (!Reflections.matches(type, types2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAssignableFrom(Set<Type> types1, Type type2) {
        for (Type type : types1) {
            if (!Reflections.isAssignableFrom(type, type2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAssignableFrom(Type[] types1, Type type2) {
        for (Type type : types1) {
            if (!Reflections.isAssignableFrom(type, type2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSerializable(Class<?> clazz) {
        return clazz.isPrimitive() || Serializable.class.isAssignableFrom(clazz);
    }

    public static Field ensureAccessible(Field field) {
        if (!field.isAccessible() && !Reflections.isIgnorePackage(field.getDeclaringClass().getPackage())) {
            field.setAccessible(true);
        }
        return field;
    }

    public static Method ensureAccessible(Method method) {
        if (!method.isAccessible() && !Reflections.isIgnorePackage(method.getDeclaringClass().getPackage())) {
            method.setAccessible(true);
        }
        return method;
    }

    public static <T> Constructor<T> ensureAccessible(Constructor<T> constructor) {
        Class<T> c = constructor.getDeclaringClass();
        Package p = c.getPackage();
        if (!constructor.isAccessible() && !Reflections.isIgnorePackage(p)) {
            constructor.setAccessible(true);
        }
        return constructor;
    }

    private static boolean isIgnorePackage(Package pkg) {
        if (pkg != null) {
            return pkg.getName().startsWith("java.lang");
        }
        return false;
    }

    public static Class<?>[] extractValues(Annotation annotation) {
        try {
            Class[] valueClasses = (Class[])annotation.annotationType().getMethod("value", new Class[0]).invoke((Object)annotation, new Object[0]);
            return valueClasses;
        }
        catch (Exception e) {
            throw new DeploymentException("Cannot access values() on annotation", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HierarchyDiscovery {
        private final Type type;
        private Set<Type> types;

        public HierarchyDiscovery(Type type) {
            this.type = type;
        }

        protected void add(Type type) {
            this.types.add(type);
        }

        public Set<Type> getFlattenedTypes() {
            if (this.types == null) {
                this.types = new HashSet<Type>();
                this.discoverTypes(this.type);
            }
            return this.types;
        }

        public Type getResolvedType() {
            if (this.type instanceof Class) {
                Class clazz = (Class)this.type;
                return this.resolveType(clazz);
            }
            return this.type;
        }

        private void discoverTypes(Type type) {
            if (type != null) {
                if (type instanceof Class) {
                    Class clazz = (Class)type;
                    this.add(this.resolveType(clazz));
                    this.discoverFromClass(clazz);
                } else {
                    Type rawType;
                    if (type instanceof ParameterizedType && (rawType = ((ParameterizedType)type).getRawType()) instanceof Class) {
                        this.discoverFromClass((Class)rawType);
                    }
                    this.add(type);
                }
            }
        }

        private Type resolveType(Class<?> clazz) {
            if (clazz.getTypeParameters().length > 0) {
                Type[] actualTypeParameters = clazz.getTypeParameters();
                ParameterizedTypeImpl parameterizedType = new ParameterizedTypeImpl(clazz, actualTypeParameters, clazz.getDeclaringClass());
                return parameterizedType;
            }
            return clazz;
        }

        private void discoverFromClass(Class<?> clazz) {
            try {
                this.discoverTypes(this.resolveType(this.type, clazz.getGenericSuperclass()));
                for (Type c : clazz.getGenericInterfaces()) {
                    this.discoverTypes(this.resolveType(this.type, c));
                }
            }
            catch (AccessControlException e) {
                log.trace((Object)("Security exception scanning " + clazz.getName()), (Throwable)e, new Object[0]);
            }
        }

        private Type resolveType(Type beanType, Type type) {
            if (type instanceof ParameterizedType) {
                if (beanType instanceof ParameterizedType) {
                    return this.resolveParameterizedType((ParameterizedType)beanType, (ParameterizedType)type);
                }
                if (beanType instanceof Class) {
                    return this.resolveType(((Class)beanType).getGenericSuperclass(), type);
                }
            }
            if (type instanceof TypeVariable) {
                if (beanType instanceof ParameterizedType) {
                    return this.resolveTypeParameter((ParameterizedType)beanType, (TypeVariable)type);
                }
                if (beanType instanceof Class) {
                    return this.resolveType(((Class)beanType).getGenericSuperclass(), type);
                }
            }
            return type;
        }

        private Type resolveParameterizedType(ParameterizedType beanType, ParameterizedType parameterizedType) {
            Type rawType = parameterizedType.getRawType();
            Type[] actualTypes = parameterizedType.getActualTypeArguments();
            Type resolvedRawType = this.resolveType(beanType, rawType);
            Type[] resolvedActualTypes = new Type[actualTypes.length];
            for (int i = 0; i < actualTypes.length; ++i) {
                resolvedActualTypes[i] = this.resolveType(beanType, actualTypes[i]);
            }
            return new ParameterizedTypeImpl(resolvedRawType, resolvedActualTypes, parameterizedType.getOwnerType());
        }

        private Type resolveTypeParameter(ParameterizedType beanType, TypeVariable<?> typeVariable) {
            Class actualType = (Class)beanType.getRawType();
            TypeVariable<Class<T>>[] typeVariables = actualType.getTypeParameters();
            Type[] actualTypes = beanType.getActualTypeArguments();
            for (int i = 0; i < typeVariables.length; ++i) {
                if (!typeVariables[i].equals(typeVariable)) continue;
                return this.resolveType(this.type, actualTypes[i]);
            }
            Type genericSuperType = actualType.getGenericSuperclass();
            Type type = this.resolveType(genericSuperType, typeVariable);
            if (!(type instanceof TypeVariable)) {
                return type;
            }
            for (Type interfaceType : actualType.getGenericInterfaces()) {
                Type resolvedType = this.resolveType(interfaceType, typeVariable);
                if (resolvedType instanceof TypeVariable) continue;
                return resolvedType;
            }
            return typeVariable;
        }
    }
}

