/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.xml;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.inject.InjectionException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jboss.weld.DeploymentException;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.util.dom.NodeListIterable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeansXmlParser {
    private final Iterable<URL> beansXml;
    private final ResourceLoader resourceLoader;
    private List<Class<? extends Annotation>> enabledPolicyStereotypes;
    private List<Class<?>> enabledPolicyClasses;
    private List<Class<?>> enabledDecoratorClasses;
    private List<Class<?>> enabledInterceptorClasses;

    public List<Class<?>> getEnabledPolicyClasses() {
        return this.enabledPolicyClasses;
    }

    public List<Class<? extends Annotation>> getEnabledPolicyStereotypes() {
        return this.enabledPolicyStereotypes;
    }

    public List<Class<?>> getEnabledDecoratorClasses() {
        return this.enabledDecoratorClasses;
    }

    public List<Class<?>> getEnabledInterceptorClasses() {
        return this.enabledInterceptorClasses;
    }

    public BeansXmlParser(ResourceLoader resourceLoader, Iterable<URL> beansXml) {
        this.beansXml = beansXml;
        this.resourceLoader = resourceLoader;
    }

    public void parse() {
        DocumentBuilder documentBuilder;
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new InjectionException("Error configuring XML parser", (Throwable)e);
        }
        ArrayList<XmlElement> policiesElements = new ArrayList<XmlElement>();
        ArrayList<XmlElement> decoratorsElements = new ArrayList<XmlElement>();
        ArrayList<XmlElement> interceptorsElements = new ArrayList<XmlElement>();
        for (URL url : this.beansXml) {
            Document document;
            boolean fileHasContents;
            InputStream is;
            try {
                is = url.openStream();
                fileHasContents = is.available() > 0;
            }
            catch (IOException e) {
                throw new InjectionException("Error loading beans.xml " + url.toString(), (Throwable)e);
            }
            if (!fileHasContents) continue;
            try {
                document = documentBuilder.parse(is);
                document.normalize();
            }
            catch (SAXException e) {
                throw new DeploymentException("Error parsing beans.xml " + url.toString(), e);
            }
            catch (IOException e) {
                throw new DeploymentException("Error loading beans.xml " + url.toString(), e);
            }
            Element beans = document.getDocumentElement();
            for (Node child : new NodeListIterable(beans.getChildNodes())) {
                if (child instanceof Element && "alternatives".equals(child.getNodeName())) {
                    policiesElements.add(new XmlElement(url, (Element)child));
                }
                if (child instanceof Element && "interceptors".equals(child.getNodeName())) {
                    interceptorsElements.add(new XmlElement(url, (Element)child));
                }
                if (!(child instanceof Element) || !"decorators".equals(child.getNodeName())) continue;
                decoratorsElements.add(new XmlElement(url, (Element)child));
            }
        }
        if (policiesElements.size() > 1) {
            throw new DeploymentException("<alternatives> can only be specified once, but it is specified muliple times " + policiesElements);
        }
        if (policiesElements.size() == 1) {
            this.enabledPolicyStereotypes = new ArrayList<Class<? extends Annotation>>();
            this.enabledPolicyClasses = new ArrayList();
            BeansXmlParser.processPolicyElement(this.resourceLoader, (XmlElement)policiesElements.get(0), this.enabledPolicyClasses, this.enabledPolicyStereotypes);
        }
        if (decoratorsElements.size() > 1) {
            throw new DeploymentException("<decorator> can only be specified once, but it is specified muliple times " + decoratorsElements);
        }
        if (decoratorsElements.size() == 1) {
            this.enabledDecoratorClasses = new ArrayList();
            this.enabledDecoratorClasses.addAll(BeansXmlParser.processElement(this.resourceLoader, (XmlElement)decoratorsElements.get(0)));
        }
        if (interceptorsElements.size() > 1) {
            throw new DeploymentException("<interceptor> can only be specified once, but it is specified muliple times " + interceptorsElements);
        }
        if (interceptorsElements.size() == 1) {
            this.enabledInterceptorClasses = new ArrayList();
            this.enabledInterceptorClasses.addAll(BeansXmlParser.processElement(this.resourceLoader, (XmlElement)interceptorsElements.get(0)));
        }
    }

    private static void processPolicyElement(ResourceLoader resourceLoader, XmlElement element, List<Class<?>> enabledPolicyClasses, List<Class<? extends Annotation>> enabledPolicyStereotypes) {
        for (Node child : new NodeListIterable(element.getElement().getChildNodes())) {
            String className = BeansXmlParser.processNode(child);
            if (className == null) continue;
            try {
                Class clazz = resourceLoader.classForName(className);
                if (clazz.isAnnotation()) {
                    enabledPolicyStereotypes.add(clazz.asSubclass(Annotation.class));
                    continue;
                }
                enabledPolicyClasses.add(clazz);
            }
            catch (ResourceLoadingException e) {
                throw new DeploymentException("Cannot load class " + className + " defined in " + element.getFile().toString());
            }
        }
    }

    private static String processNode(Node node) {
        if (node instanceof Element && node.getChildNodes().getLength() == 1 && node.getChildNodes().item(0) instanceof Text) {
            String className = ((Text)node.getChildNodes().item(0)).getData();
            return className;
        }
        return null;
    }

    private static List<Class<?>> processElement(ResourceLoader resourceLoader, XmlElement element) {
        ArrayList list = new ArrayList();
        for (Node child : new NodeListIterable(element.getElement().getChildNodes())) {
            String className = BeansXmlParser.processNode(child);
            if (className == null) continue;
            try {
                list.add(resourceLoader.classForName(className));
            }
            catch (ResourceLoadingException e) {
                throw new DeploymentException("Cannot load class " + className + " defined in " + element.getFile().toString());
            }
        }
        return list;
    }

    private static class XmlElement {
        private URL file;
        private Element element;

        public XmlElement(URL file, Element element) {
            this.file = file;
            this.element = element;
        }

        public URL getFile() {
            return this.file;
        }

        public Element getElement() {
            return this.element;
        }

        public String toString() {
            return "File: " + this.getFile() + "; Node: " + this.getElement();
        }
    }
}

