/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import com.google.common.base.Supplier;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.New;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.Interceptor;
import javax.inject.Named;
import javax.inject.Scope;
import org.jboss.interceptor.spi.metadata.ClassMetadata;
import org.jboss.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.Container;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.AbstractProducerBean;
import org.jboss.weld.bean.DisposalMethod;
import org.jboss.weld.bean.InterceptorImpl;
import org.jboss.weld.bean.NewManagedBean;
import org.jboss.weld.bean.NewSessionBean;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bean.WeldDecorator;
import org.jboss.weld.bean.builtin.AbstractBuiltInBean;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.event.ObserverMethodImpl;
import org.jboss.weld.exceptions.AmbiguousResolutionException;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.exceptions.IllegalProductException;
import org.jboss.weld.exceptions.InconsistentSpecializationException;
import org.jboss.weld.exceptions.NullableDependencyException;
import org.jboss.weld.exceptions.UnproxyableResolutionException;
import org.jboss.weld.exceptions.UnserializableDependencyException;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.ValidatorMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.serialization.spi.helpers.SerializableContextual;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Validator
implements Service {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BOOTSTRAP);

    private void validateBean(Bean<?> bean, BeanManagerImpl beanManager) {
        for (InjectionPoint ij : bean.getInjectionPoints()) {
            this.validateInjectionPoint(ij, beanManager);
        }
        boolean normalScoped = ((MetaAnnotationStore)beanManager.getServices().get(MetaAnnotationStore.class)).getScopeModel(bean.getScope()).isNormal();
        if (normalScoped && !Beans.isBeanProxyable(bean)) {
            throw Proxies.getUnproxyableTypesException(bean.getTypes());
        }
        if (!normalScoped) {
            Validator.validatePseudoScopedBean(bean, beanManager);
        }
    }

    private void validateRIBean(RIBean<?> bean, BeanManagerImpl beanManager, Collection<RIBean<?>> specializedBeans) {
        this.validateBean(bean, beanManager);
        if (!(bean instanceof NewManagedBean) && !(bean instanceof NewSessionBean)) {
            RIBean<?> abstractBean = bean;
            if (abstractBean.isSpecializing()) {
                if (specializedBeans.contains(abstractBean.getSpecializedBean())) {
                    throw new InconsistentSpecializationException(ValidatorMessage.BEAN_SPECIALIZED_TOO_MANY_TIMES, bean);
                }
                specializedBeans.add(abstractBean.getSpecializedBean());
            }
            if (bean instanceof AbstractClassBean) {
                AbstractClassBean classBean = (AbstractClassBean)bean;
                if (classBean.hasDecorators()) {
                    this.validateDecorators(beanManager, classBean);
                }
                if (classBean.hasInterceptors()) {
                    this.validateInterceptors(beanManager, classBean);
                }
            }
        }
    }

    private void validateInterceptors(BeanManagerImpl beanManager, AbstractClassBean<?> classBean) {
        Set interceptors;
        InterceptionModel<ClassMetadata<?>, ?> interceptionModel = beanManager.getInterceptorModelRegistry().get(classBean.getType());
        if (interceptionModel != null && (interceptors = interceptionModel.getAllInterceptors()).size() > 0) {
            for (InterceptorMetadata interceptorMetadata : interceptors) {
                if (interceptorMetadata.getInterceptorReference().getInterceptor() instanceof SerializableContextual) {
                    SerializableContextual serializableContextual = (SerializableContextual)Reflections.cast(interceptorMetadata.getInterceptorReference().getInterceptor());
                    if (classBean.isPassivationCapableBean() && !((InterceptorImpl)serializableContextual.get()).isSerializable()) {
                        throw new DeploymentException(ValidatorMessage.PASSIVATING_BEAN_WITH_NONSERIALIZABLE_INTERCEPTOR, classBean, serializableContextual.get());
                    }
                    for (InjectionPoint injectionPoint : ((Interceptor)serializableContextual.get()).getInjectionPoints()) {
                        Bean resolvedBean = beanManager.resolve(beanManager.getBeans(injectionPoint));
                        this.validateInjectionPoint(injectionPoint, beanManager);
                        if (!classBean.isPassivationCapableBean()) continue;
                        this.validateInjectionPointPassivationCapable(injectionPoint, resolvedBean, beanManager);
                    }
                }
                if (!(interceptorMetadata.getInterceptorReference().getInterceptor() instanceof ClassMetadata)) continue;
                ClassMetadata classMetadata = (ClassMetadata)interceptorMetadata.getInterceptorReference().getInterceptor();
                if (classBean.isPassivationCapableBean() && !Reflections.isSerializable(classMetadata.getJavaClass())) {
                    throw new DeploymentException(ValidatorMessage.PASSIVATING_BEAN_WITH_NONSERIALIZABLE_INTERCEPTOR, this, classMetadata.getJavaClass().getName());
                }
                InjectionTarget injectionTarget = (InjectionTarget)Reflections.cast(beanManager.createInjectionTarget(beanManager.createAnnotatedType(classMetadata.getJavaClass())));
                for (InjectionPoint injectionPoint : injectionTarget.getInjectionPoints()) {
                    Bean resolvedBean = beanManager.resolve(beanManager.getBeans(injectionPoint));
                    this.validateInjectionPoint(injectionPoint, beanManager);
                    if (!classBean.isPassivationCapableBean()) continue;
                    this.validateInjectionPointPassivationCapable(injectionPoint, resolvedBean, beanManager);
                }
            }
        }
    }

    private void validateDecorators(BeanManagerImpl beanManager, AbstractClassBean<?> classBean) {
        for (Decorator<?> decorator : classBean.getDecorators()) {
            if (classBean.isPassivationCapableBean() && !((WeldDecorator)decorator).getWeldAnnotated().isSerializable()) {
                throw new UnserializableDependencyException(ValidatorMessage.PASSIVATING_BEAN_WITH_NONSERIALIZABLE_DECORATOR, classBean, decorator);
            }
            for (InjectionPoint ij : decorator.getInjectionPoints()) {
                if (ij.isDelegate()) continue;
                Bean resolvedBean = beanManager.resolve(beanManager.getBeans(ij));
                this.validateInjectionPoint(ij, beanManager);
                if (!classBean.isPassivationCapableBean()) continue;
                this.validateInjectionPointPassivationCapable(ij, resolvedBean, beanManager);
            }
        }
    }

    public void validateInjectionPoint(InjectionPoint ij, BeanManagerImpl beanManager) {
        boolean newBean;
        if (ij.getAnnotated().getAnnotation(New.class) != null && ij.getQualifiers().size() > 1) {
            throw new DefinitionException(ValidatorMessage.NEW_WITH_QUALIFIERS, ij);
        }
        if (ij.getType().equals(InjectionPoint.class) && ij.getBean() == null) {
            throw new DefinitionException(ValidatorMessage.INJECTION_INTO_NON_BEAN, ij);
        }
        if (ij.getType().equals(InjectionPoint.class) && !Dependent.class.equals((Object)ij.getBean().getScope())) {
            throw new DefinitionException(ValidatorMessage.INJECTION_INTO_NON_DEPENDENT_BEAN, ij);
        }
        if (ij.getType() instanceof TypeVariable) {
            throw new DefinitionException(ValidatorMessage.INJECTION_POINT_WITH_TYPE_VARIABLE, ij);
        }
        if (!(ij.getMember() instanceof Field) && ij.getAnnotated().isAnnotationPresent(Named.class) && ((Named)ij.getAnnotated().getAnnotation(Named.class)).value().equals("")) {
            throw new DefinitionException(ValidatorMessage.NON_FIELD_INJECTION_POINT_CANNOT_USE_NAMED, ij);
        }
        boolean bl = newBean = ij.getBean() instanceof NewManagedBean || ij.getBean() instanceof NewSessionBean;
        if (!newBean) {
            this.checkScopeAnnotations(ij, (MetaAnnotationStore)beanManager.getServices().get(MetaAnnotationStore.class));
        }
        Validator.checkFacadeInjectionPoint(ij, Instance.class);
        Validator.checkFacadeInjectionPoint(ij, Event.class);
        Annotation[] bindings = ij.getQualifiers().toArray(new Annotation[0]);
        Set resolvedBeans = beanManager.getBeanResolver().resolve(beanManager.getBeans(ij));
        if (!Validator.isInjectionPointSatisfied(ij, resolvedBeans, beanManager)) {
            throw new DeploymentException(ValidatorMessage.INJECTION_POINT_HAS_UNSATISFIED_DEPENDENCIES, ij, Formats.formatAnnotations(bindings), Formats.formatType(ij.getType()));
        }
        if (resolvedBeans.size() > 1 && !ij.isDelegate()) {
            throw new DeploymentException(ValidatorMessage.INJECTION_POINT_HAS_AMBIGUOUS_DEPENDENCIES, ij, Formats.formatAnnotations(bindings), Formats.formatType(ij.getType()), resolvedBeans);
        }
        if (!resolvedBeans.isEmpty()) {
            Bean resolvedBean = resolvedBeans.iterator().next();
            if (((MetaAnnotationStore)beanManager.getServices().get(MetaAnnotationStore.class)).getScopeModel(resolvedBean.getScope()).isNormal() && !Proxies.isTypeProxyable(ij.getType())) {
                throw new UnproxyableResolutionException(ValidatorMessage.INJECTION_POINT_HAS_NON_PROXYABLE_DEPENDENCIES, ij);
            }
            if (Reflections.isPrimitive(ij.getType()) && resolvedBean.isNullable()) {
                throw new NullableDependencyException(ValidatorMessage.INJECTION_POINT_HAS_NULLABLE_DEPENDENCIES, ij);
            }
            if (ij.getBean() != null && Beans.isPassivatingScope(ij.getBean(), beanManager) && !ij.isTransient() && !Beans.isPassivationCapableBean(resolvedBean)) {
                this.validateInjectionPointPassivationCapable(ij, resolvedBean, beanManager);
            }
        }
    }

    public void validateInjectionTarget(InjectionTarget<?> injectionTarget, BeanManagerImpl beanManager) {
        for (InjectionPoint injectionPoint : injectionTarget.getInjectionPoints()) {
            this.validateInjectionPoint(injectionPoint, beanManager);
        }
    }

    private void checkScopeAnnotations(InjectionPoint ij, MetaAnnotationStore metaAnnotationStore) {
        for (Annotation annotation : ij.getAnnotated().getAnnotations()) {
            if (!this.hasScopeMetaAnnotation(annotation)) continue;
            log.warn((Enum)ValidatorMessage.SCOPE_ANNOTATION_ON_INJECTION_POINT, new Object[]{annotation, ij});
        }
    }

    private boolean hasScopeMetaAnnotation(Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        return annotationType.isAnnotationPresent(Scope.class) || annotationType.isAnnotationPresent(NormalScope.class);
    }

    public void validateInjectionPointPassivationCapable(InjectionPoint ij, Bean<?> resolvedBean, BeanManagerImpl beanManager) {
        if (!ij.isTransient() && !Beans.isPassivationCapableDependency(resolvedBean)) {
            if (resolvedBean.getScope().equals(Dependent.class) && resolvedBean instanceof AbstractProducerBean) {
                throw new IllegalProductException(ValidatorMessage.NON_SERIALIZABLE_BEAN_INJECTED_INTO_PASSIVATING_BEAN, ij.getBean(), resolvedBean);
            }
            throw new UnserializableDependencyException(ValidatorMessage.INJECTION_POINT_HAS_NON_SERIALIZABLE_DEPENDENCY, ij.getBean(), resolvedBean);
        }
    }

    public void validateDeployment(BeanManagerImpl manager, BeanDeployerEnvironment environment) {
        this.validateDecorators(manager.getDecorators(), new ArrayList(), manager);
        this.validateInterceptors(manager.getInterceptors());
        this.validateBeans(manager.getBeans(), new ArrayList(), manager);
        this.validateEnabledDecoratorClasses(manager);
        this.validateEnabledInterceptorClasses(manager);
        this.validateEnabledAlternatives(manager);
        this.validateDisposalMethods(environment);
        this.validateObserverMethods(environment.getObservers(), manager);
        this.validateBeanNames(manager);
    }

    public void validateBeans(Collection<? extends Bean<?>> beans, Collection<RIBean<?>> specializedBeans, BeanManagerImpl manager) {
        for (Bean<?> bean : beans) {
            if (bean instanceof RIBean) {
                this.validateRIBean((RIBean)bean, manager, specializedBeans);
                continue;
            }
            this.validateBean(bean, manager);
        }
    }

    public void validateInterceptors(Collection<? extends Interceptor<?>> interceptors) {
        for (Interceptor<?> interceptor : interceptors) {
            if (!(interceptor instanceof InterceptorImpl)) continue;
            if (!((InterceptorImpl)interceptor).getWeldAnnotated().getWeldMethods(Produces.class).isEmpty()) {
                throw new DefinitionException(ValidatorMessage.INTERCEPTORS_CANNOT_HAVE_PRODUCER_METHODS, interceptor);
            }
            if (!((InterceptorImpl)interceptor).getWeldAnnotated().getWeldFields(Produces.class).isEmpty()) {
                throw new DefinitionException(ValidatorMessage.INTERCEPTORS_CANNOT_HAVE_PRODUCER_FIELDS, interceptor);
            }
            if (((InterceptorImpl)interceptor).getWeldAnnotated().getDeclaredWeldMethodsWithAnnotatedParameters(Disposes.class).isEmpty()) continue;
            throw new DefinitionException(ValidatorMessage.INTERCEPTORS_CANNOT_HAVE_DISPOSER_METHODS, interceptor);
        }
    }

    public void validateDecorators(Collection<? extends Decorator<?>> beans, Collection<RIBean<?>> specializedBeans, BeanManagerImpl manager) {
        for (Decorator<?> bean : beans) {
            if (bean instanceof RIBean) {
                this.validateRIBean((RIBean)bean, manager, specializedBeans);
                if (!(bean instanceof WeldDecorator)) continue;
                if (!((WeldDecorator)bean).getWeldAnnotated().getWeldMethods(Produces.class).isEmpty()) {
                    throw new DefinitionException(ValidatorMessage.DECORATORS_CANNOT_HAVE_PRODUCER_METHODS, bean);
                }
                if (!((WeldDecorator)bean).getWeldAnnotated().getWeldFields(Produces.class).isEmpty()) {
                    throw new DefinitionException(ValidatorMessage.DECORATORS_CANNOT_HAVE_PRODUCER_FIELDS, bean);
                }
                if (((WeldDecorator)bean).getWeldAnnotated().getDeclaredWeldMethodsWithAnnotatedParameters(Disposes.class).isEmpty()) continue;
                throw new DefinitionException(ValidatorMessage.DECORATORS_CANNOT_HAVE_DISPOSER_METHODS, bean);
            }
            this.validateBean((Bean<?>)bean, manager);
        }
    }

    public void validateBeanNames(BeanManagerImpl beanManager) {
        SetMultimap namedAccessibleBeans = Multimaps.newSetMultimap(new HashMap(), (Supplier)new Supplier<Set<Bean<?>>>(){

            public Set<Bean<?>> get() {
                return new HashSet();
            }
        });
        for (Bean<?> bean : beanManager.getAccessibleBeans()) {
            if (bean.getName() == null) continue;
            namedAccessibleBeans.put((Object)bean.getName(), bean);
        }
        ArrayList<String> accessibleNamespaces = new ArrayList<String>();
        for (String namespace : beanManager.getAccessibleNamespaces()) {
            accessibleNamespaces.add(namespace);
        }
        for (String name : namedAccessibleBeans.keySet()) {
            Set resolvedBeans = beanManager.getBeanResolver().resolve(Beans.removeDisabledAndSpecializedBeans(namedAccessibleBeans.get((Object)name), beanManager));
            if (resolvedBeans.size() > 1) {
                throw new DeploymentException(ValidatorMessage.AMBIGUOUS_EL_NAME, name, resolvedBeans);
            }
            if (!accessibleNamespaces.contains(name)) continue;
            throw new DeploymentException(ValidatorMessage.BEAN_NAME_IS_PREFIX, name);
        }
    }

    private void validateEnabledInterceptorClasses(BeanManagerImpl beanManager) {
        HashSet<Class> interceptorBeanClasses = new HashSet<Class>();
        for (Interceptor<?> interceptor : beanManager.getAccessibleInterceptors()) {
            interceptorBeanClasses.add(interceptor.getBeanClass());
        }
        for (Metadata metadata : beanManager.getEnabled().getInterceptors()) {
            if (interceptorBeanClasses.contains(metadata.getValue())) continue;
            throw new DeploymentException(ValidatorMessage.INTERCEPTOR_NOT_ANNOTATED_OR_REGISTERED, metadata);
        }
    }

    private void validateEnabledDecoratorClasses(BeanManagerImpl beanManager) {
        HashSet<Class> decoratorBeanClasses = new HashSet<Class>();
        for (Decorator<?> decorator : beanManager.getAccessibleDecorators()) {
            decoratorBeanClasses.add(decorator.getBeanClass());
        }
        for (Metadata metadata : beanManager.getEnabled().getDecorators()) {
            if (decoratorBeanClasses.contains(metadata.getValue())) continue;
            throw new DeploymentException(ValidatorMessage.DECORATOR_CLASS_NOT_BEAN_CLASS_OF_DECORATOR, metadata, decoratorBeanClasses);
        }
    }

    private void validateEnabledAlternatives(BeanManagerImpl beanManager) {
        for (Metadata<Class<? extends Annotation>> metadata : beanManager.getEnabled().getAlternativeStereotypes()) {
            if (!beanManager.isStereotype((Class)metadata.getValue())) {
                throw new DeploymentException(ValidatorMessage.ALTERNATIVE_STEREOTYPE_NOT_STEREOTYPE, metadata);
            }
            if (Validator.isAlternative((BeanManager)beanManager, (Class)metadata.getValue())) continue;
            throw new DeploymentException(ValidatorMessage.ALTERNATIVE_STEREOTYPE_NOT_ANNOTATED, metadata);
        }
        for (Metadata metadata : beanManager.getEnabled().getAlternativeClasses()) {
            if (((Class)metadata.getValue()).isAnnotation() || ((Class)metadata.getValue()).isInterface()) {
                throw new DeploymentException(ValidatorMessage.ALTERNATIVE_BEAN_CLASS_NOT_CLASS, metadata);
            }
            WeldClass weldClass = ((ClassTransformer)Container.instance().services().get(ClassTransformer.class)).loadClass((Class)metadata.getValue());
            if (weldClass.isAnnotationPresent(Alternative.class)) continue;
            throw new DeploymentException(ValidatorMessage.ALTERNATIVE_BEAN_CLASS_NOT_ANNOTATED, metadata);
        }
    }

    private static boolean isAlternative(BeanManager beanManager, Class<? extends Annotation> stereotype) {
        for (Annotation annotation : beanManager.getStereotypeDefinition(stereotype)) {
            if (!annotation.annotationType().equals(Alternative.class)) continue;
            return true;
        }
        return false;
    }

    private void validateDisposalMethods(BeanDeployerEnvironment environment) {
        Set<DisposalMethod<?, ?>> beans = environment.getUnresolvedDisposalBeans();
        if (!beans.isEmpty()) {
            throw new DefinitionException(ValidatorMessage.DISPOSAL_METHODS_WITHOUT_PRODUCER, beans);
        }
    }

    private void validateObserverMethods(Iterable<ObserverMethodImpl<?, ?>> observers, BeanManagerImpl beanManager) {
        for (ObserverMethodImpl<?, ?> omi : observers) {
            for (WeldInjectionPoint<?, ?> ip : omi.getInjectionPoints()) {
                this.validateInjectionPoint(ip, beanManager);
            }
        }
    }

    private static void checkFacadeInjectionPoint(InjectionPoint injectionPoint, Class<?> type) {
        if (injectionPoint.getAnnotated().getBaseType().equals(type)) {
            if (injectionPoint.getType() instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)injectionPoint.getType();
                if (parameterizedType.getActualTypeArguments()[0] instanceof TypeVariable) {
                    throw new DefinitionException(ValidatorMessage.INJECTION_POINT_WITH_TYPE_VARIABLE, injectionPoint);
                }
                if (parameterizedType.getActualTypeArguments()[0] instanceof WildcardType) {
                    throw new DefinitionException(ValidatorMessage.INJECTION_POINT_HAS_WILDCARD, type, injectionPoint);
                }
            } else {
                throw new DefinitionException(ValidatorMessage.INJECTION_POINT_MUST_HAVE_TYPE_PARAMETER, type, injectionPoint);
            }
        }
    }

    private static boolean isInjectionPointSatisfied(InjectionPoint ij, Set<?> resolvedBeans, BeanManagerImpl beanManager) {
        if (ij.getBean() instanceof Decorator) {
            if (beanManager.getEnabled().getDecorator(ij.getBean().getBeanClass()) != null) {
                return resolvedBeans.size() > 0;
            }
            return true;
        }
        return resolvedBeans.size() > 0;
    }

    private static void validatePseudoScopedBean(Bean<?> bean, BeanManagerImpl beanManager) {
        Validator.reallyValidatePseudoScopedBean(bean, beanManager, new LinkedHashSet(), new HashSet());
    }

    private static void reallyValidatePseudoScopedBean(Bean<?> bean, BeanManagerImpl beanManager, Set<Bean<?>> dependencyPath, Set<Bean<?>> validatedBeans) {
        if (dependencyPath.contains(bean)) {
            ArrayList realDepdencyPath = new ArrayList(dependencyPath);
            realDepdencyPath.add(bean);
            throw new DeploymentException(ValidatorMessage.PSEUDO_SCOPED_BEAN_HAS_CIRCULAR_REFERENCES, realDepdencyPath);
        }
        if (validatedBeans.contains(bean)) {
            return;
        }
        dependencyPath.add(bean);
        for (InjectionPoint injectionPoint : bean.getInjectionPoints()) {
            Validator.validatePseudoScopedInjectionPoint(injectionPoint, beanManager, dependencyPath, validatedBeans);
        }
        validatedBeans.add(bean);
        dependencyPath.remove(bean);
    }

    private static void validatePseudoScopedInjectionPoint(InjectionPoint ij, BeanManagerImpl beanManager, Set<Bean<?>> dependencyPath, Set<Bean<?>> validatedBeans) {
        Set resolved = beanManager.getBeans(ij);
        try {
            boolean normalScoped;
            Bean bean = beanManager.resolve(resolved);
            if (bean != null && !(bean instanceof AbstractBuiltInBean) && !(normalScoped = ((MetaAnnotationStore)beanManager.getServices().get(MetaAnnotationStore.class)).getScopeModel(bean.getScope()).isNormal())) {
                Validator.reallyValidatePseudoScopedBean(bean, beanManager, dependencyPath, validatedBeans);
            }
        }
        catch (AmbiguousResolutionException e) {
            // empty catch block
        }
    }

    public void cleanup() {
    }
}

