/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context.beanstore;

import java.util.Collection;
import java.util.Iterator;
import org.jboss.weld.context.api.ContextualInstance;
import org.jboss.weld.context.beanstore.BoundBeanStore;
import org.jboss.weld.context.beanstore.HashMapBeanStore;
import org.jboss.weld.context.beanstore.LockStore;
import org.jboss.weld.context.beanstore.LockedBean;
import org.jboss.weld.context.beanstore.NamingScheme;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.ContextMessage;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AttributeBeanStore
implements BoundBeanStore {
    private static final long serialVersionUID = 8923580660774253916L;
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.CONTEXT);
    private final HashMapBeanStore beanStore;
    private final NamingScheme namingScheme;
    private boolean attached;

    public AttributeBeanStore(NamingScheme namingScheme) {
        this.namingScheme = namingScheme;
        this.beanStore = new HashMapBeanStore();
    }

    @Override
    public boolean detach() {
        if (this.attached) {
            this.attached = false;
            log.trace("Bean store " + this + " is detached");
            return true;
        }
        return false;
    }

    @Override
    public boolean attach() {
        if (!this.attached) {
            this.attached = true;
            for (String id : this.beanStore) {
                ContextualInstance instance = this.beanStore.get(id);
                String prefixedId = this.getNamingScheme().prefix(id);
                log.trace("Updating underlying store with contextual " + instance + " under ID " + id);
                this.setAttribute(prefixedId, instance);
            }
            for (String prefixedId : this.getPrefixedAttributeNames()) {
                String id = this.getNamingScheme().deprefix(prefixedId);
                if (this.beanStore.contains(id)) continue;
                ContextualInstance instance = (ContextualInstance)this.getAttribute(prefixedId);
                this.beanStore.put(id, instance);
                log.trace("Adding detached contextual " + instance + " under ID " + id);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isAttached() {
        return this.attached;
    }

    @Override
    public <T> ContextualInstance<T> get(String id) {
        ContextualInstance instance = this.beanStore.get(id);
        log.trace((Enum)ContextMessage.CONTEXTUAL_INSTANCE_FOUND, new Object[]{id, instance, this});
        return instance;
    }

    @Override
    public <T> void put(String id, ContextualInstance<T> instance) {
        this.beanStore.put(id, instance);
        if (this.isAttached()) {
            String prefixedId = this.namingScheme.prefix(id);
            this.setAttribute(prefixedId, instance);
        }
        log.trace((Enum)ContextMessage.CONTEXTUAL_INSTANCE_ADDED, new Object[]{instance.getContextual(), id, this});
    }

    @Override
    public void clear() {
        Iterator<String> it = this.iterator();
        while (it.hasNext()) {
            String id = it.next();
            if (this.isAttached()) {
                String prefixedId = this.namingScheme.prefix(id);
                this.removeAttribute(prefixedId);
            }
            it.remove();
            log.trace((Enum)ContextMessage.CONTEXTUAL_INSTANCE_REMOVED, new Object[]{id, this});
        }
        log.trace((Enum)ContextMessage.CONTEXT_CLEARED, new Object[]{this});
    }

    @Override
    public boolean contains(String id) {
        return this.get(id) != null;
    }

    protected NamingScheme getNamingScheme() {
        return this.namingScheme;
    }

    @Override
    public Iterator<String> iterator() {
        return this.beanStore.iterator();
    }

    protected abstract Object getAttribute(String var1);

    protected abstract void removeAttribute(String var1);

    protected abstract Collection<String> getAttributeNames();

    protected Collection<String> getPrefixedAttributeNames() {
        return this.getNamingScheme().filterIds(this.getAttributeNames());
    }

    protected abstract void setAttribute(String var1, Object var2);

    @Override
    public LockedBean lock(String id) {
        LockStore lockStore = this.getLockStore();
        if (lockStore == null) {
            return null;
        }
        return lockStore.lock(id);
    }

    protected abstract LockStore getLockStore();
}

