/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context.http;

import java.lang.annotation.Annotation;
import javax.enterprise.context.RequestScoped;
import javax.servlet.ServletRequest;
import org.jboss.weld.context.AbstractBoundContext;
import org.jboss.weld.context.beanstore.NamingScheme;
import org.jboss.weld.context.beanstore.SimpleNamingScheme;
import org.jboss.weld.context.beanstore.http.RequestBeanStore;
import org.jboss.weld.context.cache.RequestScopedBeanCache;
import org.jboss.weld.context.http.HttpRequestContext;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.ContextMessage;
import org.slf4j.cal10n.LocLogger;

public class HttpRequestContextImpl
extends AbstractBoundContext<ServletRequest>
implements HttpRequestContext {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.CONTEXT);
    private final NamingScheme namingScheme = new SimpleNamingScheme(HttpRequestContext.class.getName());

    public HttpRequestContextImpl() {
        super(false);
    }

    public boolean associate(ServletRequest request) {
        if (this.getBeanStore() != null) {
            log.warn((Enum)ContextMessage.BEAN_STORE_LEAK_DURING_ASSOCIATION, new Object[]{this.getClass().getName(), request});
        }
        this.setBeanStore(new RequestBeanStore(request, this.namingScheme));
        this.getBeanStore().attach();
        return true;
    }

    @Override
    public void activate() {
        super.activate();
        RequestScopedBeanCache.beginRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deactivate() {
        try {
            RequestScopedBeanCache.endRequest();
        }
        finally {
            super.deactivate();
        }
    }

    public Class<? extends Annotation> getScope() {
        return RequestScoped.class;
    }
}

