/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.weld.ContainerState;
import org.jboss.weld.bootstrap.BeanDeployment;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.Singleton;
import org.jboss.weld.bootstrap.api.SingletonProvider;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.MessageConveyorFactory;
import org.jboss.weld.logging.messages.BeanManagerMessage;
import org.jboss.weld.manager.BeanManagerImpl;

public class Container {
    public static final String CONTEXT_ID_KEY = "WELD_CONTEXT_ID_KEY";
    public static final ThreadLocal<String> currentId = new ThreadLocal();
    private static Singleton<Container> instance = SingletonProvider.instance().create(Container.class);
    private final String contextId;
    private final BeanManagerImpl deploymentManager;
    private final Map<String, BeanManagerImpl> managers;
    private final Map<BeanDeploymentArchive, BeanManagerImpl> beanDeploymentArchives;
    private final ServiceRegistry deploymentServices;
    private ContainerState state = ContainerState.STOPPED;

    public static Container instance() {
        return Container.instance("STATIC_INSTANCE");
    }

    public static boolean available() {
        return Container.available("STATIC_INSTANCE");
    }

    public static Container instance(String contextId) {
        return (Container)instance.get(contextId);
    }

    public static boolean available(String contextId) {
        return instance.isSet(contextId) && Container.instance(contextId) != null && Container.instance(contextId).getState().isAvailable();
    }

    public static void initialize(BeanManagerImpl deploymentManager, ServiceRegistry deploymentServices) {
        Container.initialize("STATIC_INSTANCE", deploymentManager, deploymentServices);
    }

    public static void initialize(String contextId, BeanManagerImpl deploymentManager, ServiceRegistry deploymentServices) {
        Container instance = new Container(contextId, deploymentManager, deploymentServices);
        Container.instance.set(contextId, (Object)instance);
    }

    public Container(String contextId, BeanManagerImpl deploymentManager, ServiceRegistry deploymentServices) {
        this.deploymentManager = deploymentManager;
        this.managers = new ConcurrentHashMap<String, BeanManagerImpl>();
        this.managers.put(deploymentManager.getId(), deploymentManager);
        this.beanDeploymentArchives = new ConcurrentHashMap<BeanDeploymentArchive, BeanManagerImpl>();
        this.deploymentServices = deploymentServices;
        this.contextId = contextId;
    }

    public Container(BeanManagerImpl deploymentManager, ServiceRegistry deploymentServices) {
        this("STATIC_INSTANCE", deploymentManager, deploymentServices);
    }

    public void cleanup() {
        this.managers.clear();
        for (BeanManagerImpl beanManager : this.beanDeploymentArchives.values()) {
            beanManager.cleanup();
        }
        this.beanDeploymentArchives.clear();
        this.deploymentServices.cleanup();
        this.deploymentManager.cleanup();
        LoggerFactory.cleanup();
        MessageConveyorFactory.cleanup();
        instance.clear(this.contextId);
    }

    public BeanManagerImpl deploymentManager() {
        return this.deploymentManager;
    }

    public Map<BeanDeploymentArchive, BeanManagerImpl> beanDeploymentArchives() {
        return this.beanDeploymentArchives;
    }

    public BeanManagerImpl activityManager(String key) {
        return this.managers.get(key);
    }

    public String addActivity(BeanManagerImpl manager) {
        String id = manager.getId();
        if (manager.getId() == null) {
            throw new IllegalArgumentException(BeanManagerMessage.NULL_BEAN_MANAGER_ID, manager);
        }
        this.managers.put(id, manager);
        return id;
    }

    public ServiceRegistry services() {
        return this.deploymentServices;
    }

    public void putBeanDeployments(Map<BeanDeploymentArchive, BeanDeployment> beanDeployments) {
        for (Map.Entry<BeanDeploymentArchive, BeanDeployment> entry : beanDeployments.entrySet()) {
            this.beanDeploymentArchives.put(entry.getKey(), entry.getValue().getBeanManager());
            this.addActivity(entry.getValue().getBeanManager());
        }
    }

    public ContainerState getState() {
        return this.state;
    }

    public void setState(ContainerState state) {
        this.state = state;
    }
}

