/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.jsf;

import java.lang.annotation.Annotation;
import java.util.Map;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.Instance;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.jboss.weld.Container;
import org.jboss.weld.context.ConversationContext;
import org.jboss.weld.context.http.HttpConversationContext;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.ConversationMessage;
import org.jboss.weld.logging.messages.JsfMessage;
import org.slf4j.cal10n.LocLogger;

public class WeldPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 1L;
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.JSF);
    private String contextId;
    public static final String NO_CID = "nocid";
    private static final String CONTEXT_ACTIVATED_IN_REQUEST = WeldPhaseListener.class.getName() + "CONTEXT_ACTIVATED_IN_REQUEST";

    public void beforePhase(PhaseEvent phaseEvent) {
        if (phaseEvent.getPhaseId().equals(PhaseId.RESTORE_VIEW)) {
            this.activateConversations(phaseEvent.getFacesContext());
        }
    }

    public void afterPhase(PhaseEvent phaseEvent) {
        if (phaseEvent.getPhaseId().equals(PhaseId.RENDER_RESPONSE)) {
            this.deactivateConversations(phaseEvent.getFacesContext(), PhaseId.RENDER_RESPONSE);
        } else if (phaseEvent.getFacesContext().getResponseComplete()) {
            this.deactivateConversations(phaseEvent.getFacesContext(), phaseEvent.getPhaseId());
        }
    }

    private void activateConversations(FacesContext facesContext) {
        if (this.contextId == null) {
            this.contextId = WeldPhaseListener.getServletContext(facesContext).getInitParameter("WELD_CONTEXT_ID_KEY");
        }
        if (this.contextId == null) {
            this.contextId = "STATIC_INSTANCE";
        }
        HttpConversationContext conversationContext = (HttpConversationContext)this.instance(this.contextId).select(HttpConversationContext.class, new Annotation[0]).get();
        String cid = this.getConversationId(facesContext, (ConversationContext)conversationContext);
        log.debug((Enum)JsfMessage.RESUMING_CONVERSATION, new Object[]{cid});
        if (!this.isContextActivatedInRequest(facesContext)) {
            this.setContextActivatedInRequest(facesContext);
            conversationContext.activate(cid);
        } else {
            HttpServletRequest request = (HttpServletRequest)facesContext.getExternalContext().getRequest();
            conversationContext.dissociate((Object)request);
            conversationContext.associate((Object)request);
            conversationContext.activate(cid);
        }
    }

    private void setContextActivatedInRequest(FacesContext facesContext) {
        facesContext.getExternalContext().getRequestMap().put(CONTEXT_ACTIVATED_IN_REQUEST, true);
    }

    private boolean isContextActivatedInRequest(FacesContext facesContext) {
        Object result = facesContext.getExternalContext().getRequestMap().get(CONTEXT_ACTIVATED_IN_REQUEST);
        if (result == null) {
            return false;
        }
        return (Boolean)result;
    }

    private void deactivateConversations(FacesContext facesContext, PhaseId phaseId) {
        if (this.contextId == null) {
            this.contextId = WeldPhaseListener.getServletContext(facesContext).getInitParameter("WELD_CONTEXT_ID_KEY");
        }
        if (this.contextId == null) {
            this.contextId = "STATIC_INSTANCE";
        }
        ConversationContext conversationContext = (ConversationContext)this.instance(this.contextId).select(HttpConversationContext.class, new Annotation[0]).get();
        if (log.isTraceEnabled()) {
            if (conversationContext.getCurrentConversation().isTransient()) {
                log.trace((Enum)ConversationMessage.CLEANING_UP_TRANSIENT_CONVERSATION, new Object[]{phaseId});
            } else {
                log.trace((Enum)JsfMessage.CLEANING_UP_CONVERSATION, new Object[]{conversationContext.getCurrentConversation().getId(), phaseId});
            }
        }
        conversationContext.invalidate();
        if (conversationContext.isActive()) {
            conversationContext.deactivate();
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    private Instance<Context> instance(String id) {
        return Container.instance(id).deploymentManager().instance().select(Context.class, new Annotation[0]);
    }

    public String getConversationId(FacesContext facesContext, ConversationContext conversationContext) {
        Map map = facesContext.getExternalContext().getRequestParameterMap();
        if (map.containsKey(NO_CID)) {
            return null;
        }
        String cidName = conversationContext.getParameterName();
        String cid = (String)map.get(cidName);
        log.trace((Enum)JsfMessage.FOUND_CONVERSATION_FROM_REQUEST, new Object[]{cid});
        return cid;
    }

    public static ServletContext getServletContext(FacesContext context) {
        return (ServletContext)context.getExternalContext().getContext();
    }
}

