/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection;

import javax.enterprise.context.spi.CreationalContext;
import org.jboss.weld.context.WeldCreationalContext;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.injection.FieldInjectionPoint;
import org.jboss.weld.injection.attributes.FieldInjectionPointAttributes;
import org.jboss.weld.injection.spi.EjbInjectionServices;
import org.jboss.weld.injection.spi.JaxwsInjectionServices;
import org.jboss.weld.injection.spi.JpaInjectionServices;
import org.jboss.weld.injection.spi.ResourceInjectionServices;
import org.jboss.weld.injection.spi.ResourceReference;
import org.jboss.weld.injection.spi.ResourceReferenceFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.persistence.PersistenceApiAbstraction;
import org.jboss.weld.util.DelegatingFieldInjectionPointAttributes;
import org.jboss.weld.util.reflection.Reflections;

public class ResourceInjectionPoint<T, X>
extends DelegatingFieldInjectionPointAttributes<T, X> {
    private final FieldInjectionPoint<T, X> delegate;
    private final ResourceReferenceFactory<T> factory;

    public static <T, X> ResourceInjectionPoint<T, X> forEjb(FieldInjectionPoint<T, X> delegate, EjbInjectionServices injectionServices) {
        return new ResourceInjectionPoint<T, X>(delegate, (ResourceReferenceFactory)Reflections.cast(injectionServices.registerEjbInjectionPoint(delegate)));
    }

    public static <T, X> ResourceInjectionPoint<T, X> forPersistenceContext(FieldInjectionPoint<T, X> delegate, JpaInjectionServices injectionServices, PersistenceApiAbstraction api) {
        if (!delegate.getType().equals(api.ENTITY_MANAGER_CLASS)) {
            throw new DefinitionException(BeanMessage.INVALID_RESOURCE_PRODUCER_TYPE, delegate.getAnnotated(), api.ENTITY_MANAGER_CLASS);
        }
        return new ResourceInjectionPoint<T, X>(delegate, (ResourceReferenceFactory)Reflections.cast(injectionServices.registerPersistenceContextInjectionPoint(delegate)));
    }

    public static <T, X> ResourceInjectionPoint<T, X> forPersistenceUnit(FieldInjectionPoint<T, X> delegate, JpaInjectionServices injectionServices, PersistenceApiAbstraction api) {
        if (!delegate.getType().equals(api.ENTITY_MANAGER_FACTORY_CLASS)) {
            throw new DefinitionException(BeanMessage.INVALID_RESOURCE_PRODUCER_TYPE, delegate.getAnnotated(), api.ENTITY_MANAGER_FACTORY_CLASS);
        }
        return new ResourceInjectionPoint<T, X>(delegate, (ResourceReferenceFactory)Reflections.cast(injectionServices.registerPersistenceUnitInjectionPoint(delegate)));
    }

    public static <T, X> ResourceInjectionPoint<T, X> forResource(FieldInjectionPoint<T, X> delegate, ResourceInjectionServices injectionServices) {
        return new ResourceInjectionPoint<T, X>(delegate, (ResourceReferenceFactory)Reflections.cast(injectionServices.registerResourceInjectionPoint(delegate)));
    }

    public static <T, X> ResourceInjectionPoint<T, X> forWebServiceRef(FieldInjectionPoint<T, X> delegate, JaxwsInjectionServices injectionServices) {
        return new ResourceInjectionPoint<T, X>(delegate, (ResourceReferenceFactory)Reflections.cast(injectionServices.registerWebServiceRefInjectionPoint(delegate)));
    }

    private ResourceInjectionPoint(FieldInjectionPoint<T, X> delegate, ResourceReferenceFactory<T> factory) {
        this.delegate = delegate;
        this.factory = factory;
    }

    public T getReference(CreationalContext<?> ctx) {
        ResourceReference reference = this.factory.createResource();
        if (ctx instanceof WeldCreationalContext) {
            ((WeldCreationalContext)Reflections.cast(ctx)).addDependentResourceReference(reference);
        }
        return (T)reference.getInstance();
    }

    public void inject(Object declaringInstance, CreationalContext<?> ctx) {
        this.delegate.inject(declaringInstance, this.getReference(ctx));
    }

    @Override
    protected FieldInjectionPointAttributes<T, X> delegate() {
        return this.delegate.delegate();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.delegate == null ? 0 : this.delegate.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceInjectionPoint other = (ResourceInjectionPoint)obj;
        return !(this.delegate == null ? other.delegate != null : !this.delegate.equals(other.delegate));
    }
}

