/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.builtin;

import java.io.ObjectStreamException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.weld.Container;
import org.jboss.weld.ContainerState;
import org.jboss.weld.SystemPropertiesConfiguration;
import org.jboss.weld.bootstrap.spi.BootstrapConfiguration;
import org.jboss.weld.logging.BeanManagerLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.ForwardingBeanManager;
import org.jboss.weld.util.reflection.Reflections;

public class BeanManagerProxy
extends ForwardingBeanManager {
    private static final String GET_BEANS_METHOD_NAME = "getBeans()";
    private static final long serialVersionUID = -6990849486568169846L;
    private final BeanManagerImpl manager;
    private volatile transient Container container;
    private final boolean nonPortableMode;

    public BeanManagerProxy(BeanManagerImpl manager) {
        this.manager = manager;
        this.nonPortableMode = SystemPropertiesConfiguration.INSTANCE.isNonPortableModeEnabled() ? true : ((BootstrapConfiguration)manager.getServices().get(BootstrapConfiguration.class)).isNonPortableModeEnabled();
    }

    public BeanManagerImpl delegate() {
        return this.manager;
    }

    @Override
    public Object getReference(Bean<?> bean, Type beanType, CreationalContext<?> ctx) {
        this.checkContainerValidated("getReference()");
        return super.getReference(bean, beanType, ctx);
    }

    @Override
    public Object getInjectableReference(InjectionPoint ij, CreationalContext<?> ctx) {
        this.checkContainerValidated("getInjectableReference()");
        return super.getInjectableReference(ij, ctx);
    }

    @Override
    public Set<Bean<?>> getBeans(Type beanType, Annotation ... qualifiers) {
        this.checkContainerValidated(GET_BEANS_METHOD_NAME);
        return super.getBeans(beanType, qualifiers);
    }

    @Override
    public Set<Bean<?>> getBeans(String name) {
        this.checkContainerValidated(GET_BEANS_METHOD_NAME);
        return super.getBeans(name);
    }

    @Override
    public Bean<?> getPassivationCapableBean(String id) {
        this.checkContainerValidated("getPassivationCapableBean()");
        return super.getPassivationCapableBean(id);
    }

    @Override
    public <X> Bean<? extends X> resolve(Set<Bean<? extends X>> beans) {
        this.checkContainerValidated("resolve()");
        return super.resolve(beans);
    }

    @Override
    public void validate(InjectionPoint injectionPoint) {
        this.checkContainerValidated("validate()");
        super.validate(injectionPoint);
    }

    @Override
    public <T> Set<ObserverMethod<? super T>> resolveObserverMethods(T event, Annotation ... qualifiers) {
        this.checkContainerValidated("resolveObserverMethods()");
        return super.resolveObserverMethods(event, qualifiers);
    }

    @Override
    public List<Decorator<?>> resolveDecorators(Set<Type> types, Annotation ... qualifiers) {
        this.checkContainerValidated("resolveDecorators()");
        return super.resolveDecorators(types, qualifiers);
    }

    @Override
    public List<Interceptor<?>> resolveInterceptors(InterceptionType type, Annotation ... interceptorBindings) {
        this.checkContainerValidated("resolveInterceptors()");
        return super.resolveInterceptors(type, interceptorBindings);
    }

    protected Object readResolve() throws ObjectStreamException {
        return new BeanManagerProxy(this.manager);
    }

    private void checkContainerValidated(String methodName) {
        ContainerState state;
        if (this.nonPortableMode) {
            return;
        }
        if (this.container == null) {
            this.container = Container.instance(this.manager);
        }
        if (ContainerState.SHUTDOWN.equals((Object)(state = this.container.getState()))) {
            throw BeanManagerLogger.LOG.methodNotAvailableAfterShutdown(methodName);
        }
        if (!ContainerState.INITIALIZED.equals((Object)state) && !ContainerState.VALIDATED.equals((Object)state)) {
            throw BeanManagerLogger.LOG.methodNotAvailableDuringInitialization(methodName);
        }
    }

    public static BeanManagerImpl unwrap(BeanManager manager) {
        if (manager instanceof ForwardingBeanManager) {
            manager = ((ForwardingBeanManager)Reflections.cast(manager)).delegate();
        }
        if (manager instanceof BeanManagerImpl) {
            return (BeanManagerImpl)manager;
        }
        throw new IllegalArgumentException("Unknown BeanManager " + manager);
    }
}

