/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.builtin;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.context.spi.AlterableContext;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.util.TypeLiteral;
import org.jboss.weld.bean.builtin.AbstractFacade;
import org.jboss.weld.bean.builtin.DynamicLookupInjectionPoint;
import org.jboss.weld.bean.builtin.FacadeInjectionPoint;
import org.jboss.weld.bean.proxy.ProxyMethodHandler;
import org.jboss.weld.bean.proxy.ProxyObject;
import org.jboss.weld.context.WeldCreationalContext;
import org.jboss.weld.exceptions.InvalidObjectException;
import org.jboss.weld.injection.CurrentInjectionPoint;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.resolution.ResolvableBuilder;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;

@SuppressWarnings(value={"SE_NO_SUITABLE_CONSTRUCTOR", "SE_BAD_FIELD"}, justification="Uses SerializationProxy")
public class InstanceImpl<T>
extends AbstractFacade<T, Instance<T>>
implements Instance<T>,
Serializable {
    private static final long serialVersionUID = -376721889693284887L;

    public static <I> Instance<I> of(InjectionPoint injectionPoint, CreationalContext<I> creationalContext, BeanManagerImpl beanManager) {
        return new InstanceImpl<I>(injectionPoint, creationalContext, beanManager);
    }

    private InstanceImpl(InjectionPoint injectionPoint, CreationalContext<? super T> creationalContext, BeanManagerImpl beanManager) {
        super(injectionPoint, creationalContext, beanManager);
    }

    public T get() {
        Resolvable resolvable = new ResolvableBuilder(this.getType(), this.getBeanManager()).addQualifiers(this.getQualifiers()).setDeclaringBean(this.getInjectionPoint().getBean()).create();
        Bean bean = this.getBeanManager().getBean(resolvable);
        return this.getBeanInstance(bean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T getBeanInstance(Bean<?> bean) {
        DynamicLookupInjectionPoint ip = new DynamicLookupInjectionPoint(this.getInjectionPoint(), this.getType(), this.getQualifiers());
        CurrentInjectionPoint currentInjectionPoint = (CurrentInjectionPoint)this.getBeanManager().getServices().get(CurrentInjectionPoint.class);
        try {
            currentInjectionPoint.push(ip);
            Object t = Reflections.cast(this.getBeanManager().getReference(bean, this.getType(), this.getCreationalContext()));
            return t;
        }
        finally {
            currentInjectionPoint.pop();
        }
    }

    public String toString() {
        return Formats.formatAnnotations(this.getQualifiers()) + " Instance<" + Formats.formatType(this.getType()) + ">";
    }

    private Set<Bean<?>> getBeans() {
        return this.getBeanManager().getBeans(this.getType(), this.getQualifiers());
    }

    public Iterator<T> iterator() {
        return new InstanceImplIterator(this.getBeans());
    }

    public boolean isAmbiguous() {
        return this.getBeans().size() > 1;
    }

    public boolean isUnsatisfied() {
        return this.getBeans().size() == 0;
    }

    public Instance<T> select(Annotation ... qualifiers) {
        return this.selectInstance(this.getType(), qualifiers);
    }

    public <U extends T> Instance<U> select(Class<U> subtype, Annotation ... qualifiers) {
        return this.selectInstance(subtype, qualifiers);
    }

    public <U extends T> Instance<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
        return this.selectInstance(subtype.getType(), qualifiers);
    }

    private <U extends T> Instance<U> selectInstance(Type subtype, Annotation[] newQualifiers) {
        FacadeInjectionPoint modifiedInjectionPoint = new FacadeInjectionPoint(this.getBeanManager(), this.getInjectionPoint(), subtype, this.getQualifiers(), newQualifiers);
        return new InstanceImpl(modifiedInjectionPoint, this.getCreationalContext(), this.getBeanManager());
    }

    public void destroy(T instance) {
        ProxyObject proxy;
        Preconditions.checkNotNull(instance);
        if (instance instanceof ProxyObject && (proxy = (ProxyObject)instance).getHandler() instanceof ProxyMethodHandler) {
            ProxyMethodHandler handler = (ProxyMethodHandler)proxy.getHandler();
            Bean<?> bean = handler.getBean();
            Context context = this.getBeanManager().getContext(bean.getScope());
            if (context instanceof AlterableContext) {
                AlterableContext alterableContext = (AlterableContext)context;
                alterableContext.destroy(bean);
                return;
            }
            throw BeanLogger.LOG.destroyUnsupported(context);
        }
        CreationalContext ctx = this.getCreationalContext();
        if (ctx instanceof WeldCreationalContext) {
            WeldCreationalContext weldCtx = (WeldCreationalContext)Reflections.cast(ctx);
            weldCtx.destroyDependentInstance(instance);
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw BeanLogger.LOG.proxyRequired();
    }

    final class InstanceImplIterator
    implements Iterator<T> {
        private final Iterator<Bean<?>> delegate;

        private InstanceImplIterator(Set<Bean<?>> beans) {
            this.delegate = beans.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public T next() {
            return InstanceImpl.this.getBeanInstance(this.delegate.next());
        }

        @Override
        public void remove() {
            throw BeanLogger.LOG.instanceIteratorRemoveUnsupported();
        }
    }

    private static class SerializationProxy<T>
    extends AbstractFacade.AbstractFacadeSerializationProxy<T, Instance<T>> {
        private static final long serialVersionUID = 9181171328831559650L;

        public SerializationProxy(InstanceImpl<T> instance) {
            super(instance);
        }

        private Object readResolve() throws ObjectStreamException {
            return InstanceImpl.of(this.getInjectionPoint(), this.getCreationalContext(), this.getBeanManager());
        }
    }
}

