/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.builtin.ee;

import java.lang.annotation.Annotation;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.servlet.ServletContext;
import org.jboss.weld.bean.builtin.AbstractStaticallyDecorableBuiltInBean;
import org.jboss.weld.logging.ServletLogger;
import org.jboss.weld.manager.BeanManagerImpl;

public class ServletContextBean
extends AbstractStaticallyDecorableBuiltInBean<ServletContext> {
    private static ThreadLocal<ServletContext> servletContext = new ThreadLocal();

    public ServletContextBean(BeanManagerImpl beanManager) {
        super(beanManager, ServletContext.class);
    }

    @Override
    protected ServletContext newInstance(InjectionPoint ip, CreationalContext<ServletContext> creationalContext) {
        if (servletContext.get() == null) {
            throw ServletLogger.LOG.cannotInjectObjectOutsideOfServletRequest(ServletContext.class.getSimpleName(), null);
        }
        return servletContext.get();
    }

    public void destroy(ServletContext instance, CreationalContext<ServletContext> creationalContext) {
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return RequestScoped.class;
    }

    public static void setServletContext(ServletContext ctx) {
        servletContext.set(ctx);
    }

    public static void cleanup() {
        servletContext.remove();
    }
}

