/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessSyntheticAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedType;
import org.jboss.weld.annotated.slim.unbacked.UnbackedAnnotatedType;
import org.jboss.weld.resolution.QualifierInstance;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.resources.spi.AnnotationDiscovery;
import org.jboss.weld.resources.spi.ExtendedAnnotationDiscovery;
import org.jboss.weld.util.reflection.ParameterizedTypeImpl;

public class ProcessAnnotatedTypeEventResolvable
implements Resolvable {
    private static final Set<QualifierInstance> QUALIFIERS = Collections.singleton(QualifierInstance.ANY);
    private final Set<Type> types;
    private final SlimAnnotatedType<?> annotatedType;
    private final AnnotationDiscovery discovery;
    private final AnnotationDiscoveryAdapter annotationDiscoveryAdapter;

    public static ProcessAnnotatedTypeEventResolvable forProcessAnnotatedType(SlimAnnotatedType<?> annotatedType, AnnotationDiscovery discovery) {
        ParameterizedTypeImpl type = new ParameterizedTypeImpl((Type)((Object)ProcessAnnotatedType.class), new Type[]{annotatedType.getJavaClass()}, null);
        return new ProcessAnnotatedTypeEventResolvable(Sets.newHashSet((Object[])new Type[]{Object.class, type}), annotatedType, discovery);
    }

    public static ProcessAnnotatedTypeEventResolvable forProcessSyntheticAnnotatedType(SlimAnnotatedType<?> annotatedType, AnnotationDiscovery discovery) {
        ParameterizedTypeImpl type1 = new ParameterizedTypeImpl((Type)((Object)ProcessAnnotatedType.class), new Type[]{annotatedType.getJavaClass()}, null);
        ParameterizedTypeImpl type2 = new ParameterizedTypeImpl((Type)((Object)ProcessSyntheticAnnotatedType.class), new Type[]{annotatedType.getJavaClass()}, null);
        return new ProcessAnnotatedTypeEventResolvable(Sets.newHashSet((Object[])new Type[]{Object.class, type1, type2}), annotatedType, discovery);
    }

    protected ProcessAnnotatedTypeEventResolvable(Set<Type> types, SlimAnnotatedType<?> annotatedType, AnnotationDiscovery discovery) {
        this.types = types;
        this.annotatedType = annotatedType;
        this.discovery = discovery;
        this.annotationDiscoveryAdapter = discovery instanceof ExtendedAnnotationDiscovery ? new ExtendedAnnotationDiscoveryAdapter((ExtendedAnnotationDiscovery)discovery) : new BasicAnnotationDiscoveryAdapter();
    }

    @Override
    public Set<Type> getTypes() {
        return this.types;
    }

    @Override
    public Set<QualifierInstance> getQualifiers() {
        return QUALIFIERS;
    }

    public boolean containsRequiredAnnotations(Collection<Class<? extends Annotation>> requiredAnnotations) {
        return this.annotationDiscoveryAdapter.containsAnnotations(this.annotatedType, requiredAnnotations);
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return false;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return null;
    }

    @Override
    public boolean isAssignableTo(Class<?> clazz) {
        return false;
    }

    @Override
    public Class<?> getJavaClass() {
        return null;
    }

    @Override
    public Bean<?> getDeclaringBean() {
        return null;
    }

    @Override
    public boolean isDelegate() {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.types == null ? 0 : this.types.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessAnnotatedTypeEventResolvable)) {
            return false;
        }
        ProcessAnnotatedTypeEventResolvable other = (ProcessAnnotatedTypeEventResolvable)obj;
        return !(this.types == null ? other.types != null : !this.types.equals(other.types));
    }

    private class ExtendedAnnotationDiscoveryAdapter
    extends BasicAnnotationDiscoveryAdapter {
        private final ExtendedAnnotationDiscovery discovery;

        public ExtendedAnnotationDiscoveryAdapter(ExtendedAnnotationDiscovery discovery) {
            this.discovery = discovery;
        }

        @Override
        protected boolean containsAnnotation(UnbackedAnnotatedType<?> annotatedType, Collection<Class<? extends Annotation>> requiredAnnotations) {
            final HashSet<String> annotationTypeNames = new HashSet<String>();
            for (Class<? extends Annotation> requiredAnnotation : requiredAnnotations) {
                annotationTypeNames.add(requiredAnnotation.getName());
                annotationTypeNames.addAll(this.discovery.getAnnotationsAnnotatedWith(requiredAnnotation));
            }
            Predicate<Annotation> predicate = new Predicate<Annotation>(){

                public boolean apply(Annotation annotation) {
                    return annotationTypeNames.contains(annotation.annotationType().getName());
                }
            };
            return this.apply(annotatedType, predicate);
        }
    }

    private class BasicAnnotationDiscoveryAdapter
    implements AnnotationDiscoveryAdapter {
        private BasicAnnotationDiscoveryAdapter() {
        }

        @Override
        public boolean containsAnnotations(SlimAnnotatedType<?> annotatedType, Collection<Class<? extends Annotation>> requiredAnnotations) {
            if (annotatedType instanceof BackedAnnotatedType) {
                return this.containsAnnotation((BackedAnnotatedType)annotatedType, requiredAnnotations);
            }
            if (annotatedType instanceof UnbackedAnnotatedType) {
                return this.containsAnnotation((UnbackedAnnotatedType)annotatedType, requiredAnnotations);
            }
            throw new IllegalArgumentException();
        }

        protected boolean containsAnnotation(UnbackedAnnotatedType<?> annotatedType, Collection<Class<? extends Annotation>> requiredAnnotations) {
            for (final Class<? extends Annotation> requiredAnnotation : requiredAnnotations) {
                Predicate<Annotation> predicate = new Predicate<Annotation>(){

                    public boolean apply(Annotation annotation) {
                        return annotation.annotationType().equals(requiredAnnotation) || annotation.annotationType().isAnnotationPresent(requiredAnnotation);
                    }
                };
                if (!this.apply(annotatedType, predicate)) continue;
                return true;
            }
            return false;
        }

        protected boolean apply(UnbackedAnnotatedType<?> annotatedType, Predicate<Annotation> predicate) {
            for (Annotation annotation : annotatedType.getAnnotations()) {
                if (predicate.apply((Object)annotation)) {
                    return true;
                }
                if (!predicate.apply((Object)annotation)) continue;
                return true;
            }
            for (AnnotatedField annotatedField : annotatedType.getFields()) {
                for (Annotation annotation : annotatedField.getAnnotations()) {
                    if (!predicate.apply((Object)annotation)) continue;
                    return true;
                }
            }
            for (AnnotatedConstructor annotatedConstructor : annotatedType.getConstructors()) {
                for (Annotation annotation : annotatedConstructor.getAnnotations()) {
                    if (!predicate.apply((Object)annotation)) continue;
                    return true;
                }
                for (AnnotatedParameter parameter : annotatedConstructor.getParameters()) {
                    for (Annotation annotation : parameter.getAnnotations()) {
                        if (!predicate.apply((Object)annotation)) continue;
                        return true;
                    }
                }
            }
            for (AnnotatedMethod annotatedMethod : annotatedType.getMethods()) {
                for (Annotation annotation : annotatedMethod.getAnnotations()) {
                    if (!predicate.apply((Object)annotation)) continue;
                    return true;
                }
                for (AnnotatedParameter parameter : annotatedMethod.getParameters()) {
                    for (Annotation annotation : parameter.getAnnotations()) {
                        if (!predicate.apply((Object)annotation)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        protected boolean containsAnnotation(BackedAnnotatedType<?> annotatedType, Collection<Class<? extends Annotation>> requiredAnnotations) {
            for (Class<? extends Annotation> requiredAnnotation : requiredAnnotations) {
                if (!ProcessAnnotatedTypeEventResolvable.this.discovery.containsAnnotation(annotatedType.getJavaClass(), requiredAnnotation)) continue;
                return true;
            }
            return false;
        }
    }

    private static interface AnnotationDiscoveryAdapter {
        public boolean containsAnnotations(SlimAnnotatedType<?> var1, Collection<Class<? extends Annotation>> var2);
    }
}

