/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.New;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.enhanced.MethodSignature;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedTypeContext;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.DecoratorImpl;
import org.jboss.weld.bean.DisposalMethod;
import org.jboss.weld.bean.InterceptorImpl;
import org.jboss.weld.bean.ManagedBean;
import org.jboss.weld.bean.NewBean;
import org.jboss.weld.bean.NewManagedBean;
import org.jboss.weld.bean.NewSessionBean;
import org.jboss.weld.bean.ProducerField;
import org.jboss.weld.bean.ProducerMethod;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bean.builtin.AbstractBuiltInBean;
import org.jboss.weld.bean.builtin.ExtensionBean;
import org.jboss.weld.bootstrap.ObserverInitializationContext;
import org.jboss.weld.ejb.EjbDescriptors;
import org.jboss.weld.ejb.InternalEjbDescriptor;
import org.jboss.weld.injection.attributes.WeldInjectionPointAttributes;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resolution.ResolvableBuilder;
import org.jboss.weld.resolution.TypeSafeDisposerResolver;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.InjectionPoints;
import org.jboss.weld.util.cache.LoadingCacheUtils;
import org.jboss.weld.util.collections.Multimaps;
import org.jboss.weld.util.reflection.Reflections;

public class BeanDeployerEnvironment {
    private final Set<SlimAnnotatedTypeContext<?>> annotatedTypes;
    private final Set<Class<?>> vetoedClasses;
    private final LoadingCache<Class<?>, Set<AbstractClassBean<?>>> classBeanMap;
    private final LoadingCache<WeldMethodKey, Set<ProducerMethod<?, ?>>> producerMethodBeanMap;
    private final Set<ProducerField<?, ?>> producerFields;
    private final Set<RIBean<?>> beans;
    private final Set<ObserverInitializationContext<?, ?>> observers;
    private final Set<DisposalMethod<?, ?>> allDisposalBeans;
    private final Set<DisposalMethod<?, ?>> resolvedDisposalBeans;
    private final Set<DecoratorImpl<?>> decorators;
    private final Set<InterceptorImpl<?>> interceptors;
    private final EjbDescriptors ejbDescriptors;
    private final TypeSafeDisposerResolver disposalMethodResolver;
    private final ClassTransformer classTransformer;
    private final Set<EnhancedAnnotatedType<?>> newManagedBeanClasses;
    private final Map<InternalEjbDescriptor<?>, EnhancedAnnotatedType<?>> newSessionBeanDescriptorsFromInjectionPoint;
    private final BeanManagerImpl manager;

    protected BeanDeployerEnvironment(EjbDescriptors ejbDescriptors, BeanManagerImpl manager) {
        this(new HashSet(), new HashSet(), Multimaps.newConcurrentSetMultimap(), new HashSet(), Multimaps.newConcurrentSetMultimap(), new HashSet(), new HashSet(), new HashSet(), new HashSet(), new HashSet(), new HashSet(), ejbDescriptors, new HashSet(), new HashMap(), manager);
    }

    protected BeanDeployerEnvironment(Set<SlimAnnotatedTypeContext<?>> annotatedTypes, Set<Class<?>> vetoedClasses, LoadingCache<Class<?>, Set<AbstractClassBean<?>>> classBeanMap, Set<ProducerField<?, ?>> producerFields, LoadingCache<WeldMethodKey, Set<ProducerMethod<?, ?>>> producerMethodBeanMap, Set<RIBean<?>> beans, Set<ObserverInitializationContext<?, ?>> observers, Set<DisposalMethod<?, ?>> allDisposalBeans, Set<DisposalMethod<?, ?>> resolvedDisposalBeans, Set<DecoratorImpl<?>> decorators, Set<InterceptorImpl<?>> interceptors, EjbDescriptors ejbDescriptors, Set<EnhancedAnnotatedType<?>> newManagedBeanClasses, Map<InternalEjbDescriptor<?>, EnhancedAnnotatedType<?>> newSessionBeanDescriptorsFromInjectionPoint, BeanManagerImpl manager) {
        this.annotatedTypes = annotatedTypes;
        this.vetoedClasses = vetoedClasses;
        this.classBeanMap = classBeanMap;
        this.producerFields = producerFields;
        this.producerMethodBeanMap = producerMethodBeanMap;
        this.beans = beans;
        this.observers = observers;
        this.allDisposalBeans = allDisposalBeans;
        this.resolvedDisposalBeans = resolvedDisposalBeans;
        this.decorators = decorators;
        this.interceptors = interceptors;
        this.ejbDescriptors = ejbDescriptors;
        this.disposalMethodResolver = new TypeSafeDisposerResolver((Iterable<DisposalMethod<?, ?>>)allDisposalBeans);
        this.classTransformer = (ClassTransformer)manager.getServices().get(ClassTransformer.class);
        this.newManagedBeanClasses = newManagedBeanClasses;
        this.newSessionBeanDescriptorsFromInjectionPoint = newSessionBeanDescriptorsFromInjectionPoint;
        this.manager = manager;
    }

    public void addAnnotatedType(SlimAnnotatedTypeContext<?> annotatedType) {
        this.annotatedTypes.add(annotatedType);
    }

    public void addAnnotatedTypes(Collection<SlimAnnotatedTypeContext<?>> annotatedTypes) {
        this.annotatedTypes.addAll(annotatedTypes);
    }

    public void addSyntheticAnnotatedType(SlimAnnotatedType<?> annotatedType, Extension extension) {
        this.addAnnotatedType(SlimAnnotatedTypeContext.of(annotatedType, this.classTransformer, extension));
    }

    public Set<SlimAnnotatedTypeContext<?>> getAnnotatedTypes() {
        return Collections.unmodifiableSet(this.annotatedTypes);
    }

    public void removeAnnotatedType(SlimAnnotatedTypeContext<?> annotatedType) {
        this.annotatedTypes.remove(annotatedType);
    }

    public void removeAnnotatedTypes(Collection<SlimAnnotatedTypeContext<?>> annotatedTypes) {
        this.annotatedTypes.removeAll(annotatedTypes);
    }

    public void vetoJavaClass(Class<?> javaClass) {
        this.vetoedClasses.add(javaClass);
    }

    public boolean isVetoed(Class<?> clazz) {
        return this.vetoedClasses.contains(clazz);
    }

    public Set<EnhancedAnnotatedType<?>> getNewManagedBeanClasses() {
        return this.newManagedBeanClasses;
    }

    public Map<InternalEjbDescriptor<?>, EnhancedAnnotatedType<?>> getNewSessionBeanDescriptorsFromInjectionPoint() {
        return this.newSessionBeanDescriptorsFromInjectionPoint;
    }

    public Set<ProducerMethod<?, ?>> getProducerMethod(Class<?> declaringClass, MethodSignature signature) {
        WeldMethodKey key = new WeldMethodKey(declaringClass, signature);
        Set<ProducerMethod<?, ?>> beans = LoadingCacheUtils.getCacheValue(this.producerMethodBeanMap, key);
        for (ProducerMethod<?, ?> producerMethod : beans) {
            producerMethod.initialize(this);
        }
        return beans;
    }

    public Set<AbstractClassBean<?>> getClassBeans(Class<?> clazz) {
        Set<AbstractClassBean<?>> beans = LoadingCacheUtils.getCacheValue(this.classBeanMap, clazz);
        for (AbstractClassBean<?> bean : beans) {
            bean.preInitialize();
        }
        return beans;
    }

    public void addProducerMethod(ProducerMethod<?, ?> bean) {
        LoadingCacheUtils.getCacheValue(this.producerMethodBeanMap, WeldMethodKey.of(bean)).add(bean);
        this.addAbstractBean(bean);
    }

    public void addProducerField(ProducerField<?, ?> bean) {
        this.producerFields.add(bean);
        this.addAbstractBean(bean);
    }

    public void addExtension(ExtensionBean bean) {
        this.beans.add(bean);
    }

    public void addBuiltInBean(AbstractBuiltInBean<?> bean) {
        this.beans.add(bean);
    }

    protected void addAbstractClassBean(AbstractClassBean<?> bean) {
        if (!(bean instanceof NewBean)) {
            LoadingCacheUtils.getCacheValue(this.classBeanMap, bean.getBeanClass()).add(bean);
        }
        this.addAbstractBean(bean);
    }

    public void addManagedBean(ManagedBean<?> bean) {
        this.addAbstractClassBean(bean);
    }

    public void addSessionBean(SessionBean<?> bean) {
        this.addAbstractClassBean(bean);
    }

    public void addNewManagedBean(NewManagedBean<?> bean) {
        this.beans.add(bean);
    }

    public void addNewSessionBean(NewSessionBean<?> bean) {
        this.beans.add(bean);
    }

    protected void addAbstractBean(AbstractBean<?, ?> bean) {
        this.beans.add(bean);
    }

    public void addDecorator(DecoratorImpl<?> bean) {
        this.decorators.add(bean);
    }

    public void addInterceptor(InterceptorImpl<?> bean) {
        this.interceptors.add(bean);
    }

    public void addDisposesMethod(DisposalMethod<?, ?> bean) {
        this.allDisposalBeans.add(bean);
        this.addNewBeansFromInjectionPoints(bean.getInjectionPoints());
    }

    public void addObserverMethod(ObserverInitializationContext<?, ?> observerInitializer) {
        this.observers.add(observerInitializer);
        this.addNewBeansFromInjectionPoints(observerInitializer.getObserver().getInjectionPoints());
    }

    public void addNewBeansFromInjectionPoints(AbstractBean<?, ?> bean) {
        this.addNewBeansFromInjectionPoints(bean.getInjectionPoints());
    }

    public void addNewBeansFromInjectionPoints(Set<? extends InjectionPoint> injectionPoints) {
        for (InjectionPoint injectionPoint : injectionPoints) {
            Class rawType;
            WeldInjectionPointAttributes weldInjectionPoint = InjectionPoints.getWeldInjectionPoint(injectionPoint);
            if (weldInjectionPoint.getQualifier(New.class) == null || Event.class.equals(rawType = Reflections.getRawType(weldInjectionPoint.getType()))) continue;
            New _new = weldInjectionPoint.getQualifier(New.class);
            if (_new.value().equals(New.class)) {
                if (rawType.equals(Instance.class)) {
                    Type typeParameter = Reflections.getActualTypeArguments(weldInjectionPoint.getType())[0];
                    this.addNewBeanFromInjectionPoint(Reflections.getRawType(typeParameter), typeParameter);
                    continue;
                }
                this.addNewBeanFromInjectionPoint(rawType, weldInjectionPoint.getType());
                continue;
            }
            this.addNewBeanFromInjectionPoint(_new.value(), _new.value());
        }
    }

    private void addNewBeanFromInjectionPoint(Class<?> rawType, Type baseType) {
        if (this.getEjbDescriptors().contains(rawType)) {
            InternalEjbDescriptor<?> descriptor = this.getEjbDescriptors().getUnique(rawType);
            this.newSessionBeanDescriptorsFromInjectionPoint.put(descriptor, this.classTransformer.getEnhancedAnnotatedType(rawType, baseType, this.manager.getId()));
        } else {
            this.newManagedBeanClasses.add(this.classTransformer.getEnhancedAnnotatedType(rawType, baseType, this.manager.getId()));
        }
    }

    public Set<? extends RIBean<?>> getBeans() {
        return Collections.unmodifiableSet(this.beans);
    }

    public Set<DecoratorImpl<?>> getDecorators() {
        return Collections.unmodifiableSet(this.decorators);
    }

    public Set<InterceptorImpl<?>> getInterceptors() {
        return Collections.unmodifiableSet(this.interceptors);
    }

    public Set<ObserverInitializationContext<?, ?>> getObservers() {
        return Collections.unmodifiableSet(this.observers);
    }

    public Set<DisposalMethod<?, ?>> getUnresolvedDisposalBeans() {
        HashSet beans = new HashSet(this.allDisposalBeans);
        beans.removeAll(this.resolvedDisposalBeans);
        return Collections.unmodifiableSet(beans);
    }

    public EjbDescriptors getEjbDescriptors() {
        return this.ejbDescriptors;
    }

    public <X> Set<DisposalMethod<X, ?>> resolveDisposalBeans(Set<Type> types, Set<Annotation> qualifiers, AbstractClassBean<X> declaringBean) {
        Set beans = (Set)Reflections.cast(this.disposalMethodResolver.resolve(new ResolvableBuilder(this.manager).addTypes(types).addQualifiers(qualifiers).setDeclaringBean(declaringBean).create(), true));
        this.resolvedDisposalBeans.addAll(beans);
        return Collections.unmodifiableSet(beans);
    }

    public void vetoBean(AbstractBean<?, ?> bean) {
        this.beans.remove(bean);
        if (bean instanceof AbstractClassBean) {
            LoadingCacheUtils.getCacheValue(this.classBeanMap, bean.getBeanClass()).remove(bean);
            if (bean instanceof InterceptorImpl) {
                this.interceptors.remove(bean);
            }
            if (bean instanceof DecoratorImpl) {
                this.decorators.remove(bean);
            }
        }
        if (bean instanceof ProducerMethod) {
            ProducerMethod producerMethod = (ProducerMethod)Reflections.cast(bean);
            LoadingCacheUtils.getCacheValue(this.producerMethodBeanMap, WeldMethodKey.of(producerMethod)).remove(producerMethod);
        }
        if (bean instanceof ProducerField) {
            this.producerFields.remove(bean);
        }
    }

    public Iterable<AbstractClassBean<?>> getClassBeans() {
        return Iterables.concat(this.classBeanMap.asMap().values());
    }

    public Iterable<ProducerMethod<?, ?>> getProducerMethodBeans() {
        return Iterables.concat(this.producerMethodBeanMap.asMap().values());
    }

    public Set<ProducerField<?, ?>> getProducerFields() {
        return Collections.unmodifiableSet(this.producerFields);
    }

    public void cleanup() {
        this.annotatedTypes.clear();
        this.vetoedClasses.clear();
        this.classBeanMap.invalidateAll();
        this.producerMethodBeanMap.invalidateAll();
        this.producerFields.clear();
        this.allDisposalBeans.clear();
        this.resolvedDisposalBeans.clear();
        this.beans.clear();
        this.decorators.clear();
        this.interceptors.clear();
        this.observers.clear();
        this.disposalMethodResolver.clear();
        this.newManagedBeanClasses.clear();
        this.newSessionBeanDescriptorsFromInjectionPoint.clear();
    }

    protected static class WeldMethodKey {
        private final Class<?> declaringClass;
        private final MethodSignature signature;

        static WeldMethodKey of(ProducerMethod<?, ?> producerMethod) {
            return new WeldMethodKey(producerMethod.getBeanClass(), producerMethod.getEnhancedAnnotated().getSignature());
        }

        WeldMethodKey(Class<?> clazz, MethodSignature signature) {
            this.declaringClass = clazz;
            this.signature = signature;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.declaringClass == null ? 0 : this.declaringClass.hashCode());
            result = 31 * result + (this.signature == null ? 0 : this.signature.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WeldMethodKey other = (WeldMethodKey)obj;
            if (this.declaringClass == null ? other.declaringClass != null : !this.declaringClass.equals(other.declaringClass)) {
                return false;
            }
            return !(this.signature == null ? other.signature != null : !this.signature.equals(other.signature));
        }
    }
}

