/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.annotated.enhanced.ConstructorSignature;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedConstructor;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.enhanced.MethodSignature;
import org.jboss.weld.annotated.enhanced.jlr.MethodSignatureImpl;
import org.jboss.weld.annotated.slim.AnnotatedTypeIdentifier;
import org.jboss.weld.bean.proxy.InterceptedSubclassFactory;
import org.jboss.weld.injection.ConstructorInjectionPoint;
import org.jboss.weld.injection.InjectionPointFactory;
import org.jboss.weld.injection.ProxyClassConstructorInjectionPointWrapper;
import org.jboss.weld.injection.producer.AbstractInstantiator;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.Beans;

public class SubclassedComponentInstantiator<T>
extends AbstractInstantiator<T> {
    private final ConstructorInjectionPoint<T> proxyClassConstructorInjectionPoint;
    private final Constructor<T> componentClassConstructor;

    public static <T> SubclassedComponentInstantiator<T> forSubclassedEjb(EnhancedAnnotatedType<T> componentType, EnhancedAnnotatedType<T> subclass, Bean<T> bean, BeanManagerImpl manager) {
        EnhancedAnnotatedConstructor<T> componentConstructor = Beans.getBeanConstructor(componentType);
        EnhancedAnnotatedConstructor<T> subclassConstructor = SubclassedComponentInstantiator.findMatchingConstructor(componentConstructor.getSignature(), subclass);
        ConstructorInjectionPoint<T> cip = InjectionPointFactory.instance().createConstructorInjectionPoint(bean, componentType.getJavaClass(), subclassConstructor, manager);
        return new SubclassedComponentInstantiator<T>(cip, componentConstructor.getJavaMember());
    }

    public static <T> SubclassedComponentInstantiator<T> forInterceptedDecoratedBean(EnhancedAnnotatedType<T> type, Bean<T> bean, AbstractInstantiator<T> delegate, BeanManagerImpl manager) {
        return new SubclassedComponentInstantiator<T>(type, bean, delegate.getConstructorInjectionPoint(), manager);
    }

    private static <T> EnhancedAnnotatedConstructor<T> findMatchingConstructor(ConstructorSignature componentConstructor, EnhancedAnnotatedType<T> subclass) {
        return subclass.getDeclaredEnhancedConstructor(componentConstructor);
    }

    private SubclassedComponentInstantiator(ConstructorInjectionPoint<T> proxyClassConstructorInjectionPoint, Constructor<T> componentClassConstructor) {
        this.proxyClassConstructorInjectionPoint = proxyClassConstructorInjectionPoint;
        this.componentClassConstructor = componentClassConstructor;
    }

    protected SubclassedComponentInstantiator(EnhancedAnnotatedType<T> type, Bean<T> bean, ConstructorInjectionPoint<T> originalConstructor, BeanManagerImpl manager) {
        EnhancedAnnotatedConstructor<T> constructorForEnhancedSubclass = this.initEnhancedSubclass(manager, type, bean, originalConstructor);
        this.proxyClassConstructorInjectionPoint = new ProxyClassConstructorInjectionPointWrapper<T>(bean, type.getJavaClass(), constructorForEnhancedSubclass, originalConstructor, manager);
        this.componentClassConstructor = originalConstructor.getAnnotated().getJavaMember();
    }

    protected EnhancedAnnotatedConstructor<T> initEnhancedSubclass(BeanManagerImpl manager, EnhancedAnnotatedType<T> type, Bean<?> bean, ConstructorInjectionPoint<T> originalConstructorInjectionPoint) {
        ClassTransformer transformer = (ClassTransformer)manager.getServices().get(ClassTransformer.class);
        EnhancedAnnotatedType<T> enhancedSubclass = transformer.getEnhancedAnnotatedType(this.createEnhancedSubclass(type, bean, manager), ((AnnotatedTypeIdentifier)type.slim().getIdentifier()).getBdaId());
        return SubclassedComponentInstantiator.findMatchingConstructor(originalConstructorInjectionPoint.getSignature(), enhancedSubclass);
    }

    protected Class<T> createEnhancedSubclass(AnnotatedType<T> type, Bean<?> bean, BeanManagerImpl manager) {
        HashSet<MethodSignature> enhancedMethodSignatures = new HashSet<MethodSignature>();
        for (AnnotatedMethod<?> method : Beans.getInterceptableMethods(type)) {
            enhancedMethodSignatures.add(new MethodSignatureImpl(method));
        }
        Set<Class> types = null;
        types = bean == null ? Collections.singleton(type.getJavaClass()) : bean.getTypes();
        return new InterceptedSubclassFactory(manager.getContextId(), type.getJavaClass(), types, bean, enhancedMethodSignatures).getProxyClass();
    }

    public String toString() {
        return "SubclassedComponentInstantiator for " + this.proxyClassConstructorInjectionPoint.getType();
    }

    @Override
    public boolean hasInterceptorSupport() {
        return false;
    }

    @Override
    public boolean hasDecoratorSupport() {
        return false;
    }

    @Override
    public ConstructorInjectionPoint<T> getConstructorInjectionPoint() {
        return this.proxyClassConstructorInjectionPoint;
    }

    @Override
    public Constructor<T> getConstructor() {
        return this.componentClassConstructor;
    }
}

