/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection;

import java.util.EmptyStackException;
import java.util.Stack;
import org.jboss.weld.bootstrap.api.Service;

public class ThreadLocalStackService<T>
implements Service {
    private final ThreadLocal<Stack<T>> threadLocalStack = new ThreadLocal();

    public void push(T item) {
        Stack<Object> stack = this.threadLocalStack.get();
        if (stack == null) {
            stack = new Stack();
            this.threadLocalStack.set(stack);
        }
        stack.push(item);
    }

    public T pop() {
        Stack<T> stack = this.threadLocalStack.get();
        if (stack == null) {
            throw new EmptyStackException();
        }
        try {
            T t = stack.pop();
            return t;
        }
        finally {
            if (stack.isEmpty()) {
                this.threadLocalStack.remove();
            }
        }
    }

    public T peek() {
        Stack<T> stack = this.threadLocalStack.get();
        if (stack == null) {
            return null;
        }
        if (!stack.empty()) {
            return stack.peek();
        }
        return null;
    }

    public void cleanup() {
    }
}

