/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.security;

import java.lang.reflect.Method;
import java.security.PrivilegedExceptionAction;
import org.jboss.weld.security.GetDeclaredMethodAction;

public class MethodLookupAction
extends GetDeclaredMethodAction
implements PrivilegedExceptionAction<Method> {
    public MethodLookupAction(Class<?> javaClass, String methodName, Class<?>[] parameterTypes) {
        super(javaClass, methodName, parameterTypes);
    }

    @Override
    public Method run() throws NoSuchMethodException {
        return MethodLookupAction.lookupMethod(this.javaClass, this.methodName, this.parameterTypes);
    }

    public static Method lookupMethod(Class<?> javaClass, String methodName, Class<?>[] parameterTypes) throws NoSuchMethodException {
        for (Class<?> inspectedClass = javaClass; inspectedClass != null; inspectedClass = inspectedClass.getSuperclass()) {
            for (Class<?> inspectedInterface : inspectedClass.getInterfaces()) {
                try {
                    return MethodLookupAction.lookupMethod(inspectedInterface, methodName, parameterTypes);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
            try {
                return inspectedClass.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        throw new NoSuchMethodException();
    }
}

