/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.ejb;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.util.ApiAbstraction;

public class EJBApiAbstraction
extends ApiAbstraction
implements Service {
    public final Class<? extends Annotation> EJB_ANNOTATION_CLASS = this.annotationTypeForName("javax.ejb.EJB");
    public final Class<? extends Annotation> TIMEOUT_ANNOTATION_CLASS = this.annotationTypeForName("javax.ejb.Timeout");
    private final Class<? extends Annotation> TRANSACTION_MANAGEMENT = this.annotationTypeForName("javax.ejb.TransactionManagement");
    private final Object CONTAINER_MANAGED_TRANSACTION_MANAGEMENT_ENUM_VALUE;

    public EJBApiAbstraction(ResourceLoader resourceLoader) {
        super(resourceLoader);
        Class<?> TRANSACTION_MANAGEMENT_TYPE = this.classForName("javax.ejb.TransactionManagementType");
        this.CONTAINER_MANAGED_TRANSACTION_MANAGEMENT_ENUM_VALUE = TRANSACTION_MANAGEMENT_TYPE.equals(ApiAbstraction.Dummy.class) ? ApiAbstraction.DummyEnum.DUMMY_VALUE : this.enumValue(TRANSACTION_MANAGEMENT_TYPE, "CONTAINER");
    }

    public void cleanup() {
    }

    public boolean isSessionBeanWithContainerManagedTransactions(Bean<?> bean) {
        if (bean instanceof SessionBean) {
            Object value;
            SessionBean sessionBean = (SessionBean)bean;
            Annotation transactionManagementAnnotation = sessionBean.getAnnotated().getAnnotation(this.TRANSACTION_MANAGEMENT);
            if (transactionManagementAnnotation == null || transactionManagementAnnotation instanceof ApiAbstraction.DummyAnnotation) {
                return true;
            }
            try {
                Method method = transactionManagementAnnotation.annotationType().getMethod("value", new Class[0]);
                value = method.invoke((Object)transactionManagementAnnotation, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                return true;
            }
            catch (Exception e) {
                throw new WeldException(e);
            }
            return this.CONTAINER_MANAGED_TRANSACTION_MANAGEMENT_ENUM_VALUE.equals(value);
        }
        return false;
    }
}

